/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl;

import java.io.IOException;
import java.math.BigDecimal;
import org.apache.pinot.segment.spi.index.creator.ForwardIndexCreator;
import org.apache.pinot.spi.data.FieldSpec;

class SameValueForwardIndexCreator
implements ForwardIndexCreator {
    private final Object _actualValue;
    private final ForwardIndexCreator _delegate;

    public SameValueForwardIndexCreator(Object value, ForwardIndexCreator delegate) {
        this._actualValue = value;
        this._delegate = delegate;
    }

    public void seal() throws IOException {
        this._delegate.seal();
    }

    public boolean isDictionaryEncoded() {
        return false;
    }

    public boolean isSingleValue() {
        return this._delegate.isSingleValue();
    }

    public FieldSpec.DataType getValueType() {
        return this._delegate.getValueType();
    }

    public void putInt(int value) {
        this._delegate.putInt(((Integer)this._actualValue).intValue());
    }

    public void putLong(long value) {
        this._delegate.putLong(((Long)this._actualValue).longValue());
    }

    public void putFloat(float value) {
        this._delegate.putFloat(((Float)this._actualValue).floatValue());
    }

    public void putDouble(double value) {
        this._delegate.putDouble(((Double)this._actualValue).doubleValue());
    }

    public void close() throws IOException {
        this._delegate.close();
    }

    public void putDictId(int dictId) {
        throw new UnsupportedOperationException("Cannot be used with dictionaries");
    }

    public void putDictIdMV(int[] dictIds) {
        throw new UnsupportedOperationException("Cannot be used with dictionaries");
    }

    public void putBigDecimal(BigDecimal value) {
        this._delegate.putBigDecimal((BigDecimal)this._actualValue);
    }

    public void putString(String value) {
        this._delegate.putString((String)this._actualValue);
    }

    public void putBytes(byte[] value) {
        this._delegate.putBytes((byte[])this._actualValue);
    }

    public void putIntMV(int[] values) {
        this._delegate.putIntMV((int[])this._actualValue);
    }

    public void putLongMV(long[] values) {
        this._delegate.putLongMV((long[])this._actualValue);
    }

    public void putFloatMV(float[] values) {
        this._delegate.putFloatMV((float[])this._actualValue);
    }

    public void putDoubleMV(double[] values) {
        this._delegate.putDoubleMV((double[])this._actualValue);
    }

    public void putStringMV(String[] values) {
        this._delegate.putStringMV((String[])this._actualValue);
    }

    public void putBytesMV(byte[][] values) {
        this._delegate.putBytesMV((byte[][])this._actualValue);
    }
}

