/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl;

import com.google.common.base.Preconditions;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.realtime.converter.stats.RealtimeSegmentSegmentCreationDataSource;
import org.apache.pinot.segment.local.recordtransformer.ComplexTypeTransformer;
import org.apache.pinot.segment.local.recordtransformer.RecordTransformer;
import org.apache.pinot.segment.local.segment.creator.RecordReaderSegmentCreationDataSource;
import org.apache.pinot.segment.local.segment.creator.TransformPipeline;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentColumnarIndexCreator;
import org.apache.pinot.segment.local.segment.index.converter.SegmentFormatConverterFactory;
import org.apache.pinot.segment.local.segment.index.dictionary.DictionaryIndexType;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentRecordReader;
import org.apache.pinot.segment.local.startree.v2.builder.MultipleTreesBuilder;
import org.apache.pinot.segment.local.utils.CrcUtils;
import org.apache.pinot.segment.local.utils.IngestionUtils;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.converter.SegmentFormatConverter;
import org.apache.pinot.segment.spi.creator.ColumnIndexCreationInfo;
import org.apache.pinot.segment.spi.creator.ColumnStatistics;
import org.apache.pinot.segment.spi.creator.SegmentCreationDataSource;
import org.apache.pinot.segment.spi.creator.SegmentCreator;
import org.apache.pinot.segment.spi.creator.SegmentGeneratorConfig;
import org.apache.pinot.segment.spi.creator.SegmentIndexCreationDriver;
import org.apache.pinot.segment.spi.creator.SegmentPreIndexStatsContainer;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.creator.StatsCollectorConfig;
import org.apache.pinot.segment.spi.index.IndexHandler;
import org.apache.pinot.segment.spi.index.IndexService;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.creator.SegmentIndexCreationInfo;
import org.apache.pinot.segment.spi.loader.SegmentDirectoryLoaderContext;
import org.apache.pinot.segment.spi.loader.SegmentDirectoryLoaderRegistry;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.segment.spi.store.SegmentDirectoryPaths;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.IngestionSchemaValidator;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.SchemaValidatorFactory;
import org.apache.pinot.spi.data.readers.FileFormat;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;
import org.apache.pinot.spi.data.readers.RecordReaderFactory;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.recordenricher.RecordEnricherPipeline;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.ReadMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentIndexCreationDriverImpl
implements SegmentIndexCreationDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentIndexCreationDriverImpl.class);
    private SegmentGeneratorConfig _config;
    private RecordReader _recordReader;
    private SegmentPreIndexStatsContainer _segmentStats;
    private TreeMap<String, ColumnIndexCreationInfo> _indexCreationInfoMap;
    private SegmentCreator _indexCreator;
    private SegmentIndexCreationInfo _segmentIndexCreationInfo;
    private SegmentCreationDataSource _dataSource;
    private Schema _dataSchema;
    private RecordEnricherPipeline _recordEnricherPipeline;
    private TransformPipeline _transformPipeline;
    private IngestionSchemaValidator _ingestionSchemaValidator;
    private int _totalDocs = 0;
    private File _tempIndexDir;
    private String _segmentName;
    private long _totalRecordReadTimeNs = 0L;
    private long _totalIndexTimeNs = 0L;
    private long _totalStatsCollectorTimeNs = 0L;
    private boolean _continueOnError;

    public void init(SegmentGeneratorConfig config) throws Exception {
        this.init(config, this.getRecordReader(config));
    }

    private RecordReader getRecordReader(SegmentGeneratorConfig segmentGeneratorConfig) throws Exception {
        File dataFile = new File(segmentGeneratorConfig.getInputFilePath());
        Preconditions.checkState((boolean)dataFile.exists(), (Object)("Input file: " + dataFile.getAbsolutePath() + " does not exist"));
        Schema schema = segmentGeneratorConfig.getSchema();
        TableConfig tableConfig = segmentGeneratorConfig.getTableConfig();
        FileFormat fileFormat = segmentGeneratorConfig.getFormat();
        String recordReaderClassName = segmentGeneratorConfig.getRecordReaderPath();
        Set<String> sourceFields = IngestionUtils.getFieldsForRecordExtractor(tableConfig.getIngestionConfig(), segmentGeneratorConfig.getSchema());
        if (recordReaderClassName != null) {
            if (fileFormat != FileFormat.OTHER) {
                LOGGER.warn("Using class: {} to read segment, ignoring configured file format: {}", (Object)recordReaderClassName, (Object)fileFormat);
            }
            return RecordReaderFactory.getRecordReaderByClass((String)recordReaderClassName, (File)dataFile, sourceFields, (RecordReaderConfig)segmentGeneratorConfig.getReaderConfig());
        }
        if (fileFormat == FileFormat.PINOT) {
            return new PinotSegmentRecordReader(dataFile, schema, segmentGeneratorConfig.getColumnSortOrder());
        }
        return RecordReaderFactory.getRecordReader((FileFormat)fileFormat, (File)dataFile, sourceFields, (RecordReaderConfig)segmentGeneratorConfig.getReaderConfig());
    }

    public RecordReader getRecordReader() {
        return this._recordReader;
    }

    public void init(SegmentGeneratorConfig config, RecordReader recordReader) throws Exception {
        RecordReaderSegmentCreationDataSource dataSource = new RecordReaderSegmentCreationDataSource(recordReader);
        this.init(config, (SegmentCreationDataSource)dataSource, RecordEnricherPipeline.fromTableConfig((TableConfig)config.getTableConfig()), new TransformPipeline(config.getTableConfig(), config.getSchema()));
    }

    @Deprecated
    public void init(SegmentGeneratorConfig config, SegmentCreationDataSource dataSource, RecordTransformer recordTransformer, @Nullable ComplexTypeTransformer complexTypeTransformer) throws Exception {
        this.init(config, dataSource, RecordEnricherPipeline.fromTableConfig((TableConfig)config.getTableConfig()), new TransformPipeline(recordTransformer, complexTypeTransformer));
    }

    public void init(SegmentGeneratorConfig config, SegmentCreationDataSource dataSource, RecordEnricherPipeline enricherPipeline, TransformPipeline transformPipeline) throws Exception {
        this._config = config;
        this._recordReader = dataSource.getRecordReader();
        this._dataSchema = config.getSchema();
        this._continueOnError = config.isContinueOnError();
        if (config.isFailOnEmptySegment()) {
            Preconditions.checkState((boolean)this._recordReader.hasNext(), (Object)"No record in data source");
        }
        this._recordEnricherPipeline = enricherPipeline;
        this._transformPipeline = transformPipeline;
        if (dataSource instanceof RecordReaderSegmentCreationDataSource) {
            ((RecordReaderSegmentCreationDataSource)dataSource).setRecordEnricherPipeline(enricherPipeline);
            ((RecordReaderSegmentCreationDataSource)dataSource).setTransformPipeline(transformPipeline);
        }
        if (dataSource instanceof RealtimeSegmentSegmentCreationDataSource) {
            this._config.setRealtimeConversion(true);
            this._config.setConsumerDir(((RealtimeSegmentSegmentCreationDataSource)dataSource).getConsumerDir());
        }
        this._dataSource = dataSource;
        this._segmentIndexCreationInfo = new SegmentIndexCreationInfo();
        this._indexCreationInfoMap = new TreeMap();
        this._indexCreator = new SegmentColumnarIndexCreator();
        File indexDir = new File(config.getOutDir());
        if (!indexDir.exists()) {
            indexDir.mkdirs();
        }
        this._ingestionSchemaValidator = SchemaValidatorFactory.getSchemaValidator((Schema)this._dataSchema, (String)this._recordReader.getClass().getName(), (String)config.getInputFilePath());
        this._tempIndexDir = new File(indexDir, "tmp-" + UUID.randomUUID());
        LOGGER.debug("tempIndexDir:{}", (Object)this._tempIndexDir);
    }

    private int[] getImmutableToMutableIdMap(@Nullable int[] sortedDocIds) {
        if (sortedDocIds == null) {
            return null;
        }
        int[] res = new int[sortedDocIds.length];
        for (int i = 0; i < res.length; ++i) {
            res[sortedDocIds[i]] = i;
        }
        return res;
    }

    public void build() throws Exception {
        LOGGER.debug("Start building StatsCollector!");
        this.collectStatsAndIndexCreationInfo();
        LOGGER.info("Finished building StatsCollector!");
        LOGGER.info("Collected stats for {} documents", (Object)this._totalDocs);
        int incompleteRowsFound = 0;
        try {
            int[] immutableToMutableIdMap = null;
            if (this._recordReader instanceof PinotSegmentRecordReader) {
                immutableToMutableIdMap = this.getImmutableToMutableIdMap(((PinotSegmentRecordReader)this._recordReader).getSortedDocIds());
            }
            this._indexCreator.init(this._config, this._segmentIndexCreationInfo, this._indexCreationInfoMap, this._dataSchema, this._tempIndexDir, immutableToMutableIdMap);
            this._recordReader.rewind();
            LOGGER.info("Start building IndexCreator!");
            GenericRow reuse = new GenericRow();
            TransformPipeline.Result reusedResult = new TransformPipeline.Result();
            while (this._recordReader.hasNext()) {
                long recordReadStopTimeNs;
                reuse.clear();
                try {
                    GenericRow decodedRow = this._recordReader.next(reuse);
                    long recordReadStartTimeNs = System.nanoTime();
                    this._recordEnricherPipeline.run(decodedRow);
                    this._transformPipeline.processRow(decodedRow, reusedResult);
                    recordReadStopTimeNs = System.nanoTime();
                    this._totalRecordReadTimeNs += recordReadStopTimeNs - recordReadStartTimeNs;
                }
                catch (Exception e) {
                    if (!this._continueOnError) {
                        throw new RuntimeException("Error occurred while reading row during indexing", e);
                    }
                    ++incompleteRowsFound;
                    LOGGER.debug("Error occurred while reading row during indexing", (Throwable)e);
                    continue;
                }
                for (GenericRow row : reusedResult.getTransformedRows()) {
                    this._indexCreator.indexRow(row);
                }
                this._totalIndexTimeNs += System.nanoTime() - recordReadStopTimeNs;
                incompleteRowsFound += reusedResult.getIncompleteRowCount();
            }
        }
        catch (Exception e) {
            this._indexCreator.close();
            throw e;
        }
        finally {
            this._recordReader.close();
        }
        if (incompleteRowsFound > 0) {
            LOGGER.warn("Incomplete data found for {} records. This can be due to error during reader or transformations", (Object)incompleteRowsFound);
        }
        LOGGER.info("Finished records indexing in IndexCreator!");
        this.handlePostCreation();
    }

    public void buildByColumn(IndexSegment indexSegment) throws Exception {
        LOGGER.debug("Start building StatsCollector!");
        this.collectStatsAndIndexCreationInfo();
        LOGGER.info("Finished building StatsCollector!");
        LOGGER.info("Collected stats for {} documents", (Object)this._totalDocs);
        try {
            int[] sortedDocIds = ((PinotSegmentRecordReader)this._recordReader).getSortedDocIds();
            int[] immutableToMutableIdMap = this.getImmutableToMutableIdMap(sortedDocIds);
            this._indexCreator.init(this._config, this._segmentIndexCreationInfo, this._indexCreationInfoMap, this._dataSchema, this._tempIndexDir, immutableToMutableIdMap);
            LOGGER.info("Start building Index by column");
            TreeSet columns = this._dataSchema.getPhysicalColumnNames();
            for (String col : columns) {
                this._indexCreator.indexColumn(col, sortedDocIds, indexSegment);
            }
        }
        catch (Exception e) {
            this._indexCreator.close();
            throw e;
        }
        finally {
            this._recordReader.close();
        }
        LOGGER.info("Finished records indexing by column in IndexCreator!");
        this.handlePostCreation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePostCreation() throws Exception {
        long creationTime;
        ColumnStatistics timeColumnStatistics = this._segmentStats.getColumnProfileFor(this._config.getTimeColumnName());
        int sequenceId = this._config.getSequenceId();
        if (timeColumnStatistics != null) {
            if (this._totalDocs > 0) {
                this._segmentName = this._config.getSegmentNameGenerator().generateSegmentName(sequenceId, timeColumnStatistics.getMinValue(), timeColumnStatistics.getMaxValue());
            } else {
                Preconditions.checkArgument((!this._config.isFailOnEmptySegment() ? 1 : 0) != 0, (Object)("Failing the empty segment creation as the option 'failOnEmptySegment' is set to: " + this._config.isFailOnEmptySegment()));
                long now = System.currentTimeMillis();
                this._segmentName = this._config.getSegmentNameGenerator().generateSegmentName(sequenceId, (Object)now, (Object)now);
            }
        } else {
            this._segmentName = this._config.getSegmentNameGenerator().generateSegmentName(sequenceId, null, null);
        }
        try {
            this._indexCreator.setSegmentName(this._segmentName);
            this._indexCreator.seal();
        }
        finally {
            this._indexCreator.close();
        }
        LOGGER.info("Finished segment seal!");
        File outputDir = new File(this._config.getOutDir());
        File segmentOutputDir = new File(outputDir, this._segmentName);
        if (segmentOutputDir.exists()) {
            FileUtils.deleteDirectory((File)segmentOutputDir);
        }
        FileUtils.moveDirectory((File)this._tempIndexDir, (File)segmentOutputDir);
        FileUtils.deleteQuietly((File)this._tempIndexDir);
        this.convertFormatIfNecessary(segmentOutputDir);
        if (this._totalDocs > 0) {
            this.buildStarTreeV2IfNecessary(segmentOutputDir);
        }
        this.updatePostSegmentCreationIndexes(segmentOutputDir);
        long crc = CrcUtils.forAllFilesInFolder(segmentOutputDir).computeCrc();
        String creationTimeInConfig = this._config.getCreationTime();
        if (creationTimeInConfig != null) {
            try {
                creationTime = Long.parseLong(creationTimeInConfig);
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while parsing creation time in config, use current time as creation time");
                creationTime = System.currentTimeMillis();
            }
        } else {
            creationTime = System.currentTimeMillis();
        }
        SegmentIndexCreationDriverImpl.persistCreationMeta(segmentOutputDir, crc, creationTime);
        LOGGER.info("Driver, record read time (in ms) : {}", (Object)TimeUnit.NANOSECONDS.toMillis(this._totalRecordReadTimeNs));
        LOGGER.info("Driver, stats collector time (in ms) : {}", (Object)TimeUnit.NANOSECONDS.toMillis(this._totalStatsCollectorTimeNs));
        LOGGER.info("Driver, indexing time (in ms) : {}", (Object)TimeUnit.NANOSECONDS.toMillis(this._totalIndexTimeNs));
    }

    private void updatePostSegmentCreationIndexes(File indexDir) throws Exception {
        Set postSegCreationIndexes = IndexService.getInstance().getAllIndexes().stream().filter(indexType -> indexType.getIndexBuildLifecycle() == IndexType.BuildLifecycle.POST_SEGMENT_CREATION).collect(Collectors.toSet());
        if (postSegCreationIndexes.size() > 0) {
            HashMap<String, ReadMode> props = new HashMap<String, ReadMode>();
            props.put("readMode", ReadMode.mmap);
            PinotConfiguration segmentDirectoryConfigs = new PinotConfiguration(props);
            SegmentDirectoryLoaderContext segmentLoaderContext = new SegmentDirectoryLoaderContext.Builder().setTableConfig(this._config.getTableConfig()).setSchema(this._config.getSchema()).setSegmentName(this._segmentName).setSegmentDirectoryConfigs(segmentDirectoryConfigs).build();
            IndexLoadingConfig indexLoadingConfig = new IndexLoadingConfig(null, this._config.getTableConfig(), this._config.getSchema());
            try (SegmentDirectory segmentDirectory = SegmentDirectoryLoaderRegistry.getDefaultSegmentDirectoryLoader().load(indexDir.toURI(), segmentLoaderContext);
                 SegmentDirectory.Writer segmentWriter = segmentDirectory.createWriter();){
                for (IndexType indexType2 : postSegCreationIndexes) {
                    IndexHandler handler = indexType2.createIndexHandler(segmentDirectory, indexLoadingConfig.getFieldIndexConfigByColName(), this._config.getSchema(), this._config.getTableConfig());
                    handler.updateIndices(segmentWriter);
                }
            }
        }
    }

    private void buildStarTreeV2IfNecessary(File indexDir) throws Exception {
        List starTreeIndexConfigs = this._config.getStarTreeIndexConfigs();
        boolean enableDefaultStarTree = this._config.isEnableDefaultStarTree();
        if (CollectionUtils.isNotEmpty((Collection)starTreeIndexConfigs) || enableDefaultStarTree) {
            MultipleTreesBuilder.BuildMode buildMode = this._config.isOnHeap() ? MultipleTreesBuilder.BuildMode.ON_HEAP : MultipleTreesBuilder.BuildMode.OFF_HEAP;
            try (MultipleTreesBuilder builder = new MultipleTreesBuilder(starTreeIndexConfigs, enableDefaultStarTree, indexDir, buildMode);){
                builder.build();
            }
        }
    }

    private void convertFormatIfNecessary(File segmentDirectory) throws Exception {
        SegmentVersion versionToGenerate = this._config.getSegmentVersion();
        if (versionToGenerate.equals((Object)SegmentVersion.v1)) {
            return;
        }
        SegmentFormatConverter converter = SegmentFormatConverterFactory.getConverter(SegmentVersion.v1, SegmentVersion.v3);
        converter.convert(segmentDirectory);
    }

    public ColumnStatistics getColumnStatisticsCollector(String columnName) throws Exception {
        return this._segmentStats.getColumnProfileFor(columnName);
    }

    public static void persistCreationMeta(File indexDir, long crc, long creationTime) throws IOException {
        File segmentDir = SegmentDirectoryPaths.findSegmentDirectory((File)indexDir);
        File creationMetaFile = new File(segmentDir, "creation.meta");
        try (DataOutputStream output = new DataOutputStream(new FileOutputStream(creationMetaFile));){
            output.writeLong(crc);
            output.writeLong(creationTime);
        }
    }

    void collectStatsAndIndexCreationInfo() throws Exception {
        long statsCollectorStartTime = System.nanoTime();
        this._segmentStats = this._dataSource.gatherStats(new StatsCollectorConfig(this._config.getTableConfig(), this._dataSchema, this._config.getSegmentPartitionConfig()));
        this._totalDocs = this._segmentStats.getTotalDocCount();
        HashSet<String> varLengthDictionaryColumns = new HashSet<String>(this._config.getVarLengthDictionaryColumns());
        Set rawIndexCreationColumns = this._config.getRawIndexCreationColumns();
        Set rawIndexCompressionTypeKeys = this._config.getRawIndexCompressionType().keySet();
        for (FieldSpec fieldSpec : this._dataSchema.getAllFieldSpecs()) {
            if (fieldSpec.isVirtualColumn()) continue;
            String columnName = fieldSpec.getName();
            FieldSpec.DataType storedType = fieldSpec.getDataType().getStoredType();
            ColumnStatistics columnProfile = this._segmentStats.getColumnProfileFor(columnName);
            boolean useVarLengthDictionary = SegmentIndexCreationDriverImpl.shouldUseVarLengthDictionary(columnName, varLengthDictionaryColumns, storedType, columnProfile);
            Object defaultNullValue = fieldSpec.getDefaultNullValue();
            if (storedType == FieldSpec.DataType.BYTES) {
                defaultNullValue = new ByteArray((byte[])defaultNullValue);
            }
            boolean createDictionary = !rawIndexCreationColumns.contains(columnName) && !rawIndexCompressionTypeKeys.contains(columnName);
            this._indexCreationInfoMap.put(columnName, new ColumnIndexCreationInfo(columnProfile, createDictionary, useVarLengthDictionary, false, defaultNullValue));
        }
        this._segmentIndexCreationInfo.setTotalDocs(this._totalDocs);
        this._totalStatsCollectorTimeNs = System.nanoTime() - statsCollectorStartTime;
    }

    @Deprecated
    public static boolean shouldUseVarLengthDictionary(String columnName, Set<String> varLengthDictColumns, FieldSpec.DataType columnStoredType, ColumnStatistics columnProfile) {
        return DictionaryIndexType.shouldUseVarLengthDictionary(columnName, varLengthDictColumns, columnStoredType, columnProfile);
    }

    public String getSegmentName() {
        return this._segmentName;
    }

    public File getOutputDirectory() {
        return new File(new File(this._config.getOutDir()), this._segmentName);
    }

    public IngestionSchemaValidator getIngestionSchemaValidator() {
        return this._ingestionSchemaValidator;
    }

    public SegmentPreIndexStatsContainer getSegmentStats() {
        return this._segmentStats;
    }
}

