/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.fwd;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import org.apache.pinot.segment.local.io.writer.impl.VarByteChunkForwardIndexWriter;
import org.apache.pinot.segment.local.io.writer.impl.VarByteChunkForwardIndexWriterV4;
import org.apache.pinot.segment.local.io.writer.impl.VarByteChunkWriter;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.ForwardIndexUtils;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.index.creator.ForwardIndexCreator;
import org.apache.pinot.spi.data.FieldSpec;

public class MultiValueVarByteRawIndexCreator
implements ForwardIndexCreator {
    private final VarByteChunkWriter _indexWriter;
    private final FieldSpec.DataType _valueType;

    public MultiValueVarByteRawIndexCreator(File baseIndexDir, ChunkCompressionType compressionType, String column, int totalDocs, FieldSpec.DataType valueType, int maxRowLengthInBytes, int maxNumberOfElements) throws IOException {
        this(baseIndexDir, compressionType, column, totalDocs, valueType, 2, maxRowLengthInBytes, maxNumberOfElements, 0x100000, 1000);
    }

    public MultiValueVarByteRawIndexCreator(File baseIndexDir, ChunkCompressionType compressionType, String column, int totalDocs, FieldSpec.DataType valueType, int writerVersion, int maxRowLengthInBytes, int maxNumberOfElements, int targetMaxChunkSizeBytes, int targetDocsPerChunk) throws IOException {
        File file = new File(baseIndexDir, column + ".mv.raw.fwd");
        int totalMaxLength = MultiValueVarByteRawIndexCreator.getTotalRowStorageBytes(maxNumberOfElements, maxRowLengthInBytes);
        if (writerVersion < 4) {
            int numDocsPerChunk = Math.max(targetMaxChunkSizeBytes / (totalMaxLength + 4), 1);
            this._indexWriter = new VarByteChunkForwardIndexWriter(file, compressionType, totalDocs, numDocsPerChunk, totalMaxLength, writerVersion);
        } else {
            int chunkSize = ForwardIndexUtils.getDynamicTargetChunkSize(totalMaxLength, targetDocsPerChunk, targetMaxChunkSizeBytes);
            this._indexWriter = new VarByteChunkForwardIndexWriterV4(file, compressionType, chunkSize);
        }
        this._valueType = valueType;
    }

    public boolean isDictionaryEncoded() {
        return false;
    }

    public boolean isSingleValue() {
        return false;
    }

    public FieldSpec.DataType getValueType() {
        return this._valueType;
    }

    public void putStringMV(String[] values) {
        this._indexWriter.putStringMV(values);
    }

    public void putBytesMV(byte[][] values) {
        this._indexWriter.putBytesMV(values);
    }

    public void close() throws IOException {
        this._indexWriter.close();
    }

    public static int getElementLengthStoragePrefixInBytes(int maxNumberOfElements) {
        return 4 * maxNumberOfElements;
    }

    public static int getNumElementsStoragePrefix() {
        return 4;
    }

    public static int getTotalRowStorageBytes(int maxNumberOfElements, int maxRowDataLengthInBytes) {
        int numElementsStoragePrefixInBytes;
        int totalMaxLength;
        int elementLengthStoragePrefixInBytes = MultiValueVarByteRawIndexCreator.getElementLengthStoragePrefixInBytes(maxNumberOfElements);
        Preconditions.checkArgument(((elementLengthStoragePrefixInBytes | maxRowDataLengthInBytes | (totalMaxLength = elementLengthStoragePrefixInBytes + (numElementsStoragePrefixInBytes = MultiValueVarByteRawIndexCreator.getNumElementsStoragePrefix()) + maxRowDataLengthInBytes) | maxNumberOfElements) > 0 ? 1 : 0) != 0, (Object)"integer overflow detected");
        return totalMaxLength;
    }

    public static int getMaxRowDataLengthInBytes(int totalMaxLength, int maxNumberOfElements) {
        return totalMaxLength - MultiValueVarByteRawIndexCreator.getNumElementsStoragePrefix() - MultiValueVarByteRawIndexCreator.getElementLengthStoragePrefixInBytes(maxNumberOfElements);
    }
}

