/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.fwd;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import org.apache.pinot.segment.local.io.writer.impl.VarByteChunkForwardIndexWriter;
import org.apache.pinot.segment.local.io.writer.impl.VarByteChunkForwardIndexWriterV4;
import org.apache.pinot.segment.local.io.writer.impl.VarByteChunkWriter;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.ForwardIndexUtils;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.index.creator.ForwardIndexCreator;
import org.apache.pinot.spi.data.FieldSpec;

public class SingleValueVarByteRawIndexCreator
implements ForwardIndexCreator {
    private final VarByteChunkWriter _indexWriter;
    private final FieldSpec.DataType _valueType;

    public SingleValueVarByteRawIndexCreator(File baseIndexDir, ChunkCompressionType compressionType, String column, int totalDocs, FieldSpec.DataType valueType, int maxLength) throws IOException {
        this(baseIndexDir, compressionType, column, totalDocs, valueType, maxLength, false, 2, 0x100000, 1000);
    }

    public SingleValueVarByteRawIndexCreator(File baseIndexDir, ChunkCompressionType compressionType, String column, int totalDocs, FieldSpec.DataType valueType, int maxLength, boolean deriveNumDocsPerChunk, int writerVersion, int targetMaxChunkSizeBytes, int targetDocsPerChunk) throws IOException {
        File file = new File(baseIndexDir, column + ".sv.raw.fwd");
        if (writerVersion < 4) {
            int numDocsPerChunk = deriveNumDocsPerChunk ? SingleValueVarByteRawIndexCreator.getNumDocsPerChunk(maxLength, targetMaxChunkSizeBytes) : targetDocsPerChunk;
            this._indexWriter = new VarByteChunkForwardIndexWriter(file, compressionType, totalDocs, numDocsPerChunk, maxLength, writerVersion);
        } else {
            int chunkSize = ForwardIndexUtils.getDynamicTargetChunkSize(maxLength, targetDocsPerChunk, targetMaxChunkSizeBytes);
            this._indexWriter = new VarByteChunkForwardIndexWriterV4(file, compressionType, chunkSize);
        }
        this._valueType = valueType;
    }

    @VisibleForTesting
    public static int getNumDocsPerChunk(int lengthOfLongestEntry, int targetMaxChunkSizeBytes) {
        int overheadPerEntry = lengthOfLongestEntry + 4;
        return Math.max(targetMaxChunkSizeBytes / overheadPerEntry, 1);
    }

    public boolean isDictionaryEncoded() {
        return false;
    }

    public boolean isSingleValue() {
        return true;
    }

    public FieldSpec.DataType getValueType() {
        return this._valueType;
    }

    public void putBigDecimal(BigDecimal value) {
        this._indexWriter.putBigDecimal(value);
    }

    public void putString(String value) {
        this._indexWriter.putString(value);
    }

    public void putBytes(byte[] value) {
        this._indexWriter.putBytes(value);
    }

    public void close() throws IOException {
        this._indexWriter.close();
    }
}

