/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.nullvalue;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.index.IndexCreator;
import org.roaringbitmap.RoaringBitmap;
import org.roaringbitmap.RoaringBitmapWriter;

public class NullValueVectorCreator
implements IndexCreator {
    private final RoaringBitmapWriter<RoaringBitmap> _bitmapWriter = RoaringBitmapWriter.writer().get();
    private final File _nullValueVectorFile;

    public void add(@Nonnull Object value, int dictId) throws IOException {
        throw new UnsupportedOperationException("NullValueVector should not be built as a normal index");
    }

    public void add(@Nonnull Object[] values, @Nullable int[] dictIds) throws IOException {
        throw new UnsupportedOperationException("NullValueVector should not be built as a normal index");
    }

    public NullValueVectorCreator(File indexDir, String columnName) {
        this._nullValueVectorFile = new File(indexDir, columnName + ".bitmap.nullvalue");
    }

    public void setNull(int docId) {
        this._bitmapWriter.add(docId);
    }

    public void seal() throws IOException {
        RoaringBitmap nullBitmap = (RoaringBitmap)this._bitmapWriter.get();
        if (!nullBitmap.isEmpty()) {
            try (DataOutputStream outputStream = new DataOutputStream(new FileOutputStream(this._nullValueVectorFile));){
                nullBitmap.serialize((DataOutput)outputStream);
            }
        }
    }

    @VisibleForTesting
    RoaringBitmap getNullBitmap() {
        return (RoaringBitmap)this._bitmapWriter.get();
    }

    public void close() {
    }
}

