/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.stats;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.pinot.segment.local.segment.creator.impl.stats.AbstractColumnStatisticsCollector;
import org.apache.pinot.segment.spi.creator.StatsCollectorConfig;
import org.apache.pinot.spi.utils.BigDecimalUtils;

public class BigDecimalColumnPreIndexStatsCollector
extends AbstractColumnStatisticsCollector {
    private ObjectOpenHashSet<BigDecimal> _values = new ObjectOpenHashSet(1000);
    private int _minLength = Integer.MAX_VALUE;
    private int _maxLength = 0;
    private int _maxRowLength = 0;
    private BigDecimal[] _sortedValues;
    private boolean _sealed = false;

    public BigDecimalColumnPreIndexStatsCollector(String column, StatsCollectorConfig statsCollectorConfig) {
        super(column, statsCollectorConfig);
    }

    @Override
    public void collect(Object entry) {
        assert (!this._sealed);
        if (entry instanceof Object[]) {
            throw new UnsupportedOperationException();
        }
        BigDecimal value = (BigDecimal)entry;
        int length = BigDecimalUtils.byteSize((BigDecimal)value);
        this.addressSorted(value);
        if (this._values.add((Object)value)) {
            if (this.isPartitionEnabled()) {
                this.updatePartition(value.toPlainString());
            }
            this._minLength = Math.min(this._minLength, length);
            this._maxRowLength = this._maxLength = Math.max(this._maxLength, length);
        }
        ++this._totalNumberOfEntries;
    }

    public BigDecimal getMinValue() {
        if (this._sealed) {
            return this._sortedValues[0];
        }
        throw new IllegalStateException("you must seal the collector first before asking for min value");
    }

    public BigDecimal getMaxValue() {
        if (this._sealed) {
            return this._sortedValues[this._sortedValues.length - 1];
        }
        throw new IllegalStateException("you must seal the collector first before asking for max value");
    }

    public BigDecimal[] getUniqueValuesSet() {
        if (this._sealed) {
            return this._sortedValues;
        }
        throw new IllegalStateException("you must seal the collector first before asking for unique values set");
    }

    @Override
    public int getLengthOfShortestElement() {
        return this._minLength;
    }

    @Override
    public int getLengthOfLargestElement() {
        if (this._sealed) {
            return this._maxLength;
        }
        throw new IllegalStateException("you must seal the collector first before asking for longest value");
    }

    public int getMaxRowLengthInBytes() {
        return this._maxRowLength;
    }

    public int getCardinality() {
        if (this._sealed) {
            return this._sortedValues.length;
        }
        throw new IllegalStateException("you must seal the collector first before asking for cardinality");
    }

    @Override
    public void seal() {
        if (!this._sealed) {
            this._sortedValues = (BigDecimal[])this._values.toArray((Object[])new BigDecimal[0]);
            this._values = null;
            Arrays.sort(this._sortedValues);
            this._sealed = true;
        }
    }
}

