/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.stats;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Arrays;
import org.apache.pinot.segment.local.segment.creator.impl.stats.AbstractColumnStatisticsCollector;
import org.apache.pinot.segment.spi.creator.StatsCollectorConfig;

public class LongColumnPreIndexStatsCollector
extends AbstractColumnStatisticsCollector {
    private LongSet _values = new LongOpenHashSet(1000);
    private long[] _sortedValues;
    private boolean _sealed = false;
    private long _prevValue = Long.MIN_VALUE;

    public LongColumnPreIndexStatsCollector(String column, StatsCollectorConfig statsCollectorConfig) {
        super(column, statsCollectorConfig);
    }

    @Override
    public void collect(Object entry) {
        assert (!this._sealed);
        if (entry instanceof Object[]) {
            Object[] values;
            for (Object obj : values = (Object[])entry) {
                long value = (Long)obj;
                this._values.add(value);
            }
            this._maxNumberOfMultiValues = Math.max(this._maxNumberOfMultiValues, values.length);
            this.updateTotalNumberOfEntries(values);
        } else if (entry instanceof long[]) {
            long[] values;
            for (long value : values = (long[])entry) {
                this._values.add(value);
            }
            this._maxNumberOfMultiValues = Math.max(this._maxNumberOfMultiValues, values.length);
            this.updateTotalNumberOfEntries(values.length);
        } else {
            long value = (Long)entry;
            this.addressSorted(value);
            if (this._values.add(value) && this.isPartitionEnabled()) {
                this.updatePartition(Long.toString(value));
            }
            ++this._totalNumberOfEntries;
        }
    }

    private void addressSorted(long entry) {
        if (this._sorted) {
            this._sorted = entry >= this._prevValue;
            this._prevValue = entry;
        }
    }

    public Long getMinValue() {
        if (this._sealed) {
            return this._sortedValues[0];
        }
        throw new IllegalStateException("you must seal the collector first before asking for min value");
    }

    public Long getMaxValue() {
        if (this._sealed) {
            return this._sortedValues[this._sortedValues.length - 1];
        }
        throw new IllegalStateException("you must seal the collector first before asking for max value");
    }

    public Object getUniqueValuesSet() {
        if (this._sealed) {
            return this._sortedValues;
        }
        throw new IllegalStateException("you must seal the collector first before asking for unique values set");
    }

    public int getCardinality() {
        if (this._sealed) {
            return this._sortedValues.length;
        }
        throw new IllegalStateException("you must seal the collector first before asking for cardinality");
    }

    @Override
    public void seal() {
        if (!this._sealed) {
            this._sortedValues = this._values.toLongArray();
            this._values = null;
            Arrays.sort(this._sortedValues);
            this._sealed = true;
        }
    }
}

