/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.datasource;

import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.realtime.impl.nullvalue.MutableNullValueVector;
import org.apache.pinot.segment.local.segment.index.datasource.BaseDataSource;
import org.apache.pinot.segment.spi.datasource.DataSourceMetadata;
import org.apache.pinot.segment.spi.index.IndexReader;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.column.ColumnIndexContainer;
import org.apache.pinot.segment.spi.index.mutable.MutableDictionary;
import org.apache.pinot.segment.spi.index.mutable.MutableIndex;
import org.apache.pinot.segment.spi.partition.PartitionFunction;
import org.apache.pinot.spi.data.FieldSpec;

public class MutableDataSource
extends BaseDataSource {
    public MutableDataSource(FieldSpec fieldSpec, int numDocs, int numValues, int maxNumValuesPerMVEntry, int cardinality, @Nullable PartitionFunction partitionFunction, @Nullable Set<Integer> partitions, @Nullable Comparable minValue, @Nullable Comparable maxValue, Map<IndexType, MutableIndex> mutableIndexes, @Nullable MutableDictionary dictionary, @Nullable MutableNullValueVector nullValueVector, int maxRowLengthInBytes) {
        super(new MutableDataSourceMetadata(fieldSpec, numDocs, numValues, maxNumValuesPerMVEntry, cardinality, partitionFunction, partitions, minValue, maxValue, maxRowLengthInBytes), (ColumnIndexContainer)new ColumnIndexContainer.FromMap.Builder().withAll(mutableIndexes).with(StandardIndexes.dictionary(), (IndexReader)dictionary).with(StandardIndexes.nullValueVector(), (IndexReader)nullValueVector).build());
    }

    private static class MutableDataSourceMetadata
    implements DataSourceMetadata {
        final FieldSpec _fieldSpec;
        final int _numDocs;
        final int _numValues;
        final int _maxNumValuesPerMVEntry;
        final int _cardinality;
        final PartitionFunction _partitionFunction;
        final Set<Integer> _partitions;
        final Comparable _minValue;
        final Comparable _maxValue;
        final int _maxRowLengthInBytes;

        MutableDataSourceMetadata(FieldSpec fieldSpec, int numDocs, int numValues, int maxNumValuesPerMVEntry, int cardinality, @Nullable PartitionFunction partitionFunction, @Nullable Set<Integer> partitions, @Nullable Comparable minValue, @Nullable Comparable maxValue, int maxRowLengthInBytes) {
            this._fieldSpec = fieldSpec;
            this._numDocs = numDocs;
            this._numValues = numValues;
            this._maxNumValuesPerMVEntry = maxNumValuesPerMVEntry;
            if (partitionFunction != null) {
                this._partitionFunction = partitionFunction;
                this._partitions = partitions;
            } else {
                this._partitionFunction = null;
                this._partitions = null;
            }
            this._minValue = minValue;
            this._maxValue = maxValue;
            this._cardinality = cardinality;
            this._maxRowLengthInBytes = maxRowLengthInBytes;
        }

        public FieldSpec getFieldSpec() {
            return this._fieldSpec;
        }

        public boolean isSorted() {
            return false;
        }

        public int getNumDocs() {
            return this._numDocs;
        }

        public int getNumValues() {
            return this._numValues;
        }

        public int getMaxNumValuesPerMVEntry() {
            return this._maxNumValuesPerMVEntry;
        }

        @Nullable
        public Comparable getMinValue() {
            return this._minValue;
        }

        public Comparable getMaxValue() {
            return this._maxValue;
        }

        @Nullable
        public PartitionFunction getPartitionFunction() {
            return this._partitionFunction;
        }

        @Nullable
        public Set<Integer> getPartitions() {
            return this._partitions;
        }

        public int getCardinality() {
            return this._cardinality;
        }

        public int getMaxRowLengthInBytes() {
            return this._maxRowLengthInBytes;
        }
    }
}

