/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.utils.config.TableConfigUtils;
import org.apache.pinot.segment.local.segment.index.loader.ConfigurableFromIndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.columnminmaxvalue.ColumnMinMaxValueGeneratorMode;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.index.ColumnConfigDeserializer;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.FieldIndexConfigsUtil;
import org.apache.pinot.segment.spi.index.IndexConfigDeserializer;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.RangeIndexConfig;
import org.apache.pinot.segment.spi.index.creator.H3IndexConfig;
import org.apache.pinot.segment.spi.index.creator.VectorIndexConfig;
import org.apache.pinot.spi.config.instance.InstanceDataManagerConfig;
import org.apache.pinot.spi.config.table.BloomFilterConfig;
import org.apache.pinot.spi.config.table.FSTType;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.config.table.IndexConfig;
import org.apache.pinot.spi.config.table.IndexingConfig;
import org.apache.pinot.spi.config.table.JsonIndexConfig;
import org.apache.pinot.spi.config.table.StarTreeIndexConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.DimensionFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.utils.ReadMode;
import org.apache.pinot.spi.utils.TimestampIndexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexLoadingConfig {
    private static final int DEFAULT_REALTIME_AVG_MULTI_VALUE_COUNT = 2;
    public static final String READ_MODE_KEY = "readMode";
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexLoadingConfig.class);
    private InstanceDataManagerConfig _instanceDataManagerConfig = null;
    private ReadMode _readMode = ReadMode.DEFAULT_MODE;
    private List<String> _sortedColumns = Collections.emptyList();
    private Set<String> _invertedIndexColumns = new HashSet<String>();
    private Set<String> _rangeIndexColumns = new HashSet<String>();
    private int _rangeIndexVersion = RangeIndexConfig.DEFAULT.getVersion();
    private Set<String> _textIndexColumns = new HashSet<String>();
    private Set<String> _fstIndexColumns = new HashSet<String>();
    private FSTType _fstIndexType = FSTType.LUCENE;
    private Map<String, JsonIndexConfig> _jsonIndexConfigs = new HashMap<String, JsonIndexConfig>();
    private Map<String, H3IndexConfig> _h3IndexConfigs = new HashMap<String, H3IndexConfig>();
    private Map<String, VectorIndexConfig> _vectorIndexConfigs = new HashMap<String, VectorIndexConfig>();
    private Set<String> _noDictionaryColumns = new HashSet<String>();
    private final Map<String, String> _noDictionaryConfig = new HashMap<String, String>();
    private final Set<String> _varLengthDictionaryColumns = new HashSet<String>();
    private Set<String> _onHeapDictionaryColumns = new HashSet<String>();
    private Set<String> _forwardIndexDisabledColumns = new HashSet<String>();
    private Map<String, BloomFilterConfig> _bloomFilterConfigs = new HashMap<String, BloomFilterConfig>();
    private boolean _enableDynamicStarTreeCreation;
    private List<StarTreeIndexConfig> _starTreeIndexConfigs;
    private boolean _enableDefaultStarTree;
    private Map<String, FieldConfig.CompressionCodec> _compressionConfigs = new HashMap<String, FieldConfig.CompressionCodec>();
    private Map<String, FieldIndexConfigs> _indexConfigsByColName = new HashMap<String, FieldIndexConfigs>();
    private SegmentVersion _segmentVersion;
    private ColumnMinMaxValueGeneratorMode _columnMinMaxValueGeneratorMode = ColumnMinMaxValueGeneratorMode.DEFAULT_MODE;
    private int _realtimeAvgMultiValueCount = 2;
    private boolean _isRealtimeOffHeapAllocation;
    private boolean _isDirectRealtimeOffHeapAllocation;
    private String _segmentStoreURI;
    private boolean _errorOnColumnBuildFailure;
    private Map<String, Map<String, String>> _columnProperties = new HashMap<String, Map<String, String>>();
    @Nullable
    private TableConfig _tableConfig;
    private Schema _schema;
    private String _tableDataDir;
    private String _segmentDirectoryLoader;
    private String _segmentTier;
    private String _instanceId;
    private Map<String, Map<String, String>> _instanceTierConfigs;
    private boolean _dirty = true;
    private Set<String> _knownColumns = null;

    public IndexLoadingConfig(InstanceDataManagerConfig instanceDataManagerConfig, TableConfig tableConfig, @Nullable Schema schema) {
        this.extractFromInstanceConfig(instanceDataManagerConfig);
        this.extractFromTableConfigAndSchema(tableConfig, schema);
    }

    @VisibleForTesting
    public IndexLoadingConfig(InstanceDataManagerConfig instanceDataManagerConfig, TableConfig tableConfig) {
        this(instanceDataManagerConfig, tableConfig, null);
    }

    public IndexLoadingConfig(TableConfig tableConfig, @Nullable Schema schema) {
        this.extractFromTableConfigAndSchema(tableConfig, schema);
    }

    public IndexLoadingConfig() {
    }

    public InstanceDataManagerConfig getInstanceDataManagerConfig() {
        return this._instanceDataManagerConfig;
    }

    private void extractFromTableConfigAndSchema(TableConfig tableConfig, @Nullable Schema schema) {
        String columnMinMaxValueGeneratorMode;
        String tableSegmentVersion;
        List onHeapDictionaryColumns;
        List varLengthDictionaryColumns;
        List fieldConfigList;
        List noDictionaryColumns;
        Map bloomFilterConfigs;
        Map jsonIndexConfigs;
        List invertedIndexColumns;
        List sortedColumns;
        if (schema != null) {
            TimestampIndexUtils.applyTimestampIndex((TableConfig)tableConfig, (Schema)schema);
        }
        this._tableConfig = tableConfig;
        this._schema = schema;
        IndexingConfig indexingConfig = tableConfig.getIndexingConfig();
        String tableReadMode = indexingConfig.getLoadMode();
        if (tableReadMode != null) {
            this._readMode = ReadMode.getEnum((String)tableReadMode);
        }
        if ((sortedColumns = indexingConfig.getSortedColumn()) != null) {
            this._sortedColumns = sortedColumns;
        }
        if ((invertedIndexColumns = indexingConfig.getInvertedIndexColumns()) != null) {
            this._invertedIndexColumns.addAll(invertedIndexColumns);
        }
        if ((jsonIndexConfigs = indexingConfig.getJsonIndexConfigs()) != null) {
            this._jsonIndexConfigs = jsonIndexConfigs;
        } else {
            List jsonIndexColumns = indexingConfig.getJsonIndexColumns();
            if (jsonIndexColumns != null) {
                this._jsonIndexConfigs = new HashMap<String, JsonIndexConfig>();
                for (Object jsonIndexColumn : jsonIndexColumns) {
                    this._jsonIndexConfigs.put((String)jsonIndexColumn, new JsonIndexConfig());
                }
            }
        }
        List rangeIndexColumns = indexingConfig.getRangeIndexColumns();
        if (rangeIndexColumns != null) {
            this._rangeIndexColumns.addAll(rangeIndexColumns);
        }
        this._rangeIndexVersion = indexingConfig.getRangeIndexVersion();
        this._fstIndexType = indexingConfig.getFSTIndexType();
        List bloomFilterColumns = indexingConfig.getBloomFilterColumns();
        if (bloomFilterColumns != null) {
            for (String bloomFilterColumn : bloomFilterColumns) {
                this._bloomFilterConfigs.put(bloomFilterColumn, new BloomFilterConfig(0.05, 0, false));
            }
        }
        if ((bloomFilterConfigs = indexingConfig.getBloomFilterConfigs()) != null) {
            this._bloomFilterConfigs.putAll(bloomFilterConfigs);
        }
        if ((noDictionaryColumns = indexingConfig.getNoDictionaryColumns()) != null) {
            this._noDictionaryColumns.addAll(noDictionaryColumns);
        }
        if ((fieldConfigList = tableConfig.getFieldConfigList()) != null) {
            for (FieldConfig fieldConfig : fieldConfigList) {
                this._columnProperties.put(fieldConfig.getName(), fieldConfig.getProperties());
            }
        }
        this.extractCompressionConfigs(tableConfig);
        this.extractTextIndexColumnsFromTableConfig(tableConfig);
        this.extractFSTIndexColumnsFromTableConfig(tableConfig);
        this.extractH3IndexConfigsFromTableConfig(tableConfig);
        this.extractVectorIndexConfigsFromTableConfig(tableConfig);
        this.extractForwardIndexDisabledColumnsFromTableConfig(tableConfig);
        Map noDictionaryConfig = indexingConfig.getNoDictionaryConfig();
        if (noDictionaryConfig != null) {
            this._noDictionaryConfig.putAll(noDictionaryConfig);
        }
        if ((varLengthDictionaryColumns = indexingConfig.getVarLengthDictionaryColumns()) != null) {
            this._varLengthDictionaryColumns.addAll(varLengthDictionaryColumns);
        }
        if ((onHeapDictionaryColumns = indexingConfig.getOnHeapDictionaryColumns()) != null) {
            this._onHeapDictionaryColumns.addAll(onHeapDictionaryColumns);
        }
        if ((tableSegmentVersion = indexingConfig.getSegmentFormatVersion()) != null) {
            this._segmentVersion = SegmentVersion.valueOf((String)tableSegmentVersion.toLowerCase());
        }
        if ((columnMinMaxValueGeneratorMode = indexingConfig.getColumnMinMaxValueGeneratorMode()) != null) {
            this._columnMinMaxValueGeneratorMode = ColumnMinMaxValueGeneratorMode.valueOf(columnMinMaxValueGeneratorMode.toUpperCase());
        }
        this.refreshIndexConfigs();
    }

    public void refreshIndexConfigs() {
        TableConfig tableConfig = this.getTableConfigWithTierOverwrites();
        this._indexConfigsByColName = this.calculateIndexConfigsByColName(tableConfig, this.inferSchema());
        if (tableConfig != null) {
            IndexingConfig indexingConfig = tableConfig.getIndexingConfig();
            this._enableDynamicStarTreeCreation = indexingConfig.isEnableDynamicStarTreeCreation();
            this._starTreeIndexConfigs = indexingConfig.getStarTreeIndexConfigs();
            this._enableDefaultStarTree = indexingConfig.isEnableDefaultStarTree();
        }
        this._dirty = false;
    }

    public Map<String, FieldIndexConfigs> calculateIndexConfigsByColName() {
        return this.calculateIndexConfigsByColName(this.getTableConfigWithTierOverwrites(), this.inferSchema());
    }

    private Map<String, FieldIndexConfigs> calculateIndexConfigsByColName(@Nullable TableConfig tableConfig, Schema schema) {
        return FieldIndexConfigsUtil.createIndexConfigsByColName((TableConfig)tableConfig, (Schema)schema, this::getDeserializer);
    }

    private <C extends IndexConfig> ColumnConfigDeserializer<C> getDeserializer(IndexType<C, ?, ?> indexType) {
        ColumnConfigDeserializer deserializer;
        ColumnConfigDeserializer stdDeserializer = (arg_0, arg_1) -> indexType.getConfig(arg_0, arg_1);
        if (indexType instanceof ConfigurableFromIndexLoadingConfig) {
            Map fromIndexLoadingConfig = ((ConfigurableFromIndexLoadingConfig)indexType).fromIndexLoadingConfig(this);
            if (this._schema == null || this._tableConfig == null) {
                LOGGER.debug("Ignoring default deserializers given that there is no schema [{}] or table config [{}]. Using indexLoadingConfig for indexType: {}", new Object[]{this._schema == null, this._tableConfig == null, indexType});
                deserializer = IndexConfigDeserializer.fromMap(table -> fromIndexLoadingConfig);
            } else {
                deserializer = this._segmentTier == null ? IndexConfigDeserializer.fromMap(table -> fromIndexLoadingConfig).withFallbackAlternative(stdDeserializer) : stdDeserializer;
            }
        } else if (this._schema == null || this._tableConfig == null) {
            LOGGER.debug("Ignoring default deserializers given that there is no schema [{}] or table config [{}]. Using default configs for indexType: {}", new Object[]{this._schema == null, this._tableConfig == null, indexType});
            deserializer = (tableConfig, schema) -> this.getAllKnownColumns().stream().collect(Collectors.toMap(Function.identity(), col -> indexType.getDefaultConfig()));
        } else {
            deserializer = stdDeserializer;
        }
        return deserializer;
    }

    private TableConfig getTableConfigWithTierOverwrites() {
        return this._segmentTier == null || this._tableConfig == null ? this._tableConfig : TableConfigUtils.overwriteTableConfigForTier((TableConfig)this._tableConfig, (String)this._segmentTier);
    }

    private Schema inferSchema() {
        if (this._schema != null) {
            return this._schema;
        }
        Schema schema = new Schema();
        for (String column : this.getAllKnownColumns()) {
            schema.addField((FieldSpec)new DimensionFieldSpec(column, FieldSpec.DataType.STRING, true));
        }
        return schema;
    }

    private void extractCompressionConfigs(TableConfig tableConfig) {
        List fieldConfigList = tableConfig.getFieldConfigList();
        if (fieldConfigList == null) {
            return;
        }
        for (FieldConfig fieldConfig : fieldConfigList) {
            String column = fieldConfig.getName();
            if (fieldConfig.getCompressionCodec() == null) continue;
            this._compressionConfigs.put(column, fieldConfig.getCompressionCodec());
        }
    }

    private void extractTextIndexColumnsFromTableConfig(TableConfig tableConfig) {
        List fieldConfigList = tableConfig.getFieldConfigList();
        if (fieldConfigList != null) {
            for (FieldConfig fieldConfig : fieldConfigList) {
                String column = fieldConfig.getName();
                if (fieldConfig.getIndexType() != FieldConfig.IndexType.TEXT) continue;
                this._textIndexColumns.add(column);
            }
        }
    }

    private void extractFSTIndexColumnsFromTableConfig(TableConfig tableConfig) {
        List fieldConfigList = tableConfig.getFieldConfigList();
        if (fieldConfigList != null) {
            for (FieldConfig fieldConfig : fieldConfigList) {
                String column = fieldConfig.getName();
                if (fieldConfig.getIndexType() != FieldConfig.IndexType.FST) continue;
                this._fstIndexColumns.add(column);
            }
        }
    }

    private void extractH3IndexConfigsFromTableConfig(TableConfig tableConfig) {
        List fieldConfigList = tableConfig.getFieldConfigList();
        if (fieldConfigList != null) {
            for (FieldConfig fieldConfig : fieldConfigList) {
                if (fieldConfig.getIndexType() != FieldConfig.IndexType.H3) continue;
                this._h3IndexConfigs.put(fieldConfig.getName(), new H3IndexConfig(fieldConfig.getProperties()));
            }
        }
    }

    private void extractVectorIndexConfigsFromTableConfig(TableConfig tableConfig) {
        List fieldConfigList = tableConfig.getFieldConfigList();
        if (fieldConfigList != null) {
            for (FieldConfig fieldConfig : fieldConfigList) {
                if (fieldConfig.getIndexType() != FieldConfig.IndexType.VECTOR) continue;
                this._vectorIndexConfigs.put(fieldConfig.getName(), new VectorIndexConfig(fieldConfig.getProperties()));
            }
        }
    }

    private void extractFromInstanceConfig(InstanceDataManagerConfig instanceDataManagerConfig) {
        String instanceSegmentVersion;
        if (instanceDataManagerConfig == null) {
            return;
        }
        this._instanceDataManagerConfig = instanceDataManagerConfig;
        this._instanceId = instanceDataManagerConfig.getInstanceId();
        ReadMode instanceReadMode = instanceDataManagerConfig.getReadMode();
        if (instanceReadMode != null) {
            this._readMode = instanceReadMode;
        }
        if ((instanceSegmentVersion = instanceDataManagerConfig.getSegmentFormatVersion()) != null) {
            this._segmentVersion = SegmentVersion.valueOf((String)instanceSegmentVersion.toLowerCase());
        }
        this._isRealtimeOffHeapAllocation = instanceDataManagerConfig.isRealtimeOffHeapAllocation();
        this._isDirectRealtimeOffHeapAllocation = instanceDataManagerConfig.isDirectRealtimeOffHeapAllocation();
        String avgMultiValueCount = instanceDataManagerConfig.getAvgMultiValueCount();
        if (avgMultiValueCount != null) {
            this._realtimeAvgMultiValueCount = Integer.valueOf(avgMultiValueCount);
        }
        this._segmentStoreURI = instanceDataManagerConfig.getConfig().getProperty("segment.store.uri");
        this._segmentDirectoryLoader = instanceDataManagerConfig.getSegmentDirectoryLoader();
    }

    private void extractForwardIndexDisabledColumnsFromTableConfig(TableConfig tableConfig) {
        List fieldConfigList = tableConfig.getFieldConfigList();
        if (fieldConfigList != null) {
            for (FieldConfig fieldConfig : fieldConfigList) {
                boolean forwardIndexDisabled;
                Map fieldConfigProperties = fieldConfig.getProperties();
                if (fieldConfigProperties == null || !(forwardIndexDisabled = Boolean.parseBoolean(fieldConfigProperties.getOrDefault("forwardIndexDisabled", FieldConfig.DEFAULT_FORWARD_INDEX_DISABLED)))) continue;
                this._forwardIndexDisabledColumns.add(fieldConfig.getName());
            }
        }
    }

    public ReadMode getReadMode() {
        return this._readMode;
    }

    public void setReadMode(ReadMode readMode) {
        this._readMode = readMode;
        this._dirty = true;
    }

    public List<String> getSortedColumns() {
        return this.unmodifiable(this._sortedColumns);
    }

    @VisibleForTesting
    public void setSortedColumn(String sortedColumn) {
        if (sortedColumn != null) {
            this._sortedColumns = new ArrayList<String>();
            this._sortedColumns.add(sortedColumn);
        } else {
            this._sortedColumns = Collections.emptyList();
        }
        this._dirty = true;
    }

    public Set<String> getInvertedIndexColumns() {
        return this.unmodifiable(this._invertedIndexColumns);
    }

    public Set<String> getRangeIndexColumns() {
        return this.unmodifiable(this._rangeIndexColumns);
    }

    public void addRangeIndexColumn(String ... columns) {
        this._rangeIndexColumns.addAll(Arrays.asList(columns));
        this._dirty = true;
    }

    public int getRangeIndexVersion() {
        return this._rangeIndexVersion;
    }

    public FSTType getFSTIndexType() {
        return this._fstIndexType;
    }

    public Set<String> getTextIndexColumns() {
        return this.unmodifiable(this._textIndexColumns);
    }

    public Set<String> getFSTIndexColumns() {
        return this.unmodifiable(this._fstIndexColumns);
    }

    public Map<String, JsonIndexConfig> getJsonIndexConfigs() {
        return this.unmodifiable(this._jsonIndexConfigs);
    }

    public Map<String, H3IndexConfig> getH3IndexConfigs() {
        return this.unmodifiable(this._h3IndexConfigs);
    }

    public Map<String, VectorIndexConfig> getVectorIndexConfigs() {
        return this.unmodifiable(this._vectorIndexConfigs);
    }

    public Map<String, Map<String, String>> getColumnProperties() {
        return this.unmodifiable(this._columnProperties);
    }

    public void setColumnProperties(Map<String, Map<String, String>> columnProperties) {
        this._columnProperties = new HashMap<String, Map<String, String>>(columnProperties);
        this._dirty = true;
    }

    @VisibleForTesting
    public void setInvertedIndexColumns(Set<String> invertedIndexColumns) {
        this._invertedIndexColumns = new HashSet<String>(invertedIndexColumns);
        this._dirty = true;
    }

    @VisibleForTesting
    public void addInvertedIndexColumns(String ... invertedIndexColumns) {
        this._invertedIndexColumns.addAll(Arrays.asList(invertedIndexColumns));
        this._dirty = true;
    }

    @VisibleForTesting
    public void addInvertedIndexColumns(Collection<String> invertedIndexColumns) {
        this._invertedIndexColumns.addAll(invertedIndexColumns);
        this._dirty = true;
    }

    @VisibleForTesting
    public void removeInvertedIndexColumns(String ... invertedIndexColumns) {
        this.removeInvertedIndexColumns(Arrays.asList(invertedIndexColumns));
        assert (this._dirty);
    }

    @VisibleForTesting
    public void removeInvertedIndexColumns(Collection<String> invertedIndexColumns) {
        this._invertedIndexColumns.removeAll(invertedIndexColumns);
        this._dirty = true;
    }

    @VisibleForTesting
    public void setNoDictionaryColumns(Set<String> noDictionaryColumns) {
        this._noDictionaryColumns = new HashSet<String>(noDictionaryColumns);
        this._dirty = true;
    }

    @VisibleForTesting
    public void removeNoDictionaryColumns(String ... noDictionaryColumns) {
        Arrays.asList(noDictionaryColumns).forEach(this._noDictionaryColumns::remove);
        this._dirty = true;
    }

    @VisibleForTesting
    public void removeNoDictionaryColumns(Collection<String> noDictionaryColumns) {
        noDictionaryColumns.forEach(this._noDictionaryColumns::remove);
        this._dirty = true;
    }

    @VisibleForTesting
    public void addNoDictionaryColumns(String ... noDictionaryColumns) {
        this._noDictionaryColumns.addAll(Arrays.asList(noDictionaryColumns));
        this._dirty = true;
    }

    @VisibleForTesting
    public void addNoDictionaryColumns(Collection<String> noDictionaryColumns) {
        this._noDictionaryColumns.addAll(noDictionaryColumns);
        this._dirty = true;
    }

    @VisibleForTesting
    public void setCompressionConfigs(Map<String, FieldConfig.CompressionCodec> compressionConfigs) {
        this._compressionConfigs = new HashMap<String, FieldConfig.CompressionCodec>(compressionConfigs);
        this._dirty = true;
    }

    @VisibleForTesting
    public void setRangeIndexColumns(Set<String> rangeIndexColumns) {
        this._rangeIndexColumns = new HashSet<String>(rangeIndexColumns);
        this._dirty = true;
    }

    public void addRangeIndexColumns(String ... rangeIndexColumns) {
        this._rangeIndexColumns.addAll(Arrays.asList(rangeIndexColumns));
        this._dirty = true;
    }

    public void removeRangeIndexColumns(String ... rangeIndexColumns) {
        Arrays.asList(rangeIndexColumns).forEach(this._rangeIndexColumns::remove);
        this._dirty = true;
    }

    @VisibleForTesting
    public void setTextIndexColumns(Set<String> textIndexColumns) {
        this._textIndexColumns = new HashSet<String>(textIndexColumns);
        this._dirty = true;
    }

    @VisibleForTesting
    public void addTextIndexColumns(String ... textIndexColumns) {
        this._textIndexColumns.addAll(Arrays.asList(textIndexColumns));
        this._dirty = true;
    }

    @VisibleForTesting
    public void removeTextIndexColumns(String ... textIndexColumns) {
        Arrays.asList(textIndexColumns).forEach(this._textIndexColumns::remove);
        this._dirty = true;
    }

    @VisibleForTesting
    public void setFSTIndexColumns(Set<String> fstIndexColumns) {
        this._fstIndexColumns = new HashSet<String>(fstIndexColumns);
        this._dirty = true;
    }

    @VisibleForTesting
    public void addFSTIndexColumns(String ... fstIndexColumns) {
        this._fstIndexColumns.addAll(Arrays.asList(fstIndexColumns));
        this._dirty = true;
    }

    @VisibleForTesting
    public void removeFSTIndexColumns(String ... fstIndexColumns) {
        Arrays.asList(fstIndexColumns).forEach(this._fstIndexColumns::remove);
        this._dirty = true;
    }

    @VisibleForTesting
    public void setFSTIndexType(FSTType fstType) {
        this._fstIndexType = fstType;
        this._dirty = true;
    }

    @VisibleForTesting
    public void setJsonIndexColumns(Set<String> jsonIndexColumns) {
        if (jsonIndexColumns != null) {
            this._jsonIndexConfigs = new HashMap<String, JsonIndexConfig>();
            for (String jsonIndexColumn : jsonIndexColumns) {
                this._jsonIndexConfigs.put(jsonIndexColumn, new JsonIndexConfig());
            }
        } else {
            this._jsonIndexConfigs = null;
        }
        this._dirty = true;
    }

    @VisibleForTesting
    public void setH3IndexConfigs(Map<String, H3IndexConfig> h3IndexConfigs) {
        this._h3IndexConfigs = new HashMap<String, H3IndexConfig>(h3IndexConfigs);
        this._dirty = true;
    }

    @VisibleForTesting
    public void setVectorIndexConfigs(Map<String, VectorIndexConfig> vectorIndexConfigs) {
        this._vectorIndexConfigs = new HashMap<String, VectorIndexConfig>(vectorIndexConfigs);
        this._dirty = true;
    }

    @VisibleForTesting
    public void setBloomFilterConfigs(Map<String, BloomFilterConfig> bloomFilterConfigs) {
        this._bloomFilterConfigs = new HashMap<String, BloomFilterConfig>(bloomFilterConfigs);
        this._dirty = true;
    }

    @VisibleForTesting
    public void setOnHeapDictionaryColumns(Set<String> onHeapDictionaryColumns) {
        this._onHeapDictionaryColumns = new HashSet<String>(onHeapDictionaryColumns);
        this._dirty = true;
    }

    @VisibleForTesting
    public void setForwardIndexDisabledColumns(Set<String> forwardIndexDisabledColumns) {
        this._forwardIndexDisabledColumns = forwardIndexDisabledColumns == null ? new HashSet<String>() : new HashSet<String>(forwardIndexDisabledColumns);
        this._dirty = true;
    }

    @VisibleForTesting
    public void addForwardIndexDisabledColumns(String ... forwardIndexDisabledColumns) {
        this._forwardIndexDisabledColumns.addAll(Arrays.asList(forwardIndexDisabledColumns));
        this._dirty = true;
    }

    @VisibleForTesting
    public void removeForwardIndexDisabledColumns(String ... forwardIndexDisabledColumns) {
        Arrays.asList(forwardIndexDisabledColumns).forEach(this._forwardIndexDisabledColumns::remove);
        this._dirty = true;
    }

    public Set<String> getNoDictionaryColumns() {
        return this.unmodifiable(this._noDictionaryColumns);
    }

    public Map<String, FieldConfig.CompressionCodec> getCompressionConfigs() {
        return this.unmodifiable(this._compressionConfigs);
    }

    public Map<String, String> getNoDictionaryConfig() {
        return this.unmodifiable(this._noDictionaryConfig);
    }

    public Set<String> getVarLengthDictionaryColumns() {
        return this.unmodifiable(this._varLengthDictionaryColumns);
    }

    public Set<String> getOnHeapDictionaryColumns() {
        return this.unmodifiable(this._onHeapDictionaryColumns);
    }

    public Set<String> getForwardIndexDisabledColumns() {
        return this.unmodifiable(this._forwardIndexDisabledColumns);
    }

    public Map<String, BloomFilterConfig> getBloomFilterConfigs() {
        return this.unmodifiable(this._bloomFilterConfigs);
    }

    public boolean isEnableDynamicStarTreeCreation() {
        if (this._dirty) {
            this.refreshIndexConfigs();
        }
        return this._enableDynamicStarTreeCreation;
    }

    @Nullable
    public List<StarTreeIndexConfig> getStarTreeIndexConfigs() {
        if (this._dirty) {
            this.refreshIndexConfigs();
        }
        return this.unmodifiable(this._starTreeIndexConfigs);
    }

    public boolean isEnableDefaultStarTree() {
        if (this._dirty) {
            this.refreshIndexConfigs();
        }
        return this._enableDefaultStarTree;
    }

    @Nullable
    public SegmentVersion getSegmentVersion() {
        return this._segmentVersion;
    }

    public void setSegmentVersion(SegmentVersion segmentVersion) {
        this._segmentVersion = segmentVersion;
        this._dirty = true;
    }

    public boolean isRealtimeOffHeapAllocation() {
        return this._isRealtimeOffHeapAllocation;
    }

    public boolean isDirectRealtimeOffHeapAllocation() {
        return this._isDirectRealtimeOffHeapAllocation;
    }

    public ColumnMinMaxValueGeneratorMode getColumnMinMaxValueGeneratorMode() {
        return this._columnMinMaxValueGeneratorMode;
    }

    public String getSegmentStoreURI() {
        return this._segmentStoreURI;
    }

    public void setColumnMinMaxValueGeneratorMode(ColumnMinMaxValueGeneratorMode columnMinMaxValueGeneratorMode) {
        this._columnMinMaxValueGeneratorMode = columnMinMaxValueGeneratorMode;
        this._dirty = true;
    }

    public int getRealtimeAvgMultiValueCount() {
        return this._realtimeAvgMultiValueCount;
    }

    public TableConfig getTableConfig() {
        return this._tableConfig;
    }

    @Nullable
    public Schema getSchema() {
        return this._schema;
    }

    @VisibleForTesting
    public void setTableConfig(TableConfig tableConfig) {
        this._tableConfig = tableConfig;
        this._dirty = true;
    }

    public String getSegmentDirectoryLoader() {
        return StringUtils.isNotBlank((CharSequence)this._segmentDirectoryLoader) ? this._segmentDirectoryLoader : "default";
    }

    public PinotConfiguration getSegmentDirectoryConfigs() {
        HashMap<String, ReadMode> props = new HashMap<String, ReadMode>();
        props.put(READ_MODE_KEY, this._readMode);
        return new PinotConfiguration(props);
    }

    public String getInstanceId() {
        return this._instanceId;
    }

    public void setTableDataDir(String tableDataDir) {
        this._tableDataDir = tableDataDir;
        this._dirty = true;
    }

    public boolean isErrorOnColumnBuildFailure() {
        return this._errorOnColumnBuildFailure;
    }

    public void setErrorOnColumnBuildFailure(boolean errorOnColumnBuildFailure) {
        this._errorOnColumnBuildFailure = errorOnColumnBuildFailure;
    }

    public String getTableDataDir() {
        return this._tableDataDir;
    }

    public void setSegmentTier(String segmentTier) {
        this._segmentTier = segmentTier;
        this._dirty = true;
    }

    public String getSegmentTier() {
        return this._segmentTier;
    }

    @Nullable
    public FieldIndexConfigs getFieldIndexConfig(String columnName) {
        if (this._indexConfigsByColName == null || this._dirty) {
            this.refreshIndexConfigs();
        }
        return this._indexConfigsByColName.get(columnName);
    }

    public Map<String, FieldIndexConfigs> getFieldIndexConfigByColName() {
        if (this._indexConfigsByColName == null || this._dirty) {
            this.refreshIndexConfigs();
        }
        return this.unmodifiable(this._indexConfigsByColName);
    }

    public Set<String> getAllKnownColumns() {
        List fieldConfigs;
        if (this._schema != null) {
            return this._schema.getColumnNames();
        }
        if (!this._dirty && this._knownColumns != null) {
            return this._knownColumns;
        }
        if (this._knownColumns == null) {
            this._knownColumns = new HashSet<String>();
        }
        if (this._tableConfig != null && (fieldConfigs = this._tableConfig.getFieldConfigList()) != null) {
            for (FieldConfig fieldConfig : fieldConfigs) {
                this._knownColumns.add(fieldConfig.getName());
            }
        }
        this._knownColumns.addAll(this._columnProperties.keySet());
        this._knownColumns.addAll(this._invertedIndexColumns);
        this._knownColumns.addAll(this._fstIndexColumns);
        this._knownColumns.addAll(this._rangeIndexColumns);
        this._knownColumns.addAll(this._noDictionaryColumns);
        this._knownColumns.addAll(this._textIndexColumns);
        this._knownColumns.addAll(this._forwardIndexDisabledColumns);
        this._knownColumns.addAll(this._onHeapDictionaryColumns);
        this._knownColumns.addAll(this._varLengthDictionaryColumns);
        return this._knownColumns;
    }

    public void setInstanceTierConfigs(Map<String, Map<String, String>> tierConfigs) {
        this._instanceTierConfigs = new HashMap<String, Map<String, String>>(tierConfigs);
        this._dirty = true;
    }

    public Map<String, Map<String, String>> getInstanceTierConfigs() {
        return this.unmodifiable(this._instanceTierConfigs);
    }

    private <E> List<E> unmodifiable(List<E> list) {
        return list == null ? null : Collections.unmodifiableList(list);
    }

    private <E> Set<E> unmodifiable(Set<E> set) {
        return set == null ? null : Collections.unmodifiableSet(set);
    }

    private <K, V> Map<K, V> unmodifiable(Map<K, V> map) {
        return map == null ? null : Collections.unmodifiableMap(map);
    }

    public void addKnownColumns(Set<String> columns) {
        if (this._knownColumns == null) {
            this._knownColumns = new HashSet<String>(columns);
        } else {
            this._knownColumns.addAll(columns);
        }
        this._dirty = true;
    }
}

