/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader.invertedindex;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.segment.index.forward.ForwardIndexType;
import org.apache.pinot.segment.local.segment.index.loader.BaseIndexHandler;
import org.apache.pinot.segment.local.segment.index.loader.LoaderUtils;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.FieldIndexConfigsUtil;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.creator.DictionaryBasedInvertedIndexCreator;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.config.table.IndexConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvertedIndexHandler
extends BaseIndexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(InvertedIndexHandler.class);
    private final Set<String> _columnsToAddIdx;

    public InvertedIndexHandler(SegmentDirectory segmentDirectory, Map<String, FieldIndexConfigs> fieldIndexConfigs, @Nullable TableConfig tableConfig) {
        super(segmentDirectory, fieldIndexConfigs, tableConfig);
        this._columnsToAddIdx = FieldIndexConfigsUtil.columnsWithIndexEnabled((IndexType)StandardIndexes.inverted(), (Map)this._fieldIndexConfigs);
    }

    public boolean needUpdateIndices(SegmentDirectory.Reader segmentReader) {
        String segmentName = this._segmentDirectory.getSegmentMetadata().getName();
        HashSet<String> columnsToAddIdx = new HashSet<String>(this._columnsToAddIdx);
        Set existingColumns = segmentReader.toSegmentDirectory().getColumnsWithIndex(StandardIndexes.inverted());
        for (String column : existingColumns) {
            if (columnsToAddIdx.remove(column)) continue;
            LOGGER.info("Need to remove existing inverted index from segment: {}, column: {}", (Object)segmentName, (Object)column);
            return true;
        }
        for (String column : columnsToAddIdx) {
            ColumnMetadata columnMetadata = this._segmentDirectory.getSegmentMetadata().getColumnMetadataFor(column);
            if (!this.shouldCreateInvertedIndex(columnMetadata)) continue;
            LOGGER.info("Need to create new inverted index for segment: {}, column: {}", (Object)segmentName, (Object)column);
            return true;
        }
        return false;
    }

    public void updateIndices(SegmentDirectory.Writer segmentWriter) throws Exception {
        String segmentName = this._segmentDirectory.getSegmentMetadata().getName();
        HashSet<String> columnsToAddIdx = new HashSet<String>(this._columnsToAddIdx);
        Set existingColumns = segmentWriter.toSegmentDirectory().getColumnsWithIndex(StandardIndexes.inverted());
        for (String column : existingColumns) {
            if (columnsToAddIdx.remove(column)) continue;
            LOGGER.info("Removing existing inverted index from segment: {}, column: {}", (Object)segmentName, (Object)column);
            segmentWriter.removeIndex(column, StandardIndexes.inverted());
            LOGGER.info("Removed existing inverted index from segment: {}, column: {}", (Object)segmentName, (Object)column);
        }
        for (String column : columnsToAddIdx) {
            ColumnMetadata columnMetadata = this._segmentDirectory.getSegmentMetadata().getColumnMetadataFor(column);
            if (!this.shouldCreateInvertedIndex(columnMetadata)) continue;
            this.createInvertedIndexForColumn(segmentWriter, columnMetadata);
        }
    }

    @Override
    public void postUpdateIndicesCleanup(SegmentDirectory.Writer segmentWriter) throws Exception {
    }

    private boolean shouldCreateInvertedIndex(ColumnMetadata columnMetadata) {
        return columnMetadata != null && !columnMetadata.isSorted() && columnMetadata.hasDictionary();
    }

    private void createInvertedIndexForColumn(SegmentDirectory.Writer segmentWriter, ColumnMetadata columnMetadata) throws Exception {
        File indexDir = this._segmentDirectory.getSegmentMetadata().getIndexDir();
        String segmentName = this._segmentDirectory.getSegmentMetadata().getName();
        String columnName = columnMetadata.getColumnName();
        File inProgress = new File(indexDir, columnName + ".inv.inprogress");
        File invertedIndexFile = new File(indexDir, columnName + ".bitmap.inv");
        if (!inProgress.exists()) {
            FileUtils.touch((File)inProgress);
        } else {
            FileUtils.deleteQuietly((File)invertedIndexFile);
        }
        LOGGER.info("Creating new inverted index for segment: {}, column: {}", (Object)segmentName, (Object)columnName);
        int numDocs = columnMetadata.getTotalDocs();
        IndexCreationContext.Common context = IndexCreationContext.builder().withIndexDir(indexDir).withColumnMetadata(columnMetadata).build();
        try (DictionaryBasedInvertedIndexCreator creator = (DictionaryBasedInvertedIndexCreator)StandardIndexes.inverted().createIndexCreator((IndexCreationContext)context, IndexConfig.ENABLED);
             ForwardIndexReader<?> forwardIndexReader = ForwardIndexType.read((SegmentDirectory.Reader)segmentWriter, columnMetadata);
             ForwardIndexReaderContext readerContext = forwardIndexReader.createContext();){
            if (columnMetadata.isSingleValue()) {
                for (int i = 0; i < numDocs; ++i) {
                    creator.add(forwardIndexReader.getDictId(i, readerContext));
                }
            } else {
                int[] dictIds = new int[columnMetadata.getMaxNumberOfMultiValues()];
                for (int i = 0; i < numDocs; ++i) {
                    int length = forwardIndexReader.getDictIdMV(i, dictIds, readerContext);
                    creator.add(dictIds, length);
                }
            }
            creator.seal();
        }
        if (this._segmentDirectory.getSegmentMetadata().getVersion() == SegmentVersion.v3) {
            LoaderUtils.writeIndexToV3Format(segmentWriter, columnName, invertedIndexFile, StandardIndexes.inverted());
        }
        FileUtils.deleteQuietly((File)inProgress);
        LOGGER.info("Created inverted index for segment: {}, column: {}", (Object)segmentName, (Object)columnName);
    }
}

