/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers;

import java.math.BigDecimal;
import org.apache.pinot.segment.local.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;

public class DoubleDictionary
extends BaseImmutableDictionary {
    public DoubleDictionary(PinotDataBuffer dataBuffer, int length) {
        super(dataBuffer, length, 8);
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.DOUBLE;
    }

    public int indexOf(double doubleValue) {
        return this.normalizeIndex(this.binarySearch(doubleValue));
    }

    public int insertionIndexOf(String stringValue) {
        return this.binarySearch(Double.parseDouble(stringValue));
    }

    public Double get(int dictId) {
        return this.getDouble(dictId);
    }

    public int getIntValue(int dictId) {
        return (int)this.getDouble(dictId);
    }

    public long getLongValue(int dictId) {
        return (long)this.getDouble(dictId);
    }

    public float getFloatValue(int dictId) {
        return (float)this.getDouble(dictId);
    }

    public double getDoubleValue(int dictId) {
        return this.getDouble(dictId);
    }

    public BigDecimal getBigDecimalValue(int dictId) {
        return BigDecimal.valueOf(this.getDouble(dictId));
    }

    public String getStringValue(int dictId) {
        return Double.toString(this.getDouble(dictId));
    }
}

