/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.FALFInterner;

public class OnHeapStringDictionary
extends BaseImmutableDictionary {
    private final String[] _unpaddedStrings;
    private final byte[][] _unpaddedBytes;
    private final Object2IntOpenHashMap<String> _unPaddedStringToIdMap;

    public OnHeapStringDictionary(PinotDataBuffer dataBuffer, int length, int numBytesPerValue, @Nullable FALFInterner<String> strInterner, @Nullable FALFInterner<byte[]> byteInterner) {
        super(dataBuffer, length, numBytesPerValue);
        this._unpaddedBytes = new byte[length][];
        this._unpaddedStrings = new String[length];
        this._unPaddedStringToIdMap = new Object2IntOpenHashMap(length);
        this._unPaddedStringToIdMap.defaultReturnValue(-1);
        byte[] buffer = new byte[numBytesPerValue];
        boolean enableInterning = strInterner != null && byteInterner != null;
        for (int i = 0; i < length; ++i) {
            if (enableInterning) {
                this._unpaddedBytes[i] = (byte[])byteInterner.intern((Object)this.getUnpaddedBytes(i, buffer));
                this._unpaddedStrings[i] = (String)strInterner.intern((Object)new String(this._unpaddedBytes[i], StandardCharsets.UTF_8));
            } else {
                this._unpaddedBytes[i] = this.getUnpaddedBytes(i, buffer);
                this._unpaddedStrings[i] = new String(this._unpaddedBytes[i], StandardCharsets.UTF_8);
            }
            this._unPaddedStringToIdMap.put((Object)this._unpaddedStrings[i], i);
        }
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.STRING;
    }

    @Override
    public int indexOf(String stringValue) {
        return this._unPaddedStringToIdMap.getInt((Object)stringValue);
    }

    public int insertionIndexOf(String stringValue) {
        int index = this._unPaddedStringToIdMap.getInt((Object)stringValue);
        if (index != -1) {
            return index;
        }
        return Arrays.binarySearch(this._unpaddedStrings, stringValue);
    }

    public String get(int dictId) {
        return this._unpaddedStrings[dictId];
    }

    public int getIntValue(int dictId) {
        return Integer.parseInt(this._unpaddedStrings[dictId]);
    }

    public long getLongValue(int dictId) {
        return Long.parseLong(this._unpaddedStrings[dictId]);
    }

    public float getFloatValue(int dictId) {
        return Float.parseFloat(this._unpaddedStrings[dictId]);
    }

    public double getDoubleValue(int dictId) {
        return Double.parseDouble(this._unpaddedStrings[dictId]);
    }

    public BigDecimal getBigDecimalValue(int dictId) {
        return new BigDecimal(this._unpaddedStrings[dictId]);
    }

    public String getStringValue(int dictId) {
        return this._unpaddedStrings[dictId];
    }

    public byte[] getBytesValue(int dictId) {
        return this._unpaddedBytes[dictId];
    }
}

