/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers.forward;

import com.yscope.clp.compressorfrontend.MessageDecoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.pinot.segment.local.io.util.PinotDataBitSet;
import org.apache.pinot.segment.local.io.util.VarLengthValueReader;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.CLPForwardIndexCreatorV1;
import org.apache.pinot.segment.local.segment.index.readers.forward.FixedBitMVForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.FixedBitSVForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.VarByteChunkForwardIndexReaderV4;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;

public class CLPForwardIndexReaderV1
implements ForwardIndexReader<CLPReaderContext> {
    private final int _version;
    private final int _numDocs;
    private final int _totalDictVarValues;
    private final int _logTypeDictNumBytesPerValue;
    private final int _dictVarsDictNumBytesPerValue;
    private final int _logTypeDictReaderStartOffset;
    private final VarLengthValueReader _logTypeDictReader;
    private final int _dictVarsDictReaderStartOffset;
    private final VarLengthValueReader _dictVarsDictReader;
    private final int _logTypeFwdIndexReaderStartOffset;
    private final FixedBitSVForwardIndexReader _logTypeFwdIndexReader;
    private final int _dictVarsFwdIndexReaderStartOffset;
    private final FixedBitMVForwardIndexReader _dictVarsFwdIndexReader;
    private final int _encodedVarFwdIndexReaderStartOffset;
    private final VarByteChunkForwardIndexReaderV4 _encodedVarFwdIndexReader;
    private final MessageDecoder _clpMessageDecoder;

    public CLPForwardIndexReaderV1(PinotDataBuffer pinotDataBuffer, int numDocs) {
        this._numDocs = numDocs;
        int offset = CLPForwardIndexCreatorV1.MAGIC_BYTES.length;
        this._version = pinotDataBuffer.getInt(offset);
        this._totalDictVarValues = pinotDataBuffer.getInt(offset += 4);
        this._logTypeDictNumBytesPerValue = pinotDataBuffer.getInt(offset += 4);
        this._dictVarsDictNumBytesPerValue = pinotDataBuffer.getInt(offset += 4);
        int logTypeDictLength = pinotDataBuffer.getInt(offset += 4);
        int dictVarDictLength = pinotDataBuffer.getInt(offset += 4);
        int logTypeFwdIndexLength = pinotDataBuffer.getInt(offset += 4);
        int dictVarsFwdIndexLength = pinotDataBuffer.getInt(offset += 4);
        int encodedVarFwdIndexLength = pinotDataBuffer.getInt(offset += 4);
        this._logTypeDictReaderStartOffset = offset += 4;
        this._logTypeDictReader = new VarLengthValueReader(pinotDataBuffer.view((long)offset, (long)(offset + logTypeDictLength)));
        this._dictVarsDictReaderStartOffset = offset += logTypeDictLength;
        this._dictVarsDictReader = new VarLengthValueReader(pinotDataBuffer.view((long)offset, (long)(offset + dictVarDictLength)));
        this._logTypeFwdIndexReaderStartOffset = offset += dictVarDictLength;
        this._logTypeFwdIndexReader = new FixedBitSVForwardIndexReader(pinotDataBuffer.view((long)offset, (long)(offset + logTypeFwdIndexLength)), this._numDocs, PinotDataBitSet.getNumBitsPerValue(this._logTypeDictReader.getNumValues() - 1));
        this._dictVarsFwdIndexReaderStartOffset = offset += logTypeFwdIndexLength;
        this._dictVarsFwdIndexReader = new FixedBitMVForwardIndexReader(pinotDataBuffer.view((long)offset, (long)(offset + dictVarsFwdIndexLength)), this._numDocs, this._totalDictVarValues, PinotDataBitSet.getNumBitsPerValue(this._dictVarsDictReader.getNumValues() - 1));
        this._encodedVarFwdIndexReaderStartOffset = offset += dictVarsFwdIndexLength;
        this._encodedVarFwdIndexReader = new VarByteChunkForwardIndexReaderV4(pinotDataBuffer.view((long)offset, (long)(offset + encodedVarFwdIndexLength)), FieldSpec.DataType.LONG, false);
        offset += encodedVarFwdIndexLength;
        this._clpMessageDecoder = new MessageDecoder("com.yscope.clp.VariablesSchemaV2", "com.yscope.clp.VariableEncodingMethodsV1");
    }

    public boolean isDictionaryEncoded() {
        return false;
    }

    public boolean isSingleValue() {
        return true;
    }

    public FieldSpec.DataType getStoredType() {
        return FieldSpec.DataType.STRING;
    }

    public String getString(int docId, CLPReaderContext context) {
        int logTypeDictId = this._logTypeFwdIndexReader.getDictId(docId, context._logTypeReaderContext);
        String logType = this._logTypeDictReader.getUnpaddedString(logTypeDictId, this._logTypeDictNumBytesPerValue, new byte[this._logTypeDictNumBytesPerValue]);
        int[] dictVarsDictIds = this._dictVarsFwdIndexReader.getDictIdMV(docId, context._dictVarsReaderContext);
        String[] dictVars = new String[dictVarsDictIds.length];
        for (int i = 0; i < dictVarsDictIds.length; ++i) {
            dictVars[i] = this._dictVarsDictReader.getUnpaddedString(dictVarsDictIds[i], this._dictVarsDictNumBytesPerValue, new byte[this._dictVarsDictNumBytesPerValue]);
        }
        long[] encodedVar = this._encodedVarFwdIndexReader.getLongMV(docId, context._encodedVarReaderContext);
        try {
            return this._clpMessageDecoder.decodeMessage(logType, dictVars, encodedVar);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws IOException {
    }

    public CLPReaderContext createContext() {
        return new CLPReaderContext(this._dictVarsFwdIndexReader.createContext(), this._logTypeFwdIndexReader.createContext(), this._encodedVarFwdIndexReader.createContext());
    }

    public boolean isBufferByteRangeInfoSupported() {
        return true;
    }

    public void recordDocIdByteRanges(int docId, CLPReaderContext context, List<ForwardIndexReader.ByteRange> ranges) {
        int logTypeDictId = this._logTypeFwdIndexReader.getDictId(docId, context._logTypeReaderContext);
        ranges.add(new ForwardIndexReader.ByteRange((long)this._logTypeFwdIndexReaderStartOffset + this._logTypeFwdIndexReader.getRawDataStartOffset() + (long)this._logTypeFwdIndexReader.getDocLength() * (long)docId, this._logTypeFwdIndexReader.getDocLength()));
        this._logTypeDictReader.recordOffsetRanges(logTypeDictId, this._logTypeDictReaderStartOffset, ranges);
        int[] dictVarsDictIds = this._dictVarsFwdIndexReader.getDictIdMV(docId, context._dictVarsReaderContext);
        ArrayList<ForwardIndexReader.ByteRange> fwdIndexByteRanges = new ArrayList<ForwardIndexReader.ByteRange>();
        this._dictVarsFwdIndexReader.recordDocIdByteRanges(docId, context._dictVarsReaderContext, fwdIndexByteRanges);
        for (ForwardIndexReader.ByteRange range : fwdIndexByteRanges) {
            ranges.add(new ForwardIndexReader.ByteRange((long)this._dictVarsFwdIndexReaderStartOffset + range.getOffset(), range.getSizeInBytes()));
        }
        fwdIndexByteRanges.clear();
        for (Object dictVarsDictId : (Iterator)dictVarsDictIds) {
            this._dictVarsDictReader.recordOffsetRanges((int)dictVarsDictId, this._dictVarsDictReaderStartOffset, ranges);
        }
        this._encodedVarFwdIndexReader.recordDocIdByteRanges(docId, context._encodedVarReaderContext, fwdIndexByteRanges);
        for (ForwardIndexReader.ByteRange range : fwdIndexByteRanges) {
            ranges.add(new ForwardIndexReader.ByteRange((long)this._encodedVarFwdIndexReaderStartOffset + range.getOffset(), range.getSizeInBytes()));
        }
    }

    public boolean isFixedOffsetMappingType() {
        return false;
    }

    public ChunkCompressionType getCompressionType() {
        return ChunkCompressionType.PASS_THROUGH;
    }

    public static final class CLPReaderContext
    implements ForwardIndexReaderContext {
        private final FixedBitMVForwardIndexReader.Context _dictVarsReaderContext;
        private final ForwardIndexReaderContext _logTypeReaderContext;
        private final VarByteChunkForwardIndexReaderV4.ReaderContext _encodedVarReaderContext;

        public CLPReaderContext(FixedBitMVForwardIndexReader.Context dictVarsReaderContext, ForwardIndexReaderContext logTypeReaderContext, VarByteChunkForwardIndexReaderV4.ReaderContext encodedVarReaderContext) {
            this._dictVarsReaderContext = dictVarsReaderContext;
            this._logTypeReaderContext = logTypeReaderContext;
            this._encodedVarReaderContext = encodedVarReaderContext;
        }

        public void close() throws IOException {
            if (this._dictVarsReaderContext != null) {
                this._dictVarsReaderContext.close();
            }
            if (this._logTypeReaderContext != null) {
                this._logTypeReaderContext.close();
            }
            if (this._encodedVarReaderContext != null) {
                this._encodedVarReaderContext.close();
            }
        }
    }
}

