/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers.forward;

import java.util.List;
import org.apache.pinot.segment.local.io.util.FixedBitIntReaderWriter;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;

public final class FixedBitSVForwardIndexReader
implements ForwardIndexReader<ForwardIndexReaderContext> {
    private final FixedBitIntReaderWriter _reader;
    private final int _numBitsPerValue;

    public FixedBitSVForwardIndexReader(PinotDataBuffer dataBuffer, int numDocs, int numBitsPerValue) {
        this._reader = new FixedBitIntReaderWriter(dataBuffer, numDocs, numBitsPerValue);
        this._numBitsPerValue = numBitsPerValue;
    }

    public boolean isDictionaryEncoded() {
        return true;
    }

    public boolean isSingleValue() {
        return true;
    }

    public FieldSpec.DataType getStoredType() {
        return FieldSpec.DataType.INT;
    }

    public int getDictId(int docId, ForwardIndexReaderContext context) {
        return this._reader.readInt(docId);
    }

    public void readDictIds(int[] docIds, int length, int[] dictIdBuffer, ForwardIndexReaderContext context) {
        for (int i = 0; i < length; ++i) {
            dictIdBuffer[i] = this._reader.readInt(docIds[i]);
        }
    }

    public void close() {
        this._reader.close();
    }

    public boolean isBufferByteRangeInfoSupported() {
        return true;
    }

    public void recordDocIdByteRanges(int docId, ForwardIndexReaderContext context, List<ForwardIndexReader.ByteRange> ranges) {
        throw new UnsupportedOperationException("Forward index is fixed length type");
    }

    public boolean isFixedOffsetMappingType() {
        return true;
    }

    public long getRawDataStartOffset() {
        return 0L;
    }

    public int getDocLength() {
        return this._numBitsPerValue;
    }

    public boolean isDocLengthInBits() {
        return true;
    }
}

