/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.startree.v2.builder;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.pinot.common.utils.FileUtils;
import org.apache.pinot.segment.local.startree.v2.builder.StarTreeV2BuilderConfig;
import org.apache.pinot.segment.local.startree.v2.store.StarTreeIndexMapUtils;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2Metadata;

public class StarTreeIndexSeparator
implements Closeable {
    private final List<Map<StarTreeIndexMapUtils.IndexKey, StarTreeIndexMapUtils.IndexValue>> _indexMapList;
    private final List<StarTreeV2BuilderConfig> _builderConfigList;
    private final List<Integer> _numDocsList;
    private final FileChannel _indexFileChannel;

    public StarTreeIndexSeparator(File indexMapFile, File indexFile, List<StarTreeV2Metadata> starTreeMetadataList) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(indexMapFile);){
            this._indexMapList = StarTreeIndexMapUtils.loadFromInputStream(inputStream, starTreeMetadataList);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        int numStarTrees = starTreeMetadataList.size();
        this._builderConfigList = new ArrayList<StarTreeV2BuilderConfig>(numStarTrees);
        this._numDocsList = new ArrayList<Integer>(numStarTrees);
        for (StarTreeV2Metadata starTreeMetadata : starTreeMetadataList) {
            this._builderConfigList.add(StarTreeV2BuilderConfig.fromMetadata(starTreeMetadata));
            this._numDocsList.add(starTreeMetadata.getNumDocs());
        }
        this._indexFileChannel = new RandomAccessFile(indexFile, "r").getChannel();
    }

    public int separate(File starTreeOutputDir, StarTreeV2BuilderConfig builderConfig) throws IOException {
        int treeIndex = this._builderConfigList.indexOf(builderConfig);
        if (treeIndex == -1) {
            return -1;
        }
        this.separate(starTreeOutputDir, treeIndex);
        return this._numDocsList.get(treeIndex);
    }

    private void separate(File starTreeOutputDir, int treeIndex) throws IOException {
        Map<StarTreeIndexMapUtils.IndexKey, StarTreeIndexMapUtils.IndexValue> indexMap = this._indexMapList.get(treeIndex);
        org.apache.commons.io.FileUtils.forceMkdir((File)starTreeOutputDir);
        for (StarTreeIndexMapUtils.IndexKey key : indexMap.keySet()) {
            switch (key._indexType) {
                case STAR_TREE: {
                    File destIndexFile = new File(starTreeOutputDir, "star_tree.index");
                    this.writeIndexToFile(destIndexFile, indexMap.get(key));
                    break;
                }
                case FORWARD_INDEX: {
                    String suffix = key._column.contains("__") ? ".sv.raw.fwd" : ".sv.unsorted.fwd";
                    File destIndexFile = new File(starTreeOutputDir, key._column + suffix);
                    this.writeIndexToFile(destIndexFile, indexMap.get(key));
                    break;
                }
            }
        }
    }

    private void writeIndexToFile(File destFile, StarTreeIndexMapUtils.IndexValue value) throws IOException {
        try (FileChannel dest = new RandomAccessFile(destFile, "rw").getChannel();){
            FileUtils.transferBytes((FileChannel)this._indexFileChannel, (long)value._offset, (long)value._size, (FileChannel)dest);
            dest.force(true);
        }
    }

    @Override
    public void close() throws IOException {
        this._indexFileChannel.close();
    }
}

