/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.upsert;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.pinot.segment.local.data.manager.TableDataManager;
import org.apache.pinot.segment.local.upsert.PartialUpsertHandler;
import org.apache.pinot.segment.local.upsert.TableUpsertMetadataManager;
import org.apache.pinot.segment.local.upsert.UpsertContext;
import org.apache.pinot.spi.config.table.HashFunction;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.apache.pinot.spi.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class BaseTableUpsertMetadataManager
implements TableUpsertMetadataManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseTableUpsertMetadataManager.class);
    protected String _tableNameWithType;
    protected UpsertContext _context;
    protected UpsertConfig.ConsistencyMode _consistencyMode;

    @Override
    public void init(TableConfig tableConfig, Schema schema, TableDataManager tableDataManager) {
        this._tableNameWithType = tableConfig.getTableName();
        UpsertConfig upsertConfig = tableConfig.getUpsertConfig();
        Preconditions.checkArgument((upsertConfig != null && upsertConfig.getMode() != UpsertConfig.Mode.NONE ? 1 : 0) != 0, (String)"Upsert must be enabled for table: %s", (Object)this._tableNameWithType);
        List primaryKeyColumns = schema.getPrimaryKeyColumns();
        Preconditions.checkArgument((!CollectionUtils.isEmpty((Collection)primaryKeyColumns) ? 1 : 0) != 0, (String)"Primary key columns must be configured for upsert enabled table: %s", (Object)this._tableNameWithType);
        List<String> comparisonColumns = upsertConfig.getComparisonColumns();
        if (comparisonColumns == null) {
            comparisonColumns = Collections.singletonList(tableConfig.getValidationConfig().getTimeColumnName());
        }
        PartialUpsertHandler partialUpsertHandler = null;
        if (upsertConfig.getMode() == UpsertConfig.Mode.PARTIAL) {
            partialUpsertHandler = new PartialUpsertHandler(schema, comparisonColumns, upsertConfig);
        }
        String deleteRecordColumn = upsertConfig.getDeleteRecordColumn();
        HashFunction hashFunction = upsertConfig.getHashFunction();
        boolean enableSnapshot = upsertConfig.isEnableSnapshot();
        boolean enablePreload = upsertConfig.isEnablePreload();
        double metadataTTL = upsertConfig.getMetadataTTL();
        double deletedKeysTTL = upsertConfig.getDeletedKeysTTL();
        this._consistencyMode = upsertConfig.getConsistencyMode();
        if (this._consistencyMode == null) {
            this._consistencyMode = UpsertConfig.ConsistencyMode.NONE;
        }
        long upsertViewRefreshIntervalMs = upsertConfig.getUpsertViewRefreshIntervalMs();
        File tableIndexDir = tableDataManager.getTableDataDir();
        this._context = new UpsertContext.Builder().setTableConfig(tableConfig).setSchema(schema).setPrimaryKeyColumns(primaryKeyColumns).setComparisonColumns(comparisonColumns).setDeleteRecordColumn(deleteRecordColumn).setHashFunction(hashFunction).setPartialUpsertHandler(partialUpsertHandler).setEnableSnapshot(enableSnapshot).setEnablePreload(enablePreload).setMetadataTTL(metadataTTL).setDeletedKeysTTL(deletedKeysTTL).setConsistencyMode(this._consistencyMode).setUpsertViewRefreshIntervalMs(upsertViewRefreshIntervalMs).setTableIndexDir(tableIndexDir).setTableDataManager(tableDataManager).build();
        LOGGER.info("Initialized {} for table: {} with primary key columns: {}, comparison columns: {}, delete record column: {}, hash function: {}, upsert mode: {}, enable snapshot: {}, enable preload: {}, metadata TTL: {}, deleted Keys TTL: {}, consistency mode: {}, upsert view refresh interval: {}ms, table index dir: {}", new Object[]{this.getClass().getSimpleName(), this._tableNameWithType, primaryKeyColumns, comparisonColumns, deleteRecordColumn, hashFunction, upsertConfig.getMode(), enableSnapshot, enablePreload, metadataTTL, deletedKeysTTL, this._consistencyMode, upsertViewRefreshIntervalMs, tableIndexDir});
        this.initCustomVariables();
    }

    protected void initCustomVariables() {
    }

    @Override
    public UpsertConfig.Mode getUpsertMode() {
        return this._context.getPartialUpsertHandler() == null ? UpsertConfig.Mode.FULL : UpsertConfig.Mode.PARTIAL;
    }
}

