/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.upsert.merger;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.segment.local.upsert.merger.PartialUpsertColumnarMerger;
import org.apache.pinot.segment.local.upsert.merger.PartialUpsertMerger;
import org.apache.pinot.spi.config.table.UpsertConfig;

public class PartialUpsertMergerFactory {
    private PartialUpsertMergerFactory() {
    }

    public static PartialUpsertMerger getPartialUpsertMerger(List<String> primaryKeyColumns, List<String> comparisonColumns, UpsertConfig upsertConfig) {
        String customMergerClassName = upsertConfig.getPartialUpsertMergerClass();
        if (StringUtils.isNotBlank((CharSequence)customMergerClassName)) {
            try {
                Class<?> partialUpsertMergerClass = Class.forName(customMergerClassName);
                return (PartialUpsertMerger)partialUpsertMergerClass.getConstructor(List.class, List.class, UpsertConfig.class).newInstance(primaryKeyColumns, comparisonColumns, upsertConfig);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to instantiate partial upsert merger with class: %s", customMergerClassName), e);
            }
        }
        return new PartialUpsertColumnarMerger(primaryKeyColumns, comparisonColumns, upsertConfig);
    }
}

