/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils;

import com.uber.h3core.H3CoreV3;
import com.uber.h3core.util.LatLng;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.segment.local.utils.GeometryUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class H3Utils {
    public static final H3CoreV3 H3_CORE;

    private H3Utils() {
    }

    private static LongSet coverLineInH3(LineString lineString, int resolution) {
        Coordinate[] endPoints = lineString.getCoordinates();
        int numEndPoints = endPoints.length;
        if (numEndPoints == 0) {
            return LongSets.EMPTY_SET;
        }
        long previousCell = H3_CORE.geoToH3(endPoints[0].y, endPoints[0].x, resolution);
        if (numEndPoints == 1) {
            return LongSets.singleton((long)previousCell);
        }
        LongOpenHashSet coveringCells = new LongOpenHashSet();
        for (int i = 1; i < numEndPoints; ++i) {
            long currentCell = H3_CORE.geoToH3(endPoints[i].y, endPoints[i].x, resolution);
            coveringCells.addAll((Collection)H3_CORE.h3Line(previousCell, currentCell));
            previousCell = currentCell;
        }
        return coveringCells;
    }

    private static Pair<LongSet, LongSet> coverPolygonInH3(Polygon polygon, int resolution) {
        List polyfillCells = H3_CORE.polyfill(Arrays.stream(polygon.getExteriorRing().getCoordinates()).map(coordinate -> new LatLng(coordinate.y, coordinate.x)).collect(Collectors.toList()), Collections.emptyList(), resolution);
        if (polyfillCells.isEmpty()) {
            Coordinate represent = polygon.getCoordinate();
            return Pair.of((Object)LongSets.EMPTY_SET, (Object)new LongOpenHashSet((Collection)H3_CORE.kRing(H3_CORE.geoToH3(represent.y, represent.x, resolution), 1)));
        }
        LongOpenHashSet fullyCoveredCells = new LongOpenHashSet();
        LongOpenHashSet potentiallyCoveredCells = new LongOpenHashSet((Collection)polyfillCells);
        Iterator iterator = polyfillCells.iterator();
        while (iterator.hasNext()) {
            long cell = (Long)iterator.next();
            if (polygon.contains((Geometry)H3Utils.createPolygonFromH3Cell(cell))) {
                fullyCoveredCells.add(cell);
            }
            potentiallyCoveredCells.addAll((Collection)H3_CORE.kRing(cell, 1));
        }
        potentiallyCoveredCells.removeAll((LongCollection)fullyCoveredCells);
        return Pair.of((Object)fullyCoveredCells, (Object)potentiallyCoveredCells);
    }

    private static Polygon createPolygonFromH3Cell(long h3Cell) {
        List boundary = H3_CORE.h3ToGeoBoundary(h3Cell);
        boundary.add((LatLng)boundary.get(0));
        return GeometryUtils.GEOMETRY_FACTORY.createPolygon((Coordinate[])boundary.stream().map(geoCoord -> new Coordinate(geoCoord.lng, geoCoord.lat)).toArray(Coordinate[]::new));
    }

    public static Pair<LongSet, LongSet> coverGeometryInH3(Geometry geometry, int resolution) {
        if (geometry instanceof Point) {
            return Pair.of((Object)LongSets.EMPTY_SET, (Object)LongSets.singleton((long)H3_CORE.geoToH3(geometry.getCoordinate().y, geometry.getCoordinate().x, resolution)));
        }
        if (geometry instanceof LineString) {
            return Pair.of((Object)LongSets.EMPTY_SET, (Object)H3Utils.coverLineInH3((LineString)geometry, resolution));
        }
        if (geometry instanceof Polygon) {
            return H3Utils.coverPolygonInH3((Polygon)geometry, resolution);
        }
        if (geometry instanceof GeometryCollection) {
            LongOpenHashSet fullyCoveredCells = new LongOpenHashSet();
            LongOpenHashSet potentiallyCoveredCells = new LongOpenHashSet();
            int numGeometries = geometry.getNumGeometries();
            for (int i = 0; i < numGeometries; ++i) {
                Pair<LongSet, LongSet> pair = H3Utils.coverGeometryInH3(geometry.getGeometryN(i), resolution);
                fullyCoveredCells.addAll((LongCollection)pair.getLeft());
                potentiallyCoveredCells.addAll((LongCollection)pair.getRight());
            }
            potentiallyCoveredCells.removeAll((LongCollection)fullyCoveredCells);
            return Pair.of((Object)fullyCoveredCells, (Object)potentiallyCoveredCells);
        }
        throw new UnsupportedOperationException("Unexpected type: " + geometry.getGeometryType());
    }

    static {
        try {
            H3_CORE = H3CoreV3.newInstance();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to instantiate H3 V3 instance", e);
        }
    }
}

