/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils;

import java.util.ArrayList;
import org.apache.lucene.queries.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.queries.spans.SpanNearQuery;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.queries.spans.SpanTermQuery;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneTextIndexUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LuceneTextIndexUtils.class);

    private LuceneTextIndexUtils() {
    }

    public static Query convertToMultiTermSpanQuery(Query query) {
        if (!(query instanceof BooleanQuery)) {
            return query;
        }
        LOGGER.debug("Perform rewriting for the phrase query {}.", (Object)query);
        ArrayList<Object> spanQueryLst = new ArrayList<Object>();
        boolean prefixOrSuffixQueryFound = false;
        for (BooleanClause clause : ((BooleanQuery)query).clauses()) {
            Query q = clause.getQuery();
            if (q instanceof WildcardQuery || q instanceof PrefixQuery) {
                prefixOrSuffixQueryFound = true;
                spanQueryLst.add(new SpanMultiTermQueryWrapper((MultiTermQuery)((AutomatonQuery)q)));
                continue;
            }
            if (q instanceof TermQuery) {
                spanQueryLst.add(new SpanTermQuery(((TermQuery)q).getTerm()));
                continue;
            }
            LOGGER.info("query can not be handled currently {} ", (Object)q);
            return query;
        }
        if (!prefixOrSuffixQueryFound) {
            return query;
        }
        SpanNearQuery spanNearQuery = new SpanNearQuery(spanQueryLst.toArray(new SpanQuery[0]), 0, true);
        LOGGER.debug("The phrase query {} is re-written as {}", (Object)query, (Object)spanNearQuery);
        return spanNearQuery;
    }
}

