/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.tablestate;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.PropertyKey;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.LiveInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableStateUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableStateUtils.class);
    private static final int MAX_NUM_SEGMENTS_TO_LOG = 10;

    private TableStateUtils() {
    }

    public static List<String> getSegmentsInGivenStateForThisInstance(HelixManager helixManager, String tableNameWithType, String state) {
        HelixDataAccessor dataAccessor = helixManager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = dataAccessor.keyBuilder();
        IdealState idealState = (IdealState)dataAccessor.getProperty(keyBuilder.idealStates(tableNameWithType));
        ArrayList<String> segmentsInGivenState = new ArrayList<String>();
        if (idealState == null) {
            LOGGER.warn("Failed to find ideal state for table: {}", (Object)tableNameWithType);
            return segmentsInGivenState;
        }
        String instanceName = helixManager.getInstanceName();
        Map idealStatesMap = idealState.getRecord().getMapFields();
        for (Map.Entry entry : idealStatesMap.entrySet()) {
            String segmentName = (String)entry.getKey();
            Map instanceStateMap = (Map)entry.getValue();
            String expectedState = (String)instanceStateMap.get(instanceName);
            if (!state.equals(expectedState)) continue;
            segmentsInGivenState.add(segmentName);
        }
        return segmentsInGivenState;
    }

    public static boolean isAllSegmentsLoaded(HelixManager helixManager, String tableNameWithType) {
        String instanceName;
        PropertyKey.Builder keyBuilder;
        List<String> onlineSegments = TableStateUtils.getSegmentsInGivenStateForThisInstance(helixManager, tableNameWithType, "ONLINE");
        if (onlineSegments.isEmpty()) {
            LOGGER.info("No ONLINE segment found for table: {}", (Object)tableNameWithType);
            return true;
        }
        HelixDataAccessor dataAccessor = helixManager.getHelixDataAccessor();
        LiveInstance liveInstance = (LiveInstance)dataAccessor.getProperty((keyBuilder = dataAccessor.keyBuilder()).liveInstance(instanceName = helixManager.getInstanceName()));
        if (liveInstance == null) {
            LOGGER.warn("Failed to find live instance for instance: {}", (Object)instanceName);
            return false;
        }
        String sessionId = liveInstance.getEphemeralOwner();
        CurrentState currentState = (CurrentState)dataAccessor.getProperty(keyBuilder.currentState(instanceName, sessionId, tableNameWithType));
        if (currentState == null) {
            LOGGER.warn("Failed to find current state for instance: {}, sessionId: {}, table: {}", new Object[]{instanceName, sessionId, tableNameWithType});
            return false;
        }
        ArrayList<String> unloadedSegments = new ArrayList<String>();
        Map currentStateMap = currentState.getPartitionStateMap();
        for (String segmentName : onlineSegments) {
            String actualState = (String)currentStateMap.get(segmentName);
            if ("ONLINE".equals(actualState)) continue;
            if ("ERROR".equals(actualState)) {
                LOGGER.error("Found segment: {}, table: {} in ERROR state, expected: {}", new Object[]{segmentName, tableNameWithType, "ONLINE"});
                return false;
            }
            unloadedSegments.add(segmentName);
        }
        if (unloadedSegments.isEmpty()) {
            LOGGER.info("All segments loaded for table: {}", (Object)tableNameWithType);
            return true;
        }
        int numUnloadedSegments = unloadedSegments.size();
        if (numUnloadedSegments <= 10) {
            LOGGER.info("Found {} unloaded segments: {} for table: {}", new Object[]{numUnloadedSegments, unloadedSegments, tableNameWithType});
        } else {
            LOGGER.info("Found {} unloaded segments: {}... for table: {}", new Object[]{numUnloadedSegments, unloadedSegments.subList(0, 10), tableNameWithType});
        }
        return false;
    }
}

