/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.aggregator;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.segment.local.aggregator.ValueAggregator;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BigDecimalUtils;

public class SumPrecisionValueAggregator
implements ValueAggregator<Object, BigDecimal> {
    public static final FieldSpec.DataType AGGREGATED_VALUE_TYPE = FieldSpec.DataType.BYTES;
    private final int _fixedSize;
    private int _maxByteSize;

    public SumPrecisionValueAggregator(List<ExpressionContext> arguments) {
        this._fixedSize = arguments.isEmpty() ? -1 : BigDecimalUtils.byteSizeForFixedPrecision((int)arguments.get(0).getLiteral().getIntValue());
    }

    @Override
    public AggregationFunctionType getAggregationType() {
        return AggregationFunctionType.SUMPRECISION;
    }

    @Override
    public FieldSpec.DataType getAggregatedValueType() {
        return AGGREGATED_VALUE_TYPE;
    }

    @Override
    public BigDecimal getInitialAggregatedValue(Object rawValue) {
        BigDecimal initialValue = SumPrecisionValueAggregator.toBigDecimal(rawValue);
        if (this._fixedSize < 0) {
            this._maxByteSize = Math.max(this._maxByteSize, BigDecimalUtils.byteSize((BigDecimal)initialValue));
        }
        return initialValue;
    }

    @Override
    public BigDecimal applyRawValue(BigDecimal value, Object rawValue) {
        value = value.add(SumPrecisionValueAggregator.toBigDecimal(rawValue));
        if (this._fixedSize < 0) {
            this._maxByteSize = Math.max(this._maxByteSize, BigDecimalUtils.byteSize((BigDecimal)value));
        }
        return value;
    }

    private static BigDecimal toBigDecimal(Object rawValue) {
        if (rawValue instanceof byte[]) {
            return BigDecimalUtils.deserialize((byte[])((byte[])rawValue));
        }
        if (rawValue instanceof Integer || rawValue instanceof Long) {
            return BigDecimal.valueOf(((Number)rawValue).longValue());
        }
        return new BigDecimal(rawValue.toString());
    }

    @Override
    public BigDecimal applyAggregatedValue(BigDecimal value, BigDecimal aggregatedValue) {
        value = value.add(aggregatedValue);
        if (this._fixedSize < 0) {
            this._maxByteSize = Math.max(this._maxByteSize, BigDecimalUtils.byteSize((BigDecimal)value));
        }
        return value;
    }

    @Override
    public BigDecimal cloneAggregatedValue(BigDecimal value) {
        return value;
    }

    @Override
    public int getMaxAggregatedValueByteSize() {
        Preconditions.checkState((this._fixedSize > 0 || this._maxByteSize > 0 ? 1 : 0) != 0, (Object)"Unknown max aggregated value byte size, please provide maximum precision as the second argument");
        return this._fixedSize > 0 ? this._fixedSize : this._maxByteSize;
    }

    @Override
    public byte[] serializeAggregatedValue(BigDecimal value) {
        return this._fixedSize > 0 ? BigDecimalUtils.serializeWithSize((BigDecimal)value, (int)this._fixedSize) : BigDecimalUtils.serialize((BigDecimal)value);
    }

    @Override
    public BigDecimal deserializeAggregatedValue(byte[] bytes) {
        return BigDecimalUtils.deserialize((byte[])bytes);
    }
}

