/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.customobject;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public abstract class CustomObjectAccumulator<T> {
    protected ArrayList<T> _accumulator;
    private int _threshold;
    private int _numInputs = 0;

    public CustomObjectAccumulator() {
        this(2);
    }

    public CustomObjectAccumulator(int threshold) {
        this.setThreshold(threshold);
    }

    public void setThreshold(int threshold) {
        Preconditions.checkArgument((threshold > 0 ? 1 : 0) != 0, (String)"Invalid threshold: %s, must be positive", (int)threshold);
        this._threshold = threshold;
    }

    public int getThreshold() {
        return this._threshold;
    }

    public int getNumInputs() {
        return this._numInputs;
    }

    public boolean isEmpty() {
        return this._numInputs == 0;
    }

    @Nonnull
    public abstract T getResult();

    public void merge(CustomObjectAccumulator<T> other) {
        if (other.isEmpty()) {
            return;
        }
        T result = other.getResult();
        this.applyInternal(result);
    }

    public void apply(T item) {
        Preconditions.checkNotNull(item);
        this.applyInternal(item);
    }

    private void applyInternal(T item) {
        if (this._accumulator == null) {
            this._accumulator = new ArrayList(this._threshold);
        }
        this._accumulator.add(item);
        ++this._numInputs;
        if (this._accumulator.size() >= this._threshold) {
            this.getResult();
            this._accumulator.clear();
        }
    }
}

