/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.customobject;

import java.util.Comparator;
import javax.annotation.Nonnull;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.Union;
import org.apache.datasketches.tuple.aninteger.IntegerSummary;
import org.apache.datasketches.tuple.aninteger.IntegerSummarySetOperations;
import org.apache.pinot.segment.local.customobject.CustomObjectAccumulator;

public class TupleIntSketchAccumulator
extends CustomObjectAccumulator<Sketch<IntegerSummary>> {
    private IntegerSummarySetOperations _setOperations;
    private int _nominalEntries;
    private Union<IntegerSummary> _union;

    public TupleIntSketchAccumulator() {
    }

    public TupleIntSketchAccumulator(IntegerSummarySetOperations setOperations, int nominalEntries, int threshold) {
        super(threshold);
        this._nominalEntries = nominalEntries;
        this._setOperations = setOperations;
    }

    public void setSetOperations(IntegerSummarySetOperations setOperations) {
        this._setOperations = setOperations;
    }

    public void setNominalEntries(int nominalEntries) {
        this._nominalEntries = nominalEntries;
    }

    @Override
    @Nonnull
    public Sketch<IntegerSummary> getResult() {
        return this.unionAll();
    }

    private Sketch<IntegerSummary> unionAll() {
        if (this._union == null) {
            this._union = new Union(this._nominalEntries, (SummarySetOperations)this._setOperations);
        }
        if (this.isEmpty()) {
            return this._union.getResult();
        }
        if (this.getNumInputs() == 1) {
            return (Sketch)this._accumulator.get(0);
        }
        this._accumulator.sort(Comparator.comparingDouble(Sketch::getTheta));
        for (Sketch accumulatedSketch : this._accumulator) {
            this._union.union(accumulatedSketch);
        }
        this._accumulator.clear();
        return this._union.getResult();
    }
}

