/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.data.manager;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pinot.segment.spi.IndexSegment;

public abstract class SegmentDataManager {
    private final long _loadTimeMs = System.currentTimeMillis();
    private final AtomicBoolean _offloaded = new AtomicBoolean();
    private final AtomicBoolean _destroyed = new AtomicBoolean();
    private int _referenceCount = 1;

    public long getLoadTimeMs() {
        return this._loadTimeMs;
    }

    public synchronized int getReferenceCount() {
        return this._referenceCount;
    }

    public synchronized boolean increaseReferenceCount() {
        if (this._referenceCount == 0) {
            return false;
        }
        ++this._referenceCount;
        return true;
    }

    public synchronized boolean decreaseReferenceCount() {
        if (this._referenceCount <= 1) {
            this._referenceCount = 0;
            return true;
        }
        --this._referenceCount;
        return false;
    }

    public abstract String getSegmentName();

    public abstract IndexSegment getSegment();

    public boolean hasMultiSegments() {
        return false;
    }

    public List<IndexSegment> getSegments() {
        return Collections.emptyList();
    }

    public void offload() {
        if (this._offloaded.compareAndSet(false, true)) {
            this.doOffload();
        }
    }

    public abstract void doOffload();

    public void destroy() {
        assert (this._offloaded.get()) : "Cannot destroy segment data manager without offloading it first";
        this.offload();
        if (this._destroyed.compareAndSet(false, true)) {
            this.doDestroy();
        }
    }

    protected abstract void doDestroy();
}

