/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.dedup;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.dedup.DedupRecordInfo;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentColumnReader;
import org.apache.pinot.segment.local.segment.readers.PrimaryKeyReader;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.spi.data.readers.PrimaryKey;

public class DedupUtils {
    private DedupUtils() {
    }

    public static Iterator<DedupRecordInfo> getDedupRecordInfoIterator(final DedupRecordInfoReader dedupRecordInfoReader, final int numDocs) {
        return new Iterator<DedupRecordInfo>(){
            private int _docId = 0;

            @Override
            public boolean hasNext() {
                return this._docId < numDocs;
            }

            @Override
            public DedupRecordInfo next() {
                return dedupRecordInfoReader.getDedupRecordInfo(this._docId++);
            }
        };
    }

    public static class DedupRecordInfoReader
    implements Closeable {
        private final PrimaryKeyReader _primaryKeyReader;
        private final PinotSegmentColumnReader _dedupTimeColumnReader;

        public DedupRecordInfoReader(IndexSegment segment, List<String> primaryKeyColumns, @Nullable String dedupTimeColumn) {
            this._primaryKeyReader = new PrimaryKeyReader(segment, primaryKeyColumns);
            this._dedupTimeColumnReader = dedupTimeColumn != null ? new PinotSegmentColumnReader(segment, dedupTimeColumn) : null;
        }

        @VisibleForTesting
        public DedupRecordInfoReader(PrimaryKeyReader primaryKeyReader, @Nullable PinotSegmentColumnReader dedupTimeColumnReader) {
            this._primaryKeyReader = primaryKeyReader;
            this._dedupTimeColumnReader = dedupTimeColumnReader;
        }

        public DedupRecordInfo getDedupRecordInfo(int docId) {
            PrimaryKey primaryKey = this._primaryKeyReader.getPrimaryKey(docId);
            double dedupTime = this._dedupTimeColumnReader != null ? ((Number)this._dedupTimeColumnReader.getValue(docId)).doubleValue() : Double.MIN_VALUE;
            return new DedupRecordInfo(primaryKey, dedupTime);
        }

        @Override
        public void close() throws IOException {
            this._primaryKeyReader.close();
            if (this._dedupTimeColumnReader != null) {
                this._dedupTimeColumnReader.close();
            }
        }
    }
}

