/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.function;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pinot.segment.local.function.FunctionEvaluator;
import org.apache.pinot.spi.data.readers.GenericRow;

public class GroovyFunctionEvaluator
implements FunctionEvaluator {
    private static final String GROOVY_EXPRESSION_PREFIX = "Groovy";
    private static final String GROOVY_FUNCTION_REGEX = "Groovy\\(\\{(?<script>.+)}(,(?<arguments>.+))?\\)";
    private static final Pattern GROOVY_FUNCTION_PATTERN = Pattern.compile("Groovy\\(\\{(?<script>.+)}(,(?<arguments>.+))?\\)", 2);
    private static final String ARGUMENTS_GROUP_NAME = "arguments";
    private static final String SCRIPT_GROUP_NAME = "script";
    private static final String ARGUMENTS_SEPARATOR = ",";
    private final List<String> _arguments;
    private final int _numArguments;
    private final Binding _binding;
    private final Script _script;
    private final String _expression;

    public GroovyFunctionEvaluator(String closure) {
        this._expression = closure;
        Matcher matcher = GROOVY_FUNCTION_PATTERN.matcher(closure);
        Preconditions.checkState((boolean)matcher.matches(), (String)"Invalid transform expression: %s", (Object)closure);
        String arguments = matcher.group(ARGUMENTS_GROUP_NAME);
        this._arguments = arguments != null ? Splitter.on((String)ARGUMENTS_SEPARATOR).trimResults().splitToList((CharSequence)arguments) : Collections.emptyList();
        this._numArguments = this._arguments.size();
        this._binding = new Binding();
        this._script = new GroovyShell(this._binding).parse(matcher.group(SCRIPT_GROUP_NAME));
    }

    public static String getGroovyExpressionPrefix() {
        return GROOVY_EXPRESSION_PREFIX;
    }

    @Override
    public List<String> getArguments() {
        return this._arguments;
    }

    @Override
    public Object evaluate(GenericRow genericRow) {
        boolean hasNullArgument = false;
        for (String argument : this._arguments) {
            Object value = genericRow.getValue(argument);
            if (value == null) {
                hasNullArgument = true;
            }
            this._binding.setVariable(argument, value);
        }
        try {
            return this._script.run();
        }
        catch (Exception e) {
            if (hasNullArgument) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public Object evaluate(Object[] values) {
        for (int i = 0; i < this._numArguments; ++i) {
            this._binding.setVariable(this._arguments.get(i), values[i]);
        }
        return this._script.run();
    }

    public String toString() {
        return this._expression;
    }
}

