/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.readerwriter;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.memory.PinotDataBufferMemoryManager;

@NotThreadSafe
public abstract class RealtimeIndexOffHeapMemoryManager
implements PinotDataBufferMemoryManager {
    private final List<PinotDataBuffer> _buffers = new ArrayList<PinotDataBuffer>();
    private final String _rawTableName;
    private final String _segmentName;
    private final ServerMetrics _serverMetrics;
    private long _totalAllocatedBytes = 0L;

    protected RealtimeIndexOffHeapMemoryManager(ServerMetrics serverMetrics, String segmentName) {
        this._serverMetrics = serverMetrics;
        this._segmentName = segmentName;
        LLCSegmentName llcSegmentName = LLCSegmentName.of((String)segmentName);
        this._rawTableName = llcSegmentName != null ? llcSegmentName.getTableName() : "NoSuchTable";
    }

    public PinotDataBuffer allocate(long size, String allocationContext) {
        Preconditions.checkArgument((size > 0L ? 1 : 0) != 0, (Object)("Illegal memory allocation " + size + " for segment " + this._segmentName + " column " + allocationContext));
        PinotDataBuffer buffer = this.allocateInternal(size, allocationContext);
        this._totalAllocatedBytes += size;
        this._buffers.add(buffer);
        if (this._serverMetrics != null) {
            this._serverMetrics.addValueToTableGauge(this._rawTableName, (AbstractMetrics.Gauge)ServerGauge.REALTIME_OFFHEAP_MEMORY_USED, size);
        }
        return buffer;
    }

    protected abstract void doClose() throws IOException;

    protected abstract PinotDataBuffer allocateInternal(long var1, String var3);

    public void close() throws IOException {
        for (PinotDataBuffer buffer : this._buffers) {
            buffer.close();
        }
        if (this._serverMetrics != null) {
            this._serverMetrics.addValueToTableGauge(this._rawTableName, (AbstractMetrics.Gauge)ServerGauge.REALTIME_OFFHEAP_MEMORY_USED, -this._totalAllocatedBytes);
        }
        this.doClose();
        this._buffers.clear();
        this._totalAllocatedBytes = 0L;
    }

    public long getTotalAllocatedBytes() {
        return this._totalAllocatedBytes;
    }
}

