/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.forward;

import com.yscope.clp.compressorfrontend.EncodedMessage;
import com.yscope.clp.compressorfrontend.FlattenedByteArray;
import com.yscope.clp.compressorfrontend.FlattenedByteArrayFactory;
import com.yscope.clp.compressorfrontend.MessageDecoder;
import com.yscope.clp.compressorfrontend.MessageEncoder;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.validation.constraints.NotNull;
import org.apache.pinot.segment.local.realtime.impl.dictionary.BytesOffHeapMutableDictionary;
import org.apache.pinot.segment.local.realtime.impl.forward.FixedByteSVMutableForwardIndex;
import org.apache.pinot.segment.local.realtime.impl.forward.VarByteSVMutableForwardIndex;
import org.apache.pinot.segment.local.segment.creator.impl.stats.CLPStatsProvider;
import org.apache.pinot.segment.spi.index.mutable.MutableForwardIndex;
import org.apache.pinot.segment.spi.memory.PinotDataBufferMemoryManager;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CLPMutableForwardIndexV2
implements MutableForwardIndex {
    protected static final Logger LOGGER = LoggerFactory.getLogger(CLPMutableForwardIndexV2.class);
    public final String _columnName;
    protected final EncodedMessage _clpEncodedMessage;
    protected final EncodedMessage _failToEncodeClpEncodedMessage;
    protected final MessageEncoder _clpMessageEncoder;
    protected final MessageDecoder _clpMessageDecoder;
    protected int _nextDocId = 0;
    protected int _nextDictVarDocId = 0;
    protected int _nextEncodedVarId = 0;
    protected int _bytesRawFwdIndexDocIdStartOffset = Integer.MAX_VALUE;
    protected boolean _isClpEncoded = true;
    protected int _lengthOfLongestElement;
    protected int _lengthOfShortestElement;
    protected int _maxNumDictVarIdPerDoc = 0;
    protected int _maxNumEncodedVarPerDoc = 0;
    protected int _numDocsWithNoDictVar = 0;
    protected int _numDocsWithNoEncodedVar = 0;
    protected VarByteSVMutableForwardIndex _rawBytes;
    protected BytesOffHeapMutableDictionary _logtypeDict;
    protected FixedByteSVMutableForwardIndex _logtypeId;
    protected BytesOffHeapMutableDictionary _dictVarDict;
    protected FixedByteSVMutableForwardIndex _dictVarOffset;
    protected FixedByteSVMutableForwardIndex _dictVarId;
    protected FixedByteSVMutableForwardIndex _encodedVarOffset;
    protected FixedByteSVMutableForwardIndex _encodedVar;
    protected int _estimatedMaxDocCount = 65536;
    protected int _rawMessageEstimatedAvgEncodedLength = 256;
    protected int _estimatedLogtypeAvgEncodedLength = 256;
    protected int _logtypeIdNumRowsPerChunk = this._estimatedMaxDocCount;
    protected int _logtypeDictEstimatedCardinality = this._estimatedMaxDocCount / 16;
    protected int _dictVarDictEstimatedCardinality = this._estimatedMaxDocCount / 8;
    protected int _logtypeDictMaxOverflowHashSize = 128;
    protected int _dictVarEstimatedAverageLength = 64;
    protected int _dictVarOffsetPerChunk = 4096;
    protected int _dictVarIdPerChunk = 262144;
    protected int _dictVarDictMaxOverflowHashSize = 256;
    protected int _encodedVarOffsetPerChunk = 4096;
    protected int _encodedVarPerChunk = 262144;
    protected int _minNumDocsBeforeCardinalityMonitoring = this._estimatedMaxDocCount / 8;
    protected boolean _forceEnableClpEncoding = false;
    protected int _inverseLogtypeCardinalityRatioStopThreshold = 10;
    protected int _inverseDictVarCardinalityRatioStopThreshold = 10;

    public CLPMutableForwardIndexV2(String columnName, PinotDataBufferMemoryManager memoryManager) {
        this._columnName = columnName;
        this._clpEncodedMessage = new EncodedMessage();
        this._clpMessageEncoder = new MessageEncoder("com.yscope.clp.VariablesSchemaV2", "com.yscope.clp.VariableEncodingMethodsV1");
        this._clpMessageDecoder = new MessageDecoder("com.yscope.clp.VariablesSchemaV2", "com.yscope.clp.VariableEncodingMethodsV1");
        this._failToEncodeClpEncodedMessage = new EncodedMessage();
        try {
            this._clpMessageEncoder.encodeMessage("Failed to encode message", this._failToEncodeClpEncodedMessage);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Failed to encode error message", ex);
        }
        this._rawBytes = new VarByteSVMutableForwardIndex(FieldSpec.DataType.BYTES, memoryManager, columnName + "_rawBytes.fwd", this._estimatedMaxDocCount, this._rawMessageEstimatedAvgEncodedLength);
        this._logtypeId = new FixedByteSVMutableForwardIndex(false, FieldSpec.DataType.INT, this._logtypeIdNumRowsPerChunk, memoryManager, columnName + "_logtypeId.fwd");
        this._logtypeDict = new BytesOffHeapMutableDictionary(this._logtypeDictEstimatedCardinality, this._logtypeDictMaxOverflowHashSize, memoryManager, columnName + "_logtype.dict", this._estimatedLogtypeAvgEncodedLength);
        this._dictVarOffset = new FixedByteSVMutableForwardIndex(false, FieldSpec.DataType.INT, this._dictVarOffsetPerChunk, memoryManager, columnName + "_dictVarOffsets.fwd");
        this._dictVarId = new FixedByteSVMutableForwardIndex(false, FieldSpec.DataType.INT, this._dictVarIdPerChunk, memoryManager, columnName + "_dictVarIds.fwd");
        this._dictVarDict = new BytesOffHeapMutableDictionary(this._dictVarDictEstimatedCardinality, this._dictVarDictMaxOverflowHashSize, memoryManager, columnName + "_dictVar.dict", this._dictVarEstimatedAverageLength);
        this._encodedVarOffset = new FixedByteSVMutableForwardIndex(false, FieldSpec.DataType.INT, this._encodedVarOffsetPerChunk, memoryManager, columnName + "_encodedVarOffsets.fwd");
        this._encodedVar = new FixedByteSVMutableForwardIndex(false, FieldSpec.DataType.LONG, this._encodedVarPerChunk, memoryManager, columnName + "_encodedVar.fwd");
        this._dictVarOffset.setInt(0, 0);
        this._encodedVarOffset.setInt(0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(int docId, String value) {
        EncodedMessage encodedMessage = this._clpEncodedMessage;
        try {
            this._clpMessageEncoder.encodeMessage(value, encodedMessage);
        }
        catch (IOException e) {
            encodedMessage = this._failToEncodeClpEncodedMessage;
        }
        finally {
            this.appendEncodedMessage(encodedMessage);
        }
    }

    public void appendEncodedMessage(@NotNull EncodedMessage clpEncodedMessage) {
        if (this._isClpEncoded || this._forceEnableClpEncoding) {
            this._logtypeId.setInt(this._nextDocId, this._logtypeDict.index((Object)clpEncodedMessage.getLogtype()));
            FlattenedByteArray flattenedDictVars = clpEncodedMessage.getDictionaryVarsAsFlattenedByteArray();
            if (null == flattenedDictVars || 0 == flattenedDictVars.size()) {
                ++this._numDocsWithNoDictVar;
            } else {
                for (byte[] byArray : flattenedDictVars) {
                    this._dictVarId.setInt(this._nextDictVarDocId++, this._dictVarDict.index((Object)byArray));
                }
                this._maxNumDictVarIdPerDoc = Math.max(this._maxNumDictVarIdPerDoc, flattenedDictVars.size());
            }
            this._dictVarOffset.setInt(this._nextDocId, this._nextDictVarDocId);
            long[] encodedVars = clpEncodedMessage.getEncodedVars();
            if (null == encodedVars || 0 == encodedVars.length) {
                ++this._numDocsWithNoEncodedVar;
            } else {
                for (long encodedVar : encodedVars) {
                    this._encodedVar.setLong(this._nextEncodedVarId++, encodedVar);
                }
                this._maxNumEncodedVarPerDoc = Math.max(this._maxNumEncodedVarPerDoc, encodedVars.length);
            }
            this._encodedVarOffset.setInt(this._nextDocId, this._nextEncodedVarId);
            if (this._nextDocId > this._minNumDocsBeforeCardinalityMonitoring && !this._forceEnableClpEncoding) {
                int inverseDictVarCardinalityRatio;
                int n = this._nextDocId / this._logtypeDict.length();
                if (n < this._inverseLogtypeCardinalityRatioStopThreshold) {
                    this._isClpEncoded = false;
                    this._bytesRawFwdIndexDocIdStartOffset = this._nextDocId + 1;
                } else if (this._dictVarDict.length() > 0 && (inverseDictVarCardinalityRatio = Math.max(this._nextDocId, this._nextDictVarDocId) / this._dictVarDict.length()) < this._inverseDictVarCardinalityRatioStopThreshold) {
                    this._isClpEncoded = false;
                    this._bytesRawFwdIndexDocIdStartOffset = this._nextDocId + 1;
                }
            }
        } else {
            this._rawBytes.setBytes(this._nextDocId - this._bytesRawFwdIndexDocIdStartOffset, clpEncodedMessage.getMessage());
        }
        ++this._nextDocId;
        this._lengthOfLongestElement = Math.max(this._lengthOfLongestElement, clpEncodedMessage.getMessage().length);
        this._lengthOfShortestElement = Math.min(this._lengthOfShortestElement, clpEncodedMessage.getMessage().length);
    }

    public int getNumDoc() {
        return this._nextDocId;
    }

    public int getNumLogtype() {
        return this._isClpEncoded ? this._nextDocId : 0;
    }

    public int getNumDictVar() {
        return this._isClpEncoded ? this._nextDictVarDocId : 0;
    }

    public int getNumEncodedVar() {
        return this._isClpEncoded ? this._nextEncodedVarId : 0;
    }

    public void forceClpEncoding() {
        this._forceEnableClpEncoding = true;
    }

    public void forceRawEncoding() {
        this._isClpEncoded = false;
        this._bytesRawFwdIndexDocIdStartOffset = 0;
    }

    public String getColumnName() {
        return this._columnName;
    }

    public String getString(int docId) {
        return new String(this.getRawBytes(docId), StandardCharsets.UTF_8);
    }

    public byte[] getRawBytes(int docId) {
        if (docId < 0) {
            throw new IllegalArgumentException("Invalid docId: " + docId);
        }
        if (docId < this._bytesRawFwdIndexDocIdStartOffset) {
            byte[] logtype = this._logtypeDict.get(this._logtypeId.getInt(docId));
            int dictVarIdBeginOffset = 0 == docId ? 0 : this._dictVarOffset.getInt(docId - 1);
            int dictVarIdEndOffset = this._dictVarOffset.getInt(docId);
            byte[][] dictVars = new byte[dictVarIdEndOffset - dictVarIdBeginOffset][];
            for (int i = 0; i < dictVars.length; ++i) {
                dictVars[i] = this._dictVarDict.get(this._dictVarId.getInt(dictVarIdBeginOffset + i));
            }
            FlattenedByteArray flattenedDictVars = FlattenedByteArrayFactory.fromByteArrays((byte[][])dictVars);
            int encodedVarIdBeginOffset = 0 == docId ? 0 : this._encodedVarOffset.getInt(docId - 1);
            int encodedVarIdEndOffset = this._encodedVarOffset.getInt(docId);
            long[] encodedVars = new long[encodedVarIdEndOffset - encodedVarIdBeginOffset];
            for (int i = 0; i < encodedVars.length; ++i) {
                encodedVars[i] = this._encodedVar.getLong(encodedVarIdBeginOffset + i);
            }
            try {
                return this._clpMessageDecoder.decodeMessageAsBytes(logtype, flattenedDictVars, encodedVars);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to encode message: " + new String(logtype, StandardCharsets.ISO_8859_1), e);
            }
        }
        return this._rawBytes.getBytes(docId - this._bytesRawFwdIndexDocIdStartOffset);
    }

    public FixedByteSVMutableForwardIndex getLogtypeId() {
        return this._logtypeId;
    }

    public BytesOffHeapMutableDictionary getLogtypeDict() {
        return this._logtypeDict;
    }

    public FixedByteSVMutableForwardIndex getDictVarOffset() {
        return this._dictVarOffset;
    }

    public FixedByteSVMutableForwardIndex getDictVarId() {
        return this._dictVarId;
    }

    public BytesOffHeapMutableDictionary getDictVarDict() {
        return this._dictVarDict;
    }

    public FixedByteSVMutableForwardIndex getEncodedVarOffset() {
        return this._encodedVarOffset;
    }

    public FixedByteSVMutableForwardIndex getEncodedVar() {
        return this._encodedVar;
    }

    public boolean isClpEncoded() {
        return this._isClpEncoded;
    }

    public boolean isDictionaryEncoded() {
        return false;
    }

    public int getLengthOfLongestElement() {
        return this._lengthOfLongestElement;
    }

    public int getLengthOfShortestElement() {
        return this._lengthOfShortestElement;
    }

    public int getMaxNumDictVarIdPerDoc() {
        return this._maxNumDictVarIdPerDoc;
    }

    public int getMaxNumEncodedVarPerDoc() {
        return this._maxNumEncodedVarPerDoc;
    }

    public CLPStatsProvider.CLPStats getCLPStats() {
        if (!this.isClpEncoded()) {
            throw new UnsupportedOperationException("CLP encoding is required for compatibility support. Please call the forceClpEncoding() method immediately after class initialization to ensure compatibility.");
        }
        String[] sortedLogtypeDictValues = this.getSortedDictionaryValuesAsStrings(this._logtypeDict, StandardCharsets.ISO_8859_1);
        String[] sortedDictVarDictValues = this.getSortedDictionaryValuesAsStrings(this._dictVarDict, StandardCharsets.UTF_8);
        int totalNumberOfDictVars = this._nextDictVarDocId;
        int totalNumberOfEncodedVars = this._nextEncodedVarId;
        int maxNumberOfEncodedVars = this._maxNumEncodedVarPerDoc;
        return new CLPStatsProvider.CLPStats(sortedLogtypeDictValues, sortedDictVarDictValues, totalNumberOfDictVars, totalNumberOfEncodedVars, maxNumberOfEncodedVars);
    }

    public CLPStatsProvider.CLPV2Stats getCLPV2Stats() {
        return new CLPStatsProvider.CLPV2Stats(this);
    }

    public String[] getSortedDictionaryValuesAsStrings(BytesOffHeapMutableDictionary dict, Charset charset) {
        int numValues = dict.length();
        Object[] sortedValues = new String[numValues];
        for (int dictId = 0; dictId < numValues; ++dictId) {
            sortedValues[dictId] = new String(dict.getBytesValue(dictId), charset);
        }
        Arrays.sort(sortedValues);
        return sortedValues;
    }

    public boolean isSingleValue() {
        return true;
    }

    public FieldSpec.DataType getStoredType() {
        return FieldSpec.DataType.STRING;
    }

    public void close() throws IOException {
        this._rawBytes.close();
        this.closeClpLogtypeIndex();
    }

    protected void closeClpLogtypeIndex() throws IOException {
        if (this._logtypeDict != null) {
            this._logtypeDict.close();
            this._logtypeDict = null;
        }
        if (this._logtypeId != null) {
            this._logtypeId.close();
            this._logtypeId = null;
        }
        if (this._dictVarOffset != null) {
            this._dictVarOffset.close();
            this._dictVarOffset = null;
        }
        if (this._dictVarDict != null) {
            this._dictVarDict.close();
            this._dictVarDict = null;
        }
        if (this._dictVarId != null) {
            this._dictVarId.close();
            this._dictVarId = null;
        }
        if (this._encodedVarOffset != null) {
            this._encodedVarOffset.close();
            this._encodedVarOffset = null;
        }
        if (this._encodedVar != null) {
            this._encodedVar.close();
            this._encodedVar = null;
        }
    }
}

