/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.recordtransformer;

import java.util.List;
import org.apache.pinot.segment.local.function.FunctionEvaluator;
import org.apache.pinot.segment.local.function.FunctionEvaluatorFactory;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.recordtransformer.RecordTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterTransformer
implements RecordTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterTransformer.class);
    private String _filterFunction = null;
    private final FunctionEvaluator _evaluator;
    private final boolean _continueOnError;

    public FilterTransformer(TableConfig tableConfig) {
        boolean bl = this._continueOnError = tableConfig.getIngestionConfig() != null && tableConfig.getIngestionConfig().isContinueOnError();
        if (tableConfig.getIngestionConfig() != null && tableConfig.getIngestionConfig().getFilterConfig() != null) {
            this._filterFunction = tableConfig.getIngestionConfig().getFilterConfig().getFilterFunction();
        }
        this._evaluator = this._filterFunction != null ? FunctionEvaluatorFactory.getExpressionEvaluator(this._filterFunction) : null;
    }

    public boolean isNoOp() {
        return this._evaluator == null;
    }

    public List<String> getInputColumns() {
        return this._evaluator != null ? this._evaluator.getArguments() : List.of();
    }

    public GenericRow transform(GenericRow record) {
        if (this._evaluator != null) {
            try {
                Object result = this._evaluator.evaluate(record);
                if (Boolean.TRUE.equals(result)) {
                    record.putValue("$SKIP_RECORD_KEY$", (Object)true);
                }
            }
            catch (Exception e) {
                if (!this._continueOnError) {
                    throw new RuntimeException(String.format("Caught exception while executing filter function: %s for record: %s", this._filterFunction, record.toString()), e);
                }
                LOGGER.debug("Caught exception while executing filter function: {} for record: {}", new Object[]{this._filterFunction, record.toString(), e});
                record.putValue("$INCOMPLETE_RECORD_KEY$", (Object)true);
            }
        }
        return record;
    }
}

