/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.recordtransformer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.recordtransformer.RecordTransformer;
import org.apache.pinot.spi.utils.StringUtil;

public class SanitizationTransformer
implements RecordTransformer {
    private static final String NULL_CHARACTER = "\u0000";
    private final Map<String, SanitizedColumnInfo> _columnToColumnInfoMap = new HashMap<String, SanitizedColumnInfo>();

    public SanitizationTransformer(Schema schema) {
        for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
            FieldSpec.MaxLengthExceedStrategy maxLengthExceedStrategy;
            if (fieldSpec.isVirtualColumn()) continue;
            if (fieldSpec.getDataType().equals((Object)FieldSpec.DataType.STRING)) {
                maxLengthExceedStrategy = fieldSpec.getMaxLengthExceedStrategy() == null ? FieldSpec.MaxLengthExceedStrategy.TRIM_LENGTH : fieldSpec.getMaxLengthExceedStrategy();
                this._columnToColumnInfoMap.put(fieldSpec.getName(), new SanitizedColumnInfo(fieldSpec.getName(), fieldSpec.getMaxLength(), maxLengthExceedStrategy, fieldSpec.getDefaultNullValue()));
                continue;
            }
            if (!fieldSpec.getDataType().equals((Object)FieldSpec.DataType.JSON) && !fieldSpec.getDataType().equals((Object)FieldSpec.DataType.BYTES)) continue;
            FieldSpec.MaxLengthExceedStrategy maxLengthExceedStrategy2 = maxLengthExceedStrategy = fieldSpec.getMaxLengthExceedStrategy() == null ? FieldSpec.MaxLengthExceedStrategy.NO_ACTION : fieldSpec.getMaxLengthExceedStrategy();
            if (maxLengthExceedStrategy.equals((Object)FieldSpec.MaxLengthExceedStrategy.NO_ACTION)) continue;
            this._columnToColumnInfoMap.put(fieldSpec.getName(), new SanitizedColumnInfo(fieldSpec.getName(), fieldSpec.getMaxLength(), fieldSpec.getMaxLengthExceedStrategy(), fieldSpec.getDefaultNullValue()));
        }
    }

    public boolean isNoOp() {
        return this._columnToColumnInfoMap.isEmpty();
    }

    public GenericRow transform(GenericRow record) {
        for (Map.Entry<String, SanitizedColumnInfo> entry : this._columnToColumnInfoMap.entrySet()) {
            Object result;
            String columnName = entry.getKey();
            Object value = record.getValue(columnName);
            if (value instanceof byte[]) {
                result = this.sanitizeBytesValue(columnName, (byte[])value, entry.getValue());
                record.putValue(columnName, result.getLeft());
                if (!((Boolean)result.getRight()).booleanValue()) continue;
                record.putValue("$SANITIZED_RECORD_KEY$", (Object)true);
                continue;
            }
            if (value instanceof String) {
                result = this.sanitizeValue(columnName, (String)value, entry.getValue());
                record.putValue(columnName, result.getLeft());
                if (!((Boolean)result.getRight()).booleanValue()) continue;
                record.putValue("$SANITIZED_RECORD_KEY$", (Object)true);
                continue;
            }
            Object[] values = (Object[])value;
            for (int i = 0; i < values.length; ++i) {
                result = values[i] instanceof byte[] ? this.sanitizeBytesValue(columnName, (byte[])values[i], entry.getValue()) : this.sanitizeValue(columnName, values[i].toString(), entry.getValue());
                values[i] = result.getLeft();
                if (!((Boolean)result.getRight()).booleanValue()) continue;
                record.putValue("$SANITIZED_RECORD_KEY$", (Object)true);
            }
        }
        return record;
    }

    private Pair<String, Boolean> sanitizeValue(String columnName, String value, SanitizedColumnInfo sanitizedColumnInfo) {
        String sanitizedValue = StringUtil.sanitizeStringValue((String)value, (int)sanitizedColumnInfo.getMaxLength());
        FieldSpec.MaxLengthExceedStrategy maxLengthExceedStrategy = sanitizedColumnInfo.getMaxLengthExceedStrategy();
        if (sanitizedValue != value) {
            switch (maxLengthExceedStrategy) {
                case TRIM_LENGTH: {
                    return Pair.of((Object)sanitizedValue, (Object)true);
                }
                case SUBSTITUTE_DEFAULT_VALUE: {
                    return Pair.of((Object)FieldSpec.getStringValue((Object)sanitizedColumnInfo.getDefaultNullValue()), (Object)true);
                }
                case ERROR: {
                    int index = value.indexOf(NULL_CHARACTER);
                    if (index < 0) {
                        throw new IllegalStateException(String.format("Throwing exception as value: %s for column %s exceeds configured max length %d.", value, columnName, sanitizedColumnInfo.getMaxLength()));
                    }
                    throw new IllegalStateException(String.format("Throwing exception as value: %s for column %s contains null character.", value, columnName));
                }
                case NO_ACTION: {
                    int index = value.indexOf(NULL_CHARACTER);
                    if (index < 0) {
                        return Pair.of((Object)value, (Object)false);
                    }
                    return Pair.of((Object)sanitizedValue, (Object)true);
                }
            }
            throw new IllegalStateException("Unsupported max length exceed strategy: " + sanitizedColumnInfo.getMaxLengthExceedStrategy());
        }
        return Pair.of((Object)sanitizedValue, (Object)false);
    }

    private Pair<byte[], Boolean> sanitizeBytesValue(String columnName, byte[] value, SanitizedColumnInfo sanitizedColumnInfo) {
        if (value.length > sanitizedColumnInfo.getMaxLength()) {
            FieldSpec.MaxLengthExceedStrategy maxLengthExceedStrategy = sanitizedColumnInfo.getMaxLengthExceedStrategy();
            switch (maxLengthExceedStrategy) {
                case TRIM_LENGTH: {
                    return Pair.of((Object)Arrays.copyOf(value, sanitizedColumnInfo.getMaxLength()), (Object)true);
                }
                case SUBSTITUTE_DEFAULT_VALUE: {
                    return Pair.of((Object)((byte[])sanitizedColumnInfo.getDefaultNullValue()), (Object)true);
                }
                case ERROR: {
                    throw new IllegalStateException(String.format("Throwing exception as value for column %s exceeds configured max length %d.", columnName, sanitizedColumnInfo.getMaxLength()));
                }
                case NO_ACTION: {
                    return Pair.of((Object)value, (Object)false);
                }
            }
            throw new IllegalStateException("Unsupported max length exceed strategy: " + sanitizedColumnInfo.getMaxLengthExceedStrategy());
        }
        return Pair.of((Object)value, (Object)false);
    }

    private static class SanitizedColumnInfo {
        private final String _columnName;
        private final int _maxLength;
        private final FieldSpec.MaxLengthExceedStrategy _maxLengthExceedStrategy;
        private final Object _defaultNullValue;

        private SanitizedColumnInfo(String columnName, int maxLength, FieldSpec.MaxLengthExceedStrategy maxLengthExceedStrategy, Object defaultNullValue) {
            this._columnName = columnName;
            this._maxLength = maxLength;
            this._maxLengthExceedStrategy = maxLengthExceedStrategy;
            this._defaultNullValue = defaultNullValue;
        }

        public String getColumnName() {
            return this._columnName;
        }

        public int getMaxLength() {
            return this._maxLength;
        }

        public FieldSpec.MaxLengthExceedStrategy getMaxLengthExceedStrategy() {
            return this._maxLengthExceedStrategy;
        }

        public Object getDefaultNullValue() {
            return this._defaultNullValue;
        }
    }
}

