/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.inv;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.function.Consumer;
import org.apache.pinot.segment.spi.memory.CleanerUtil;

public class MmapFileWriter
implements Closeable {
    private final FileChannel _fileChannel;
    private final ByteBuffer _buffer;

    public MmapFileWriter(File file, int size) throws IOException {
        this._fileChannel = new RandomAccessFile(file, "rw").getChannel();
        this._buffer = this._fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, size);
    }

    public void write(Consumer<ByteBuffer> writer) {
        writer.accept(this._buffer);
    }

    @Override
    public void close() throws IOException {
        this._fileChannel.close();
        if (CleanerUtil.UNMAP_SUPPORTED) {
            CleanerUtil.BufferCleaner cleaner = CleanerUtil.getCleaner();
            cleaner.freeBuffer(this._buffer);
        }
    }
}

