/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.stats;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Map;
import org.apache.pinot.common.utils.PinotDataType;
import org.apache.pinot.segment.local.segment.creator.impl.stats.AbstractColumnStatisticsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.BigDecimalColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.DoubleColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.FloatColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.IntColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.LongColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.StringColumnPreIndexStatsCollector;
import org.apache.pinot.segment.spi.creator.StatsCollectorConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.data.DimensionFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.MapUtils;
import org.apache.pinot.spi.utils.builder.TableConfigBuilder;

public class MapColumnPreIndexStatsCollector
extends AbstractColumnStatisticsCollector {
    private final Object2ObjectOpenHashMap<String, AbstractColumnStatisticsCollector> _keyStats = new Object2ObjectOpenHashMap(1000);
    private String[] _sortedValues;
    private int _minLength = Integer.MAX_VALUE;
    private int _maxLength = 0;
    private boolean _sealed = false;

    public MapColumnPreIndexStatsCollector(String column, StatsCollectorConfig statsCollectorConfig) {
        super(column, statsCollectorConfig);
        this._sorted = false;
    }

    public AbstractColumnStatisticsCollector getKeyStatistics(String key) {
        return (AbstractColumnStatisticsCollector)this._keyStats.get((Object)key);
    }

    @Override
    public void collect(Object entry) {
        assert (!this._sealed);
        if (entry instanceof Map) {
            Map mapValue = (Map)entry;
            int length = MapUtils.serializeMap((Map)mapValue).length;
            this._minLength = Math.min(this._minLength, length);
            this._maxLength = Math.max(this._maxLength, length);
            for (Map.Entry mapValueEntry : mapValue.entrySet()) {
                String key = (String)mapValueEntry.getKey();
                Object value = mapValueEntry.getValue();
                AbstractColumnStatisticsCollector keyStats = (AbstractColumnStatisticsCollector)this._keyStats.get((Object)key);
                if (keyStats == null) {
                    keyStats = this.createKeyStatsCollector(key, value);
                    this._keyStats.put((Object)key, (Object)keyStats);
                    if (this.isPartitionEnabled()) {
                        this.updatePartition(key);
                    }
                }
                keyStats.collect(value);
            }
            ++this._totalNumberOfEntries;
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public String getMinValue() {
        if (this._sealed) {
            return this._sortedValues[0];
        }
        throw new IllegalStateException("you must seal the collector first before asking for min value");
    }

    public String getMaxValue() {
        if (this._sealed) {
            return this._sortedValues[this._sortedValues.length - 1];
        }
        throw new IllegalStateException("you must seal the collector first before asking for max value");
    }

    public String[] getUniqueValuesSet() {
        if (this._sealed) {
            return this._sortedValues;
        }
        throw new IllegalStateException("you must seal the collector first before asking for unique values set");
    }

    @Override
    public int getLengthOfShortestElement() {
        return this._minLength;
    }

    @Override
    public int getLengthOfLargestElement() {
        return this._maxLength;
    }

    public int getMaxRowLengthInBytes() {
        return this._maxLength;
    }

    public int getCardinality() {
        return this._keyStats.size();
    }

    @Override
    public void seal() {
        if (!this._sealed) {
            this._sortedValues = (String[])this._keyStats.keySet().toArray((Object[])new String[0]);
            Arrays.sort(this._sortedValues);
            for (AbstractColumnStatisticsCollector keyStatsCollector : this._keyStats.values()) {
                keyStatsCollector.seal();
            }
            this._sealed = true;
        }
    }

    private AbstractColumnStatisticsCollector createKeyStatsCollector(String key, Object value) {
        PinotDataType type = PinotDataType.getSingleValueType(value.getClass());
        TableConfig tableConfig = new TableConfigBuilder(TableType.OFFLINE).setTableName(key).build();
        Schema keySchema = new Schema.SchemaBuilder().setSchemaName(key).addField((FieldSpec)new DimensionFieldSpec(key, MapColumnPreIndexStatsCollector.convertToDataType(type), false)).build();
        StatsCollectorConfig config = new StatsCollectorConfig(tableConfig, keySchema, null);
        switch (type) {
            case INTEGER: {
                return new IntColumnPreIndexStatsCollector(key, config);
            }
            case LONG: {
                return new LongColumnPreIndexStatsCollector(key, config);
            }
            case FLOAT: {
                return new FloatColumnPreIndexStatsCollector(key, config);
            }
            case DOUBLE: {
                return new DoubleColumnPreIndexStatsCollector(key, config);
            }
            case BIG_DECIMAL: {
                return new BigDecimalColumnPreIndexStatsCollector(key, config);
            }
            case STRING: {
                return new StringColumnPreIndexStatsCollector(key, config);
            }
        }
        throw new UnsupportedOperationException(String.format("MAP column does not yet support '%s'", type));
    }

    static FieldSpec.DataType convertToDataType(PinotDataType ty) {
        switch (ty) {
            case BOOLEAN: {
                return FieldSpec.DataType.BOOLEAN;
            }
            case INTEGER: 
            case SHORT: {
                return FieldSpec.DataType.INT;
            }
            case LONG: {
                return FieldSpec.DataType.LONG;
            }
            case FLOAT: {
                return FieldSpec.DataType.FLOAT;
            }
            case DOUBLE: {
                return FieldSpec.DataType.DOUBLE;
            }
            case BIG_DECIMAL: {
                return FieldSpec.DataType.BIG_DECIMAL;
            }
            case TIMESTAMP: {
                return FieldSpec.DataType.TIMESTAMP;
            }
            case STRING: {
                return FieldSpec.DataType.STRING;
            }
        }
        throw new UnsupportedOperationException();
    }
}

