/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.dictionary;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.io.util.PinotDataBitSet;
import org.apache.pinot.segment.local.realtime.impl.dictionary.MutableDictionaryFactory;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentDictionaryCreator;
import org.apache.pinot.segment.local.segment.index.dictionary.DictionaryInternerHolder;
import org.apache.pinot.segment.local.segment.index.readers.BigDecimalDictionary;
import org.apache.pinot.segment.local.segment.index.readers.BytesDictionary;
import org.apache.pinot.segment.local.segment.index.readers.DoubleDictionary;
import org.apache.pinot.segment.local.segment.index.readers.FloatDictionary;
import org.apache.pinot.segment.local.segment.index.readers.IntDictionary;
import org.apache.pinot.segment.local.segment.index.readers.LongDictionary;
import org.apache.pinot.segment.local.segment.index.readers.OnHeapBigDecimalDictionary;
import org.apache.pinot.segment.local.segment.index.readers.OnHeapBytesDictionary;
import org.apache.pinot.segment.local.segment.index.readers.OnHeapDoubleDictionary;
import org.apache.pinot.segment.local.segment.index.readers.OnHeapFloatDictionary;
import org.apache.pinot.segment.local.segment.index.readers.OnHeapIntDictionary;
import org.apache.pinot.segment.local.segment.index.readers.OnHeapLongDictionary;
import org.apache.pinot.segment.local.segment.index.readers.OnHeapStringDictionary;
import org.apache.pinot.segment.local.segment.index.readers.StringDictionary;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.creator.ColumnStatistics;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.index.AbstractIndexType;
import org.apache.pinot.segment.spi.index.ColumnConfigDeserializer;
import org.apache.pinot.segment.spi.index.DictionaryIndexConfig;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.IndexConfigDeserializer;
import org.apache.pinot.segment.spi.index.IndexHandler;
import org.apache.pinot.segment.spi.index.IndexReaderConstraintException;
import org.apache.pinot.segment.spi.index.IndexReaderFactory;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.IndexUtil;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.TextIndexConfig;
import org.apache.pinot.segment.spi.index.mutable.MutableDictionary;
import org.apache.pinot.segment.spi.index.mutable.provider.MutableIndexContext;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.config.table.IndexingConfig;
import org.apache.pinot.spi.config.table.Intern;
import org.apache.pinot.spi.config.table.JsonIndexConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.FALFInterner;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryIndexType
extends AbstractIndexType<DictionaryIndexConfig, Dictionary, SegmentDictionaryCreator> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DictionaryIndexType.class);
    private static final List<String> EXTENSIONS = Collections.singletonList(".dict");

    protected DictionaryIndexType() {
        super("dictionary");
    }

    public Class<DictionaryIndexConfig> getIndexConfigClass() {
        return DictionaryIndexConfig.class;
    }

    public DictionaryIndexConfig getDefaultConfig() {
        return DictionaryIndexConfig.DEFAULT;
    }

    public String getPrettyName() {
        return this.getId();
    }

    public ColumnConfigDeserializer<DictionaryIndexConfig> createDeserializer() {
        ColumnConfigDeserializer fromIndexes = IndexConfigDeserializer.fromIndexes((String)this.getPrettyName(), this.getIndexConfigClass());
        ColumnConfigDeserializer fromNoDictionaryConfigs = IndexConfigDeserializer.fromMap(tableConfig -> tableConfig.getIndexingConfig().getNoDictionaryConfig(), (accum, column, value) -> accum.put(column, DictionaryIndexConfig.DISABLED));
        ColumnConfigDeserializer fromNoDictionaryColumns = IndexConfigDeserializer.fromCollection(tableConfig -> tableConfig.getIndexingConfig().getNoDictionaryColumns(), (accum, column) -> accum.put(column, DictionaryIndexConfig.DISABLED));
        ColumnConfigDeserializer fromFieldConfigs = IndexConfigDeserializer.fromCollection(TableConfig::getFieldConfigList, (accum, fieldConfig) -> {
            if (fieldConfig.getEncodingType() == FieldConfig.EncodingType.RAW) {
                accum.put(fieldConfig.getName(), DictionaryIndexConfig.DISABLED);
            }
        });
        ColumnConfigDeserializer fromIndexingConfig = (tableConfig, schema) -> {
            IndexingConfig indexingConfig = tableConfig.getIndexingConfig();
            HashSet onHeapDictionaryColumns = indexingConfig.getOnHeapDictionaryColumns() != null ? new HashSet(indexingConfig.getOnHeapDictionaryColumns()) : Set.of();
            HashSet varLengthDictionaryColumns = indexingConfig.getVarLengthDictionaryColumns() != null ? new HashSet(indexingConfig.getVarLengthDictionaryColumns()) : Set.of();
            HashSet allColumns = new HashSet();
            allColumns.addAll(onHeapDictionaryColumns);
            allColumns.addAll(varLengthDictionaryColumns);
            HashMap dictionaryIndexConfigMap = Maps.newHashMapWithExpectedSize((int)allColumns.size());
            for (String column : allColumns) {
                dictionaryIndexConfigMap.put(column, new DictionaryIndexConfig(Boolean.valueOf(onHeapDictionaryColumns.contains(column)), Boolean.valueOf(varLengthDictionaryColumns.contains(column))));
            }
            return dictionaryIndexConfigMap;
        };
        return fromIndexes.withExclusiveAlternative(fromNoDictionaryConfigs.withFallbackAlternative(fromNoDictionaryColumns).withFallbackAlternative(fromFieldConfigs).withFallbackAlternative(fromIndexingConfig));
    }

    public SegmentDictionaryCreator createIndexCreator(IndexCreationContext context, DictionaryIndexConfig indexConfig) {
        boolean useVarLengthDictionary = this.shouldUseVarLengthDictionary(context, indexConfig);
        return new SegmentDictionaryCreator(context.getFieldSpec(), context.getIndexDir(), useVarLengthDictionary);
    }

    public boolean shouldUseVarLengthDictionary(IndexCreationContext context, DictionaryIndexConfig indexConfig) {
        if (indexConfig.getUseVarLengthDictionary()) {
            return true;
        }
        FieldSpec.DataType storedType = context.getFieldSpec().getDataType().getStoredType();
        if (storedType != FieldSpec.DataType.BYTES && storedType != FieldSpec.DataType.BIG_DECIMAL) {
            return false;
        }
        return !context.isFixedLength();
    }

    public static boolean shouldUseVarLengthDictionary(String columnName, Set<String> varLengthDictColumns, FieldSpec.DataType columnStoredType, ColumnStatistics columnProfile) {
        if (varLengthDictColumns.contains(columnName)) {
            return true;
        }
        return DictionaryIndexType.shouldUseVarLengthDictionary(columnStoredType, columnProfile);
    }

    public static boolean shouldUseVarLengthDictionary(FieldSpec.DataType columnStoredType, ColumnStatistics profile) {
        if (columnStoredType == FieldSpec.DataType.BYTES || columnStoredType == FieldSpec.DataType.BIG_DECIMAL) {
            return !profile.isFixedLength();
        }
        return false;
    }

    public static boolean optimizeTypeShouldUseVarLengthDictionary(FieldSpec.DataType columnStoredType, ColumnStatistics profile) {
        if (columnStoredType == FieldSpec.DataType.BYTES || columnStoredType == FieldSpec.DataType.BIG_DECIMAL || columnStoredType == FieldSpec.DataType.STRING) {
            return !profile.isFixedLength();
        }
        return false;
    }

    public static boolean ignoreDictionaryOverride(boolean optimizeDictionary, boolean optimizeDictionaryForMetrics, double noDictionarySizeRatioThreshold, @Nullable Double noDictionaryCardinalityRatioThreshold, FieldSpec fieldSpec, FieldIndexConfigs fieldIndexConfigs, int cardinality, int totalNumberOfEntries) {
        if (fieldIndexConfigs.getConfig(StandardIndexes.inverted()).isEnabled()) {
            return true;
        }
        if (optimizeDictionary) {
            if (((JsonIndexConfig)fieldIndexConfigs.getConfig(StandardIndexes.json())).isEnabled() || ((TextIndexConfig)fieldIndexConfigs.getConfig(StandardIndexes.text())).isEnabled()) {
                return false;
            }
            if (fieldSpec.isSingleValueField()) {
                return DictionaryIndexType.ignoreDictionaryOverrideForSingleValueFields(cardinality, totalNumberOfEntries, noDictionarySizeRatioThreshold, noDictionaryCardinalityRatioThreshold, fieldSpec);
            }
        }
        if (optimizeDictionaryForMetrics && !optimizeDictionary && fieldSpec.isSingleValueField() && fieldSpec.getFieldType() == FieldSpec.FieldType.METRIC) {
            return DictionaryIndexType.ignoreDictionaryOverrideForSingleValueFields(cardinality, totalNumberOfEntries, noDictionarySizeRatioThreshold, noDictionaryCardinalityRatioThreshold, fieldSpec);
        }
        return true;
    }

    private static boolean ignoreDictionaryOverrideForSingleValueFields(int cardinality, int totalNumberOfEntries, double noDictionarySizeRatioThreshold, Double noDictionaryCardinalityRatioThreshold, FieldSpec fieldSpec) {
        if (fieldSpec.isSingleValueField()) {
            if (fieldSpec.getDataType().isFixedWidth()) {
                return DictionaryIndexType.canSafelyCreateDictionaryWithinThreshold(cardinality, totalNumberOfEntries, noDictionarySizeRatioThreshold, fieldSpec);
            }
            if (noDictionaryCardinalityRatioThreshold == null) {
                return true;
            }
            return noDictionaryCardinalityRatioThreshold * (double)totalNumberOfEntries > (double)cardinality;
        }
        return false;
    }

    private static boolean canSafelyCreateDictionaryWithinThreshold(int cardinality, int totalNumberOfEntries, double noDictionarySizeRatioThreshold, FieldSpec spec) {
        long dictionarySize = (long)cardinality * (long)spec.getDataType().size();
        long forwardIndexSize = ((long)totalNumberOfEntries * (long)PinotDataBitSet.getNumBitsPerValue(cardinality - 1) + 8L - 1L) / 8L;
        double indexWithDictSize = dictionarySize + forwardIndexSize;
        double indexWithoutDictSize = totalNumberOfEntries * spec.getDataType().size();
        double indexSizeRatio = indexWithoutDictSize / indexWithDictSize;
        return !(indexSizeRatio <= noDictionarySizeRatioThreshold);
    }

    public SegmentDictionaryCreator createIndexCreator(FieldSpec fieldSpec, File indexDir, boolean useVarLengthDictionary) throws Exception {
        return new SegmentDictionaryCreator(fieldSpec, indexDir, useVarLengthDictionary);
    }

    public static Dictionary read(SegmentDirectory.Reader segmentReader, ColumnMetadata columnMetadata) throws IOException {
        PinotDataBuffer dataBuffer = segmentReader.getIndexFor(columnMetadata.getColumnName(), StandardIndexes.dictionary());
        return DictionaryIndexType.read(dataBuffer, columnMetadata, DictionaryIndexConfig.DEFAULT);
    }

    public static Dictionary read(PinotDataBuffer dataBuffer, ColumnMetadata metadata, DictionaryIndexConfig indexConfig) throws IOException {
        return DictionaryIndexType.read(dataBuffer, metadata, indexConfig, null);
    }

    public static Dictionary read(PinotDataBuffer dataBuffer, ColumnMetadata metadata, DictionaryIndexConfig indexConfig, String internIdentifierStr) throws IOException {
        FieldSpec.DataType dataType = metadata.getDataType();
        boolean loadOnHeap = indexConfig.isOnHeap();
        String columnName = metadata.getColumnName();
        FALFInterner<String> strInterner = null;
        FALFInterner<byte[]> byteInterner = null;
        Intern internConfig = indexConfig.getIntern();
        if (loadOnHeap) {
            LOGGER.info("Loading on-heap dictionary for column: {}", (Object)columnName);
            if (internConfig != null && !internConfig.isDisabled()) {
                DictionaryInternerHolder internerHolder = DictionaryInternerHolder.getInstance();
                strInterner = internerHolder.getStrInterner(internIdentifierStr, internConfig.getCapacity());
                byteInterner = internerHolder.getByteInterner(internIdentifierStr, internConfig.getCapacity());
                LOGGER.info("Enabling interning for dictionary column: {}", (Object)columnName);
            }
        }
        int length = metadata.getCardinality();
        switch (dataType.getStoredType()) {
            case INT: {
                return loadOnHeap ? new OnHeapIntDictionary(dataBuffer, length) : new IntDictionary(dataBuffer, length);
            }
            case LONG: {
                return loadOnHeap ? new OnHeapLongDictionary(dataBuffer, length) : new LongDictionary(dataBuffer, length);
            }
            case FLOAT: {
                return loadOnHeap ? new OnHeapFloatDictionary(dataBuffer, length) : new FloatDictionary(dataBuffer, length);
            }
            case DOUBLE: {
                return loadOnHeap ? new OnHeapDoubleDictionary(dataBuffer, length) : new DoubleDictionary(dataBuffer, length);
            }
            case BIG_DECIMAL: {
                int numBytesPerValue = metadata.getColumnMaxLength();
                return loadOnHeap ? new OnHeapBigDecimalDictionary(dataBuffer, length, numBytesPerValue) : new BigDecimalDictionary(dataBuffer, length, numBytesPerValue);
            }
            case STRING: {
                int numBytesPerValue = metadata.getColumnMaxLength();
                return loadOnHeap ? new OnHeapStringDictionary(dataBuffer, length, numBytesPerValue, strInterner, byteInterner) : new StringDictionary(dataBuffer, length, numBytesPerValue);
            }
            case BYTES: {
                int numBytesPerValue = metadata.getColumnMaxLength();
                return loadOnHeap ? new OnHeapBytesDictionary(dataBuffer, length, numBytesPerValue, byteInterner) : new BytesDictionary(dataBuffer, length, numBytesPerValue);
            }
        }
        throw new IllegalStateException("Unsupported data type for dictionary: " + dataType);
    }

    protected IndexReaderFactory<Dictionary> createReaderFactory() {
        return ReaderFactory.INSTANCE;
    }

    public IndexHandler createIndexHandler(SegmentDirectory segmentDirectory, Map<String, FieldIndexConfigs> configsByCol, @Nullable Schema schema, @Nullable TableConfig tableConfig) {
        return IndexHandler.NoOp.INSTANCE;
    }

    public static String getFileExtension() {
        return ".dict";
    }

    public List<String> getFileExtensions(@Nullable ColumnMetadata columnMetadata) {
        return EXTENSIONS;
    }

    protected void handleIndexSpecificCleanup(TableConfig tableConfig) {
        FieldConfig.Builder builder;
        IndexingConfig indexingConfig = tableConfig.getIndexingConfig();
        List noDictionaryColumns = indexingConfig.getNoDictionaryColumns() == null ? Lists.newArrayList() : indexingConfig.getNoDictionaryColumns();
        List<FieldConfig> fieldConfigList = tableConfig.getFieldConfigList() == null ? Lists.newArrayList() : tableConfig.getFieldConfigList();
        ArrayList<FieldConfig> configsToUpdate = new ArrayList<FieldConfig>();
        for (FieldConfig fieldConfig : fieldConfigList) {
            if (fieldConfig.getEncodingType() == FieldConfig.EncodingType.RAW) continue;
            if (noDictionaryColumns.remove(fieldConfig.getName())) {
                configsToUpdate.add(fieldConfig);
            }
            if (fieldConfig.getIndexes() == null || fieldConfig.getIndexes().get(this.getPrettyName()) == null) continue;
            try {
                DictionaryIndexConfig indexConfig = (DictionaryIndexConfig)JsonUtils.jsonNodeToObject((JsonNode)fieldConfig.getIndexes().get(this.getPrettyName()), DictionaryIndexConfig.class);
                if (!indexConfig.isDisabled()) continue;
                configsToUpdate.add(fieldConfig);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        for (FieldConfig fieldConfig : configsToUpdate) {
            builder = new FieldConfig.Builder(fieldConfig);
            builder.withEncodingType(FieldConfig.EncodingType.RAW);
            fieldConfigList.remove(fieldConfig);
            fieldConfigList.add(builder.build());
        }
        for (String column : noDictionaryColumns) {
            builder = new FieldConfig.Builder(column);
            builder.withEncodingType(FieldConfig.EncodingType.RAW);
            fieldConfigList.add(builder.build());
        }
        indexingConfig.setNoDictionaryConfig(null);
        indexingConfig.setNoDictionaryColumns(null);
        indexingConfig.setOnHeapDictionaryColumns(null);
        indexingConfig.setVarLengthDictionaryColumns(null);
    }

    @Nullable
    public static MutableDictionary createMutableDictionary(MutableIndexContext context, DictionaryIndexConfig config) {
        if (config.isDisabled()) {
            return null;
        }
        String column = context.getFieldSpec().getName();
        String segmentName = context.getSegmentName();
        FieldSpec.DataType storedType = context.getFieldSpec().getDataType().getStoredType();
        int dictionaryColumnSize = storedType.isFixedWidth() ? storedType.size() : context.getEstimatedColSize();
        int estimatedCardinality = (int)((double)context.getEstimatedCardinality() * 1.21);
        String dictionaryAllocationContext = IndexUtil.buildAllocationContext((String)segmentName, (String)column, (String)".dict");
        return MutableDictionaryFactory.getMutableDictionary(storedType, context.isOffHeap(), context.getMemoryManager(), dictionaryColumnSize, Math.min(estimatedCardinality, context.getCapacity()), dictionaryAllocationContext);
    }

    public IndexType.BuildLifecycle getIndexBuildLifecycle() {
        return IndexType.BuildLifecycle.CUSTOM;
    }

    private static class ReaderFactory
    extends IndexReaderFactory.Default<DictionaryIndexConfig, Dictionary> {
        public static final ReaderFactory INSTANCE = new ReaderFactory();

        private ReaderFactory() {
        }

        protected IndexType<DictionaryIndexConfig, Dictionary, ?> getIndexType() {
            return StandardIndexes.dictionary();
        }

        protected Dictionary createIndexReader(PinotDataBuffer dataBuffer, ColumnMetadata metadata, DictionaryIndexConfig indexConfig) throws IOException, IndexReaderConstraintException {
            return DictionaryIndexType.read(dataBuffer, metadata, indexConfig);
        }

        public Dictionary createIndexReader(SegmentDirectory.Reader segmentReader, FieldIndexConfigs fieldIndexConfigs, ColumnMetadata metadata) throws IOException, IndexReaderConstraintException {
            String colName = metadata.getColumnName();
            if (!segmentReader.hasIndexFor(colName, StandardIndexes.dictionary())) {
                return null;
            }
            PinotDataBuffer buffer = segmentReader.getIndexFor(colName, StandardIndexes.dictionary());
            DictionaryIndexConfig config = (DictionaryIndexConfig)fieldIndexConfigs.getConfig(StandardIndexes.dictionary());
            String tableName = segmentReader.toSegmentDirectory().getSegmentMetadata().getTableName();
            String internIdentifierStr = DictionaryInternerHolder.getInstance().createIdentifier(tableName, colName);
            try {
                return DictionaryIndexType.read(buffer, metadata, config, internIdentifierStr);
            }
            catch (RuntimeException ex) {
                throw new RuntimeException("Cannot read index " + StandardIndexes.dictionary() + " for column " + colName, ex);
            }
        }
    }
}

