/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.json;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.realtime.impl.json.MutableJsonIndexImpl;
import org.apache.pinot.segment.local.segment.creator.impl.inv.json.OffHeapJsonIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.inv.json.OnHeapJsonIndexCreator;
import org.apache.pinot.segment.local.segment.index.loader.invertedindex.JsonIndexHandler;
import org.apache.pinot.segment.local.segment.index.readers.json.ImmutableJsonIndexReader;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.index.AbstractIndexType;
import org.apache.pinot.segment.spi.index.ColumnConfigDeserializer;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.IndexConfigDeserializer;
import org.apache.pinot.segment.spi.index.IndexHandler;
import org.apache.pinot.segment.spi.index.IndexReaderConstraintException;
import org.apache.pinot.segment.spi.index.IndexReaderFactory;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.creator.JsonIndexCreator;
import org.apache.pinot.segment.spi.index.mutable.MutableIndex;
import org.apache.pinot.segment.spi.index.mutable.provider.MutableIndexContext;
import org.apache.pinot.segment.spi.index.reader.JsonIndexReader;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.config.table.JsonIndexConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;

public class JsonIndexType
extends AbstractIndexType<JsonIndexConfig, JsonIndexReader, JsonIndexCreator> {
    public static final String INDEX_DISPLAY_NAME = "json";
    private static final List<String> EXTENSIONS = Collections.singletonList(".json.idx");

    protected JsonIndexType() {
        super("json_index");
    }

    public Class<JsonIndexConfig> getIndexConfigClass() {
        return JsonIndexConfig.class;
    }

    public JsonIndexConfig getDefaultConfig() {
        return JsonIndexConfig.DISABLED;
    }

    public String getPrettyName() {
        return INDEX_DISPLAY_NAME;
    }

    public ColumnConfigDeserializer<JsonIndexConfig> createDeserializer() {
        ColumnConfigDeserializer fromIndexes = IndexConfigDeserializer.fromIndexes((String)this.getPrettyName(), this.getIndexConfigClass());
        ColumnConfigDeserializer fromJsonIndexConfigs = IndexConfigDeserializer.fromMap(tableConfig -> tableConfig.getIndexingConfig().getJsonIndexConfigs());
        ColumnConfigDeserializer fromJsonIndexColumns = IndexConfigDeserializer.fromCollection(tableConfig -> tableConfig.getIndexingConfig().getJsonIndexColumns(), (accum, column) -> accum.put(column, JsonIndexConfig.DEFAULT));
        return fromIndexes.withExclusiveAlternative(fromJsonIndexConfigs.withFallbackAlternative(fromJsonIndexColumns));
    }

    public JsonIndexCreator createIndexCreator(IndexCreationContext context, JsonIndexConfig indexConfig) throws IOException {
        Preconditions.checkState((boolean)context.getFieldSpec().isSingleValueField(), (Object)"Json index is currently only supported on single-value columns");
        Preconditions.checkState((context.getFieldSpec().getDataType().getStoredType() == FieldSpec.DataType.STRING ? 1 : 0) != 0, (Object)"Json index is currently only supported on STRING columns");
        return context.isOnHeap() ? new OnHeapJsonIndexCreator(context.getIndexDir(), context.getFieldSpec().getName(), indexConfig) : new OffHeapJsonIndexCreator(context.getIndexDir(), context.getFieldSpec().getName(), indexConfig);
    }

    protected IndexReaderFactory<JsonIndexReader> createReaderFactory() {
        return ReaderFactory.INSTANCE;
    }

    public static JsonIndexReader read(PinotDataBuffer dataBuffer, ColumnMetadata columnMetadata) throws IndexReaderConstraintException {
        return ReaderFactory.createIndexReader(dataBuffer, columnMetadata);
    }

    public List<String> getFileExtensions(@Nullable ColumnMetadata columnMetadata) {
        return EXTENSIONS;
    }

    public IndexHandler createIndexHandler(SegmentDirectory segmentDirectory, Map<String, FieldIndexConfigs> configsByCol, @Nullable Schema schema, @Nullable TableConfig tableConfig) {
        return new JsonIndexHandler(segmentDirectory, configsByCol, tableConfig);
    }

    protected void handleIndexSpecificCleanup(TableConfig tableConfig) {
        tableConfig.getIndexingConfig().setJsonIndexColumns(null);
        tableConfig.getIndexingConfig().setJsonIndexConfigs(null);
    }

    @Nullable
    public MutableIndex createMutableIndex(MutableIndexContext context, JsonIndexConfig config) {
        if (config.isDisabled()) {
            return null;
        }
        if (!context.getFieldSpec().isSingleValueField()) {
            return null;
        }
        return new MutableJsonIndexImpl(config);
    }

    private static class ReaderFactory
    extends IndexReaderFactory.Default<JsonIndexConfig, JsonIndexReader> {
        public static final ReaderFactory INSTANCE = new ReaderFactory();

        private ReaderFactory() {
        }

        protected IndexType<JsonIndexConfig, JsonIndexReader, ?> getIndexType() {
            return StandardIndexes.json();
        }

        protected JsonIndexReader createIndexReader(PinotDataBuffer dataBuffer, ColumnMetadata metadata, JsonIndexConfig indexConfig) throws IndexReaderConstraintException {
            return ReaderFactory.createIndexReader(dataBuffer, metadata);
        }

        public static JsonIndexReader createIndexReader(PinotDataBuffer dataBuffer, ColumnMetadata metadata) throws IndexReaderConstraintException {
            if (!metadata.getFieldSpec().isSingleValueField()) {
                throw new IndexReaderConstraintException(metadata.getColumnName(), StandardIndexes.json(), "Json index is currently only supported on single-value columns");
            }
            if (metadata.getFieldSpec().getDataType().getStoredType() != FieldSpec.DataType.STRING) {
                throw new IndexReaderConstraintException(metadata.getColumnName(), StandardIndexes.json(), "Json index is currently only supported on STRING columns");
            }
            return new ImmutableJsonIndexReader(dataBuffer, metadata.getTotalDocs());
        }
    }
}

