/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.nullvalue;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.segment.creator.impl.nullvalue.NullValueVectorCreator;
import org.apache.pinot.segment.local.segment.index.readers.NullValueVectorReaderImpl;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.index.AbstractIndexType;
import org.apache.pinot.segment.spi.index.ColumnConfigDeserializer;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.IndexHandler;
import org.apache.pinot.segment.spi.index.IndexReaderFactory;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.reader.NullValueVectorReader;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.config.table.IndexConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;

public class NullValueIndexType
extends AbstractIndexType<IndexConfig, NullValueVectorReader, NullValueVectorCreator> {
    public static final String INDEX_DISPLAY_NAME = "null";
    private static final List<String> EXTENSIONS = Collections.singletonList(".bitmap.nullvalue");

    protected NullValueIndexType() {
        super("nullvalue_vector");
    }

    public Class<IndexConfig> getIndexConfigClass() {
        return IndexConfig.class;
    }

    public NullValueVectorCreator createIndexCreator(IndexCreationContext context, IndexConfig indexConfig) throws Exception {
        return new NullValueVectorCreator(context.getIndexDir(), context.getFieldSpec().getName());
    }

    public IndexConfig getDefaultConfig() {
        return IndexConfig.ENABLED;
    }

    public String getPrettyName() {
        return INDEX_DISPLAY_NAME;
    }

    public ColumnConfigDeserializer<IndexConfig> createDeserializer() {
        return (tableConfig, schema) -> {
            Collection allFieldSpecs = schema.getAllFieldSpecs();
            HashMap configMap = Maps.newHashMapWithExpectedSize((int)allFieldSpecs.size());
            boolean enableColumnBasedNullHandling = schema.isEnableColumnBasedNullHandling();
            boolean nullHandlingEnabled = tableConfig.getIndexingConfig() != null && tableConfig.getIndexingConfig().isNullHandlingEnabled();
            for (FieldSpec fieldSpec : allFieldSpecs) {
                boolean enabled = enableColumnBasedNullHandling ? fieldSpec.isNullable() : nullHandlingEnabled;
                IndexConfig indexConfig = enabled ? IndexConfig.ENABLED : IndexConfig.DISABLED;
                configMap.put(fieldSpec.getName(), indexConfig);
            }
            return configMap;
        };
    }

    public NullValueVectorCreator createIndexCreator(File indexDir, String columnName) {
        return new NullValueVectorCreator(indexDir, columnName);
    }

    protected IndexReaderFactory<NullValueVectorReader> createReaderFactory() {
        return ReaderFactory.INSTANCE;
    }

    public IndexHandler createIndexHandler(SegmentDirectory segmentDirectory, Map<String, FieldIndexConfigs> configsByCol, @Nullable Schema schema, @Nullable TableConfig tableConfig) {
        return IndexHandler.NoOp.INSTANCE;
    }

    public List<String> getFileExtensions(@Nullable ColumnMetadata columnMetadata) {
        return EXTENSIONS;
    }

    public void convertToNewFormat(TableConfig tableConfig, Schema schema) {
    }

    public IndexType.BuildLifecycle getIndexBuildLifecycle() {
        return IndexType.BuildLifecycle.CUSTOM;
    }

    private static class ReaderFactory
    implements IndexReaderFactory<NullValueVectorReader> {
        public static final ReaderFactory INSTANCE = new ReaderFactory();

        private ReaderFactory() {
        }

        @Nullable
        public NullValueVectorReader createIndexReader(SegmentDirectory.Reader segmentReader, FieldIndexConfigs fieldIndexConfigs, ColumnMetadata metadata) throws IOException {
            IndexType indexType = StandardIndexes.nullValueVector();
            if (fieldIndexConfigs.getConfig(indexType).isDisabled()) {
                return null;
            }
            if (!segmentReader.hasIndexFor(metadata.getColumnName(), indexType)) {
                return null;
            }
            PinotDataBuffer buffer = segmentReader.getIndexFor(metadata.getColumnName(), indexType);
            return new NullValueVectorReaderImpl(buffer);
        }
    }
}

