/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.pinot.segment.local.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;

public class OnHeapIntDictionary
extends BaseImmutableDictionary {
    private final Int2IntOpenHashMap _valToDictId;
    private final int[] _dictIdToVal;

    public OnHeapIntDictionary(PinotDataBuffer dataBuffer, int length) {
        super(dataBuffer, length, 4);
        this._valToDictId = new Int2IntOpenHashMap(length);
        this._valToDictId.defaultReturnValue(-1);
        this._dictIdToVal = new int[length];
        for (int dictId = 0; dictId < length; ++dictId) {
            int value;
            this._dictIdToVal[dictId] = value = this.getInt(dictId);
            this._valToDictId.put(value, dictId);
        }
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.INT;
    }

    @Override
    public int indexOf(String stringValue) {
        return this._valToDictId.get(Integer.parseInt(stringValue));
    }

    public int indexOf(int intValue) {
        return this._valToDictId.get(intValue);
    }

    public int insertionIndexOf(String stringValue) {
        int intValue = Integer.parseInt(stringValue);
        int index = this._valToDictId.get(intValue);
        return index != -1 ? index : Arrays.binarySearch(this._dictIdToVal, intValue);
    }

    public Integer get(int dictId) {
        return this._dictIdToVal[dictId];
    }

    public int getIntValue(int dictId) {
        return this._dictIdToVal[dictId];
    }

    public long getLongValue(int dictId) {
        return this._dictIdToVal[dictId];
    }

    public float getFloatValue(int dictId) {
        return this._dictIdToVal[dictId];
    }

    public double getDoubleValue(int dictId) {
        return this._dictIdToVal[dictId];
    }

    public BigDecimal getBigDecimalValue(int dictId) {
        return BigDecimal.valueOf(this._dictIdToVal[dictId]);
    }

    public String getStringValue(int dictId) {
        return Integer.toString(this._dictIdToVal[dictId]);
    }
}

