/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers.forward;

import com.yscope.clp.compressorfrontend.FlattenedByteArrayFactory;
import com.yscope.clp.compressorfrontend.MessageDecoder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.pinot.segment.local.io.util.PinotDataBitSet;
import org.apache.pinot.segment.local.io.util.VarLengthValueReader;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.CLPForwardIndexCreatorV2;
import org.apache.pinot.segment.local.segment.index.readers.forward.ChunkReaderContext;
import org.apache.pinot.segment.local.segment.index.readers.forward.FixedBytePower2ChunkSVForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.VarByteChunkForwardIndexReaderV4;
import org.apache.pinot.segment.local.segment.index.readers.forward.VarByteChunkForwardIndexReaderV5;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;

public class CLPForwardIndexReaderV2
implements ForwardIndexReader<CLPReaderContext> {
    private final int _version;
    private final int _numDocs;
    private final boolean _isClpEncoded;
    private VarLengthValueReader _logTypeDictReader;
    private VarLengthValueReader _dictVarDictReader;
    private int _logtypeDictNumBytesPerValue;
    private int _dictVarDictNumBytesPerValue;
    private FixedBytePower2ChunkSVForwardIndexReader _logTypeIdFwdIndexReader;
    private VarByteChunkForwardIndexReaderV5 _dictVarIdFwdIndexReader;
    private VarByteChunkForwardIndexReaderV5 _encodedVarFwdIndexReader;
    private VarByteChunkForwardIndexReaderV5 _rawMsgFwdIndexReader;
    private MessageDecoder _clpMessageDecoder;

    public CLPForwardIndexReaderV2(PinotDataBuffer pinotDataBuffer, int numDocs) {
        this._numDocs = numDocs;
        int offset = 0;
        int magicBytesLength = pinotDataBuffer.getInt(offset);
        byte[] magicBytes = new byte[magicBytesLength];
        pinotDataBuffer.copyTo((long)(offset += 4), magicBytes);
        if (!Arrays.equals(magicBytes, CLPForwardIndexCreatorV2.MAGIC_BYTES)) {
            throw new UnsupportedOperationException("Unsupported magic bytes");
        }
        this._version = pinotDataBuffer.getInt(offset += CLPForwardIndexCreatorV2.MAGIC_BYTES.length);
        this._isClpEncoded = pinotDataBuffer.getInt(offset += 4) == 1;
        offset += 4;
        if (this._isClpEncoded) {
            int logtypeDictSize = pinotDataBuffer.getInt(offset);
            this._logtypeDictNumBytesPerValue = PinotDataBitSet.getNumBitsPerValue(logtypeDictSize - 1);
            int dictVarDictSize = pinotDataBuffer.getInt(offset += 4);
            this._dictVarDictNumBytesPerValue = PinotDataBitSet.getNumBitsPerValue(dictVarDictSize - 1);
            int logtypeDictLength = pinotDataBuffer.getInt(offset += 4);
            int dictVarDictLength = pinotDataBuffer.getInt(offset += 4);
            int logtypeIdFwdIndexLength = pinotDataBuffer.getInt(offset += 4);
            int dictVarIdFwdIndexLength = pinotDataBuffer.getInt(offset += 4);
            int encodedVarFwdIndexLength = pinotDataBuffer.getInt(offset += 4);
            this._logTypeDictReader = new VarLengthValueReader(pinotDataBuffer.view((long)(offset += 4), (long)(offset + logtypeDictLength)));
            this._dictVarDictReader = new VarLengthValueReader(pinotDataBuffer.view((long)(offset += logtypeDictLength), (long)(offset + dictVarDictLength)));
            this._logTypeIdFwdIndexReader = new FixedBytePower2ChunkSVForwardIndexReader(pinotDataBuffer.view((long)(offset += dictVarDictLength), (long)(offset + logtypeIdFwdIndexLength)), FieldSpec.DataType.INT);
            this._dictVarIdFwdIndexReader = new VarByteChunkForwardIndexReaderV5(pinotDataBuffer.view((long)(offset += logtypeIdFwdIndexLength), (long)(offset + dictVarIdFwdIndexLength)), FieldSpec.DataType.INT, false);
            this._encodedVarFwdIndexReader = new VarByteChunkForwardIndexReaderV5(pinotDataBuffer.view((long)(offset += dictVarIdFwdIndexLength), (long)(offset + encodedVarFwdIndexLength)), FieldSpec.DataType.LONG, false);
            offset += encodedVarFwdIndexLength;
            this._clpMessageDecoder = new MessageDecoder("com.yscope.clp.VariablesSchemaV2", "com.yscope.clp.VariableEncodingMethodsV1");
        } else {
            int rawMsgFwdIndexLength = pinotDataBuffer.getInt(offset);
            this._rawMsgFwdIndexReader = new VarByteChunkForwardIndexReaderV5(pinotDataBuffer.view((long)(offset += 4), (long)(offset + rawMsgFwdIndexLength)), FieldSpec.DataType.BYTES, false);
            offset += rawMsgFwdIndexLength;
        }
    }

    public CLPReaderContext createContext() {
        if (this._isClpEncoded) {
            return new CLPReaderContext(this._logTypeIdFwdIndexReader.createContext(), this._dictVarIdFwdIndexReader.createContext(), this._encodedVarFwdIndexReader.createContext());
        }
        return new CLPReaderContext(this._rawMsgFwdIndexReader.createContext());
    }

    public boolean isDictionaryEncoded() {
        return false;
    }

    public boolean isSingleValue() {
        return true;
    }

    public FieldSpec.DataType getStoredType() {
        return FieldSpec.DataType.STRING;
    }

    public String getString(int docId, CLPReaderContext context) {
        if (this._isClpEncoded) {
            byte[] logtype = this._logTypeDictReader.getBytes(this._logTypeIdFwdIndexReader.getInt(docId, context._logTypeIdReaderContext), this._logtypeDictNumBytesPerValue);
            int[] dictVarIds = this._dictVarIdFwdIndexReader.getIntMV(docId, context._dictVarIdReaderContext);
            byte[][] dictVars = new byte[dictVarIds.length][];
            for (int i = 0; i < dictVars.length; ++i) {
                dictVars[i] = this._dictVarDictReader.getBytes(dictVarIds[i], this._dictVarDictNumBytesPerValue);
            }
            long[] encodedVars = this._encodedVarFwdIndexReader.getLongMV(docId, context._encodedVarReaderContext);
            try {
                return this._clpMessageDecoder.decodeMessage(logtype, FlattenedByteArrayFactory.fromByteArrays((byte[][])dictVars), encodedVars);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        byte[] rawMsg = this._rawMsgFwdIndexReader.getBytes(docId, context._rawMsgReaderContext);
        return new String(rawMsg, StandardCharsets.UTF_8);
    }

    public void close() throws IOException {
    }

    public static final class CLPReaderContext
    implements ForwardIndexReaderContext {
        private final ChunkReaderContext _logTypeIdReaderContext;
        private final VarByteChunkForwardIndexReaderV4.ReaderContext _dictVarIdReaderContext;
        private final VarByteChunkForwardIndexReaderV4.ReaderContext _encodedVarReaderContext;
        private final VarByteChunkForwardIndexReaderV4.ReaderContext _rawMsgReaderContext;

        public CLPReaderContext(ChunkReaderContext logTypeIdReaderContext, VarByteChunkForwardIndexReaderV4.ReaderContext dictVarIdReaderContext, VarByteChunkForwardIndexReaderV4.ReaderContext encodedVarReaderContext) {
            this(logTypeIdReaderContext, dictVarIdReaderContext, encodedVarReaderContext, null);
        }

        public CLPReaderContext(VarByteChunkForwardIndexReaderV4.ReaderContext rawMsgReaderContext) {
            this(null, null, null, rawMsgReaderContext);
        }

        public CLPReaderContext(ChunkReaderContext logTypeIdReaderContext, VarByteChunkForwardIndexReaderV4.ReaderContext dictVarIdReaderContext, VarByteChunkForwardIndexReaderV4.ReaderContext encodedVarReaderContext, VarByteChunkForwardIndexReaderV4.ReaderContext rawMsgReaderContext) {
            this._logTypeIdReaderContext = logTypeIdReaderContext;
            this._dictVarIdReaderContext = dictVarIdReaderContext;
            this._encodedVarReaderContext = encodedVarReaderContext;
            this._rawMsgReaderContext = rawMsgReaderContext;
        }

        public void close() throws IOException {
            if (null != this._logTypeIdReaderContext) {
                this._logTypeIdReaderContext.close();
            }
            if (null != this._dictVarIdReaderContext) {
                this._dictVarIdReaderContext.close();
            }
            if (null != this._encodedVarReaderContext) {
                this._encodedVarReaderContext.close();
            }
            if (null != this._rawMsgReaderContext) {
                this._rawMsgReaderContext.close();
            }
        }
    }
}

