/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers.forward;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.pinot.segment.local.io.util.FixedBitIntReaderWriter;
import org.apache.pinot.segment.local.io.util.PinotDataBitSet;
import org.apache.pinot.segment.spi.compression.DictIdCompressionType;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;

public final class FixedBitMVEntryDictForwardIndexReader
implements ForwardIndexReader<ForwardIndexReaderContext> {
    public static final int MAGIC_MARKER = -5517841;
    public static final short VERSION = 1;
    private static final int HEADER_SIZE = 24;
    private final FixedBitIntReaderWriter _idReader;
    private final int _offsetBufferOffset;
    private final FixedBitIntReaderWriter _offsetReader;
    private final int _valueBufferOffset;
    private final FixedBitIntReaderWriter _valueReader;

    public FixedBitMVEntryDictForwardIndexReader(PinotDataBuffer dataBuffer, int numDocs, int numBitsPerValue) {
        int magicMarker = dataBuffer.getInt(0);
        Preconditions.checkState((magicMarker == -5517841 ? 1 : 0) != 0, (String)"Invalid magic marker: %s (expected: %s)", (int)magicMarker, (int)-5517841);
        short version = dataBuffer.getShort(4);
        Preconditions.checkState((version == 1 ? 1 : 0) != 0, (String)"Invalid version: %s (expected: %s)", (int)version, (int)1);
        byte numBitsPerValueInHeader = dataBuffer.getByte(6);
        Preconditions.checkState((numBitsPerValueInHeader == numBitsPerValue ? 1 : 0) != 0, (String)"Invalid numBitsPerValue: %s (expected: %s)", (int)numBitsPerValueInHeader, (int)numBitsPerValue);
        byte numBitsPerId = dataBuffer.getByte(7);
        int numUniqueEntries = dataBuffer.getInt(8);
        int numTotalValues = dataBuffer.getInt(12);
        this._offsetBufferOffset = dataBuffer.getInt(16);
        this._valueBufferOffset = dataBuffer.getInt(20);
        this._idReader = new FixedBitIntReaderWriter(dataBuffer.view(24L, (long)this._offsetBufferOffset), numDocs, numBitsPerId);
        this._offsetReader = new FixedBitIntReaderWriter(dataBuffer.view((long)this._offsetBufferOffset, (long)this._valueBufferOffset), numUniqueEntries + 1, PinotDataBitSet.getNumBitsPerValue(numTotalValues));
        this._valueReader = new FixedBitIntReaderWriter(dataBuffer.view((long)this._valueBufferOffset, dataBuffer.size()), numTotalValues, numBitsPerValue);
    }

    public boolean isDictionaryEncoded() {
        return true;
    }

    public boolean isSingleValue() {
        return false;
    }

    public FieldSpec.DataType getStoredType() {
        return FieldSpec.DataType.INT;
    }

    public DictIdCompressionType getDictIdCompressionType() {
        return DictIdCompressionType.MV_ENTRY_DICT;
    }

    public int getDictIdMV(int docId, int[] dictIdBuffer, ForwardIndexReaderContext context) {
        int id = this._idReader.readInt(docId);
        int startIndex = this._offsetReader.readInt(id);
        int numValues = this._offsetReader.readInt(id + 1) - startIndex;
        this._valueReader.readInt(startIndex, numValues, dictIdBuffer);
        return numValues;
    }

    public int[] getDictIdMV(int docId, ForwardIndexReaderContext context) {
        int id = this._idReader.readInt(docId);
        int startIndex = this._offsetReader.readInt(id);
        int numValues = this._offsetReader.readInt(id + 1) - startIndex;
        int[] dictIdBuffer = new int[numValues];
        this._valueReader.readInt(startIndex, numValues, dictIdBuffer);
        return dictIdBuffer;
    }

    public int getNumValuesMV(int docId, ForwardIndexReaderContext context) {
        int id = this._idReader.readInt(docId);
        return this._offsetReader.readInt(id + 1) - this._offsetReader.readInt(id);
    }

    public boolean isBufferByteRangeInfoSupported() {
        return true;
    }

    public void recordDocIdByteRanges(int docId, ForwardIndexReaderContext context, List<ForwardIndexReader.ByteRange> ranges) {
        int id = this._idReader.readInt(docId);
        int idReaderStartByteOffset = this._idReader.getStartByteOffset(docId);
        int idReaderEndByteOffset = this._idReader.getEndByteOffset(docId);
        ranges.add(new ForwardIndexReader.ByteRange((long)(24 + idReaderStartByteOffset), idReaderEndByteOffset - idReaderStartByteOffset));
        int startIndex = this._offsetReader.readInt(id);
        int numValues = this._offsetReader.readInt(id + 1) - startIndex;
        int offsetReaderStartByteOffset = this._offsetReader.getStartByteOffset(id);
        int offsetReaderEndByteOffset = this._offsetReader.getEndByteOffset(id + 1);
        ranges.add(new ForwardIndexReader.ByteRange((long)(this._offsetBufferOffset + offsetReaderStartByteOffset), offsetReaderEndByteOffset - offsetReaderStartByteOffset));
        int valueReaderStartByteOffset = this._valueReader.getStartByteOffset(startIndex);
        int valueReaderEndByteOffset = this._valueReader.getEndByteOffset(startIndex + numValues - 1);
        ranges.add(new ForwardIndexReader.ByteRange((long)(this._valueBufferOffset + valueReaderStartByteOffset), valueReaderEndByteOffset - valueReaderStartByteOffset));
    }

    public boolean isFixedOffsetMappingType() {
        return false;
    }

    public void close() {
        this._idReader.close();
        this._offsetReader.close();
        this._valueReader.close();
    }
}

