/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers.map;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.segment.index.readers.forward.VarByteChunkForwardIndexReaderV4;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.index.IndexReader;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.index.reader.MapIndexReader;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.partition.PartitionFunction;
import org.apache.pinot.spi.data.ComplexFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableMapIndexReader
implements MapIndexReader<ForwardIndexReaderContext, IndexReader> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmutableMapIndexReader.class);
    protected final PinotDataBuffer _dataBuffer;
    private final ForwardIndexReader _forwardIndexReader;
    private final FieldSpec _valueFieldSpec;
    private final ColumnMetadata _columnMetadata;

    public ImmutableMapIndexReader(PinotDataBuffer dataBuffer, ColumnMetadata columnMetadata) {
        int version = dataBuffer.getInt(0);
        Preconditions.checkState((version == 1 ? 1 : 0) != 0, (String)"Unsupported map index version: %s.  Valid versions are {}", (int)version, (int)1);
        this._dataBuffer = dataBuffer;
        this._columnMetadata = columnMetadata;
        this._forwardIndexReader = new VarByteChunkForwardIndexReaderV4(this._dataBuffer, FieldSpec.DataType.BYTES, true);
        ComplexFieldSpec complexFieldSpec = (ComplexFieldSpec)columnMetadata.getFieldSpec();
        Preconditions.checkState((complexFieldSpec.getChildFieldSpec("key").getDataType() == FieldSpec.DataType.STRING ? 1 : 0) != 0, (Object)"Only String key is supported in Map");
        this._valueFieldSpec = complexFieldSpec.getChildFieldSpec("value");
    }

    public void close() {
    }

    public IndexReader getKeyReader(String key, IndexType type) {
        throw new RuntimeException("Not implemented");
    }

    public Set<String> getKeys() {
        return Set.of();
    }

    public Map<IndexType, IndexReader> getKeyIndexes(String key) {
        IndexReader fwdIdx = this.getKeyReader(key, StandardIndexes.forward());
        if (fwdIdx != null) {
            return Map.of(StandardIndexes.forward(), this.getKeyReader(key, StandardIndexes.forward()));
        }
        return null;
    }

    public FieldSpec getKeyFieldSpec(String key) {
        return this._valueFieldSpec;
    }

    public FieldSpec.DataType getKeyStoredType(String key) {
        return this._valueFieldSpec.getDataType();
    }

    public ColumnMetadata getKeyMetadata(String key) {
        return new ColumnMetadata(){

            public FieldSpec getFieldSpec() {
                return ImmutableMapIndexReader.this._valueFieldSpec;
            }

            public int getTotalDocs() {
                return ImmutableMapIndexReader.this._columnMetadata.getTotalDocs();
            }

            public int getCardinality() {
                return 0;
            }

            public boolean isSorted() {
                return false;
            }

            public Comparable getMinValue() {
                return null;
            }

            public Comparable getMaxValue() {
                return null;
            }

            public boolean hasDictionary() {
                return false;
            }

            public int getColumnMaxLength() {
                return 0;
            }

            public int getBitsPerElement() {
                return 0;
            }

            public int getMaxNumberOfMultiValues() {
                return 0;
            }

            public int getTotalNumberOfEntries() {
                return 0;
            }

            @Nullable
            public PartitionFunction getPartitionFunction() {
                return null;
            }

            @Nullable
            public Set<Integer> getPartitions() {
                return null;
            }

            public Map<IndexType<?, ?, ?>, Long> getIndexSizeMap() {
                return Map.of();
            }

            public boolean isAutoGenerated() {
                return false;
            }
        };
    }

    public boolean isDictionaryEncoded() {
        return false;
    }

    public boolean isSingleValue() {
        return true;
    }

    public FieldSpec.DataType getStoredType() {
        return FieldSpec.DataType.MAP;
    }

    @Nullable
    public ChunkCompressionType getCompressionType() {
        return ChunkCompressionType.PASS_THROUGH;
    }

    public Map<String, Object> getMap(int docId, ForwardIndexReaderContext mapContext) {
        return this._forwardIndexReader.getMap(docId, mapContext);
    }

    public String getString(int docId, ForwardIndexReaderContext context) {
        return MapUtils.toString(this.getMap(docId, context));
    }
}

