/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.vector;

import com.clearspring.analytics.util.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.realtime.impl.vector.MutableVectorIndex;
import org.apache.pinot.segment.local.segment.creator.impl.vector.HnswVectorIndexCreator;
import org.apache.pinot.segment.local.segment.index.loader.invertedindex.VectorIndexHandler;
import org.apache.pinot.segment.local.segment.index.readers.vector.HnswVectorIndexReader;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.index.AbstractIndexType;
import org.apache.pinot.segment.spi.index.ColumnConfigDeserializer;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.IndexConfigDeserializer;
import org.apache.pinot.segment.spi.index.IndexHandler;
import org.apache.pinot.segment.spi.index.IndexReaderConstraintException;
import org.apache.pinot.segment.spi.index.IndexReaderFactory;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.creator.VectorIndexConfig;
import org.apache.pinot.segment.spi.index.creator.VectorIndexCreator;
import org.apache.pinot.segment.spi.index.mutable.MutableIndex;
import org.apache.pinot.segment.spi.index.mutable.provider.MutableIndexContext;
import org.apache.pinot.segment.spi.index.reader.VectorIndexReader;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;

public class VectorIndexType
extends AbstractIndexType<VectorIndexConfig, VectorIndexReader, VectorIndexCreator> {
    public static final String INDEX_DISPLAY_NAME = "vector";

    protected VectorIndexType() {
        super("vector_index");
    }

    public Class<VectorIndexConfig> getIndexConfigClass() {
        return VectorIndexConfig.class;
    }

    public VectorIndexConfig getDefaultConfig() {
        return VectorIndexConfig.DISABLED;
    }

    public String getPrettyName() {
        return INDEX_DISPLAY_NAME;
    }

    public ColumnConfigDeserializer<VectorIndexConfig> createDeserializer() {
        return IndexConfigDeserializer.fromIndexes((String)this.getPrettyName(), this.getIndexConfigClass()).withExclusiveAlternative(IndexConfigDeserializer.fromIndexTypes((FieldConfig.IndexType)FieldConfig.IndexType.VECTOR, (tableConfig, fieldConfig) -> new VectorIndexConfig(fieldConfig.getProperties())));
    }

    public VectorIndexCreator createIndexCreator(IndexCreationContext context, VectorIndexConfig indexConfig) throws IOException {
        Preconditions.checkState((context.getFieldSpec().getDataType() == FieldSpec.DataType.FLOAT && !context.getFieldSpec().isSingleValueField() ? 1 : 0) != 0, (String)"Vector index is currently only supported on float array columns");
        Preconditions.checkState((boolean)"HNSW".equals(indexConfig.getVectorIndexType()), (String)"Unsupported vector index type: %s, only 'HNSW' is support", (Object[])new Object[]{indexConfig.getVectorIndexType()});
        return new HnswVectorIndexCreator(context.getFieldSpec().getName(), context.getIndexDir(), indexConfig);
    }

    protected IndexReaderFactory<VectorIndexReader> createReaderFactory() {
        return ReaderFactory.INSTANCE;
    }

    public IndexHandler createIndexHandler(SegmentDirectory segmentDirectory, Map<String, FieldIndexConfigs> configsByCol, @Nullable Schema schema, @Nullable TableConfig tableConfig) {
        return new VectorIndexHandler(segmentDirectory, configsByCol, tableConfig);
    }

    public List<String> getFileExtensions(@Nullable ColumnMetadata columnMetadata) {
        return List.of(".vector.index", ".vector.v99.index", ".vector.v912.index");
    }

    @Nullable
    public MutableIndex createMutableIndex(MutableIndexContext context, VectorIndexConfig config) {
        if (config.isDisabled()) {
            return null;
        }
        if (!context.getFieldSpec().getDataType().equals((Object)FieldSpec.DataType.FLOAT) || context.getFieldSpec().isSingleValueField()) {
            return null;
        }
        return new MutableVectorIndex(context.getSegmentName(), context.getFieldSpec().getName(), config);
    }

    public static enum IndexType {
        HNSW;

    }

    private static class ReaderFactory
    implements IndexReaderFactory<VectorIndexReader> {
        public static final ReaderFactory INSTANCE = new ReaderFactory();

        private ReaderFactory() {
        }

        public VectorIndexReader createIndexReader(SegmentDirectory.Reader segmentReader, FieldIndexConfigs fieldIndexConfigs, ColumnMetadata metadata) throws IndexReaderConstraintException {
            if (metadata.getDataType() != FieldSpec.DataType.FLOAT || metadata.getFieldSpec().isSingleValueField()) {
                throw new IndexReaderConstraintException(metadata.getColumnName(), StandardIndexes.vector(), "HNSW Vector index is currently only supported on float array type columns");
            }
            File segmentDir = segmentReader.toSegmentDirectory().getPath().toFile();
            VectorIndexConfig indexConfig = (VectorIndexConfig)fieldIndexConfigs.getConfig(StandardIndexes.vector());
            return new HnswVectorIndexReader(metadata.getColumnName(), segmentDir, metadata.getTotalDocs(), indexConfig);
        }
    }
}

