/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.store;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.pinot.segment.local.segment.creator.impl.text.LuceneTextIndexCreator;
import org.apache.pinot.segment.local.segment.index.text.TextIndexConfigBuilder;
import org.apache.pinot.segment.spi.index.TextIndexConfig;
import org.apache.pinot.segment.spi.store.SegmentDirectoryPaths;
import org.apache.pinot.spi.config.table.FSTType;
import org.apache.pinot.spi.env.CommonsConfigurationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextIndexUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextIndexUtils.class);

    private TextIndexUtils() {
    }

    static void cleanupTextIndex(File segDir, String column) {
        File luceneIndexFile = new File(segDir, column + ".lucene.index");
        FileUtils.deleteQuietly((File)luceneIndexFile);
        File luceneMappingFile = new File(segDir, column + ".lucene.mapping");
        FileUtils.deleteQuietly((File)luceneMappingFile);
        File luceneV9IndexFile = new File(segDir, column + ".lucene.v9.index");
        FileUtils.deleteQuietly((File)luceneV9IndexFile);
        File luceneV99IndexFile = new File(segDir, column + ".lucene.v99.index");
        FileUtils.deleteQuietly((File)luceneV99IndexFile);
        File luceneV912IndexFile = new File(segDir, column + ".lucene.v912.index");
        FileUtils.deleteQuietly((File)luceneV912IndexFile);
        File luceneV9MappingFile = new File(segDir, column + ".lucene.mapping");
        FileUtils.deleteQuietly((File)luceneV9MappingFile);
        File nativeIndexFile = new File(segDir, column + ".nativetext.idx");
        FileUtils.deleteQuietly((File)nativeIndexFile);
    }

    static boolean hasTextIndex(File segDir, String column) {
        return new File(segDir, column + ".lucene.index").exists() || new File(segDir, column + ".lucene.v9.index").exists() || new File(segDir, column + ".nativetext.idx").exists() || new File(segDir, column + ".lucene.v99.index").exists() || new File(segDir, column + ".lucene.v912.index").exists();
    }

    public static boolean isFstTypeNative(@Nullable Map<String, String> textIndexProperties) {
        if (textIndexProperties == null) {
            return false;
        }
        for (Map.Entry<String, String> entry : textIndexProperties.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase("fstType")) continue;
            return entry.getValue().equalsIgnoreCase("native");
        }
        return false;
    }

    public static FSTType getFSTTypeOfIndex(File indexDir, String column) {
        return SegmentDirectoryPaths.findTextIndexIndexFile((File)indexDir, (String)column) != null ? FSTType.LUCENE : FSTType.NATIVE;
    }

    public static List<String> extractStopWordsInclude(String colName, Map<String, Map<String, String>> columnProperties) {
        return TextIndexUtils.extractStopWordsInclude(columnProperties.getOrDefault(colName, null));
    }

    public static List<String> extractStopWordsExclude(String colName, Map<String, Map<String, String>> columnProperties) {
        return TextIndexUtils.extractStopWordsExclude(columnProperties.getOrDefault(colName, null));
    }

    public static List<String> extractStopWordsInclude(Map<String, String> columnProperty) {
        return TextIndexUtils.parseEntryAsString(columnProperty, "stopWordInclude");
    }

    public static List<String> extractStopWordsExclude(Map<String, String> columnProperty) {
        return TextIndexUtils.parseEntryAsString(columnProperty, "stopWordExclude");
    }

    private static List<String> parseEntryAsString(@Nullable Map<String, String> columnProperties, String stopWordKey) {
        if (columnProperties == null) {
            return Collections.emptyList();
        }
        String includeWords = columnProperties.getOrDefault(stopWordKey, "");
        return Arrays.stream(includeWords.split(",")).map(String::trim).collect(Collectors.toList());
    }

    public static Analyzer getAnalyzer(TextIndexConfig config) throws ReflectiveOperationException {
        String luceneAnalyzerClassName = config.getLuceneAnalyzerClass();
        List luceneAnalyzerClassArgs = config.getLuceneAnalyzerClassArgs();
        List luceneAnalyzerClassArgTypes = config.getLuceneAnalyzerClassArgTypes();
        if (null == luceneAnalyzerClassName || luceneAnalyzerClassName.isEmpty() || luceneAnalyzerClassName.equals(StandardAnalyzer.class.getName()) && luceneAnalyzerClassArgs.isEmpty() && luceneAnalyzerClassArgTypes.isEmpty()) {
            return TextIndexUtils.getStandardAnalyzerWithCustomizedStopWords(config.getStopWordsInclude(), config.getStopWordsExclude());
        }
        if (luceneAnalyzerClassArgs.size() != luceneAnalyzerClassArgTypes.size()) {
            throw new ReflectiveOperationException("Mismatch of the number of analyzer arguments and arguments types.");
        }
        ArrayList argClasses = new ArrayList();
        for (String argType : luceneAnalyzerClassArgTypes) {
            argClasses.add(TextIndexUtils.parseSupportedTypes(argType));
        }
        ArrayList<Object> argValues = new ArrayList<Object>();
        for (int i = 0; i < luceneAnalyzerClassArgs.size(); ++i) {
            argValues.add(TextIndexUtils.parseSupportedTypeValues((String)luceneAnalyzerClassArgs.get(i), (Class)argClasses.get(i)));
        }
        Class<?> luceneAnalyzerClass = Class.forName(luceneAnalyzerClassName);
        if (!Analyzer.class.isAssignableFrom(luceneAnalyzerClass)) {
            String exceptionMessage = "Custom analyzer must be a child of " + Analyzer.class.getCanonicalName();
            LOGGER.error(exceptionMessage);
            throw new ReflectiveOperationException(exceptionMessage);
        }
        return (Analyzer)luceneAnalyzerClass.getConstructor(argClasses.toArray(new Class[0])).newInstance(argValues.toArray(new Object[0]));
    }

    public static Class<?> parseSupportedTypes(String valueTypeString) throws ClassNotFoundException {
        try {
            switch (valueTypeString) {
                case "java.lang.Byte.TYPE": {
                    return Byte.TYPE;
                }
                case "java.lang.Short.TYPE": {
                    return Short.TYPE;
                }
                case "java.lang.Integer.TYPE": {
                    return Integer.TYPE;
                }
                case "java.lang.Long.TYPE": {
                    return Long.TYPE;
                }
                case "java.lang.Float.TYPE": {
                    return Float.TYPE;
                }
                case "java.lang.Double.TYPE": {
                    return Double.TYPE;
                }
                case "java.lang.Boolean.TYPE": {
                    return Boolean.TYPE;
                }
                case "java.lang.Character.TYPE": {
                    return Character.TYPE;
                }
            }
            return Class.forName(valueTypeString);
        }
        catch (ClassNotFoundException ex) {
            LOGGER.error("Analyzer argument class type not found: " + valueTypeString);
            throw ex;
        }
    }

    public static Object parseSupportedTypeValues(String stringValue, Class<?> clazz) throws ReflectiveOperationException {
        try {
            if (clazz.equals(String.class)) {
                return stringValue;
            }
            if (clazz.equals(Byte.class) || clazz.equals(Byte.TYPE)) {
                return Byte.parseByte(stringValue);
            }
            if (clazz.equals(Short.class) || clazz.equals(Short.TYPE)) {
                return Short.parseShort(stringValue);
            }
            if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
                return Integer.parseInt(stringValue);
            }
            if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
                return Long.parseLong(stringValue);
            }
            if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
                return Float.valueOf(Float.parseFloat(stringValue));
            }
            if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
                return Double.parseDouble(stringValue);
            }
            if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
                String lowerCaseStringValue = stringValue.toLowerCase();
                if (lowerCaseStringValue.equals("true")) {
                    return true;
                }
                if (lowerCaseStringValue.equals("false")) {
                    return false;
                }
                throw new ReflectiveOperationException();
            }
            if (clazz.equals(Character.class) || clazz.equals(Character.TYPE)) {
                if (stringValue.length() == 1) {
                    return Character.valueOf(stringValue.charAt(0));
                }
                throw new ReflectiveOperationException();
            }
            throw new UnsupportedOperationException();
        }
        catch (NumberFormatException | ReflectiveOperationException ex) {
            String exceptionMessage = "Custom analyzer argument cannot be coerced from " + stringValue + " to " + clazz.getName() + " type";
            LOGGER.error(exceptionMessage);
            throw new ReflectiveOperationException(exceptionMessage);
        }
        catch (UnsupportedOperationException ex) {
            String exceptionMessage = "Custom analyzer argument does not support " + clazz.getName() + " type";
            LOGGER.error(exceptionMessage);
            throw new ReflectiveOperationException(exceptionMessage);
        }
    }

    public static StandardAnalyzer getStandardAnalyzerWithCustomizedStopWords(@Nullable List<String> stopWordsInclude, @Nullable List<String> stopWordsExclude) {
        HashSet<String> stopWordSet = LuceneTextIndexCreator.getDefaultEnglishStopWordsSet();
        if (stopWordsInclude != null) {
            stopWordSet.addAll(stopWordsInclude);
        }
        if (stopWordsExclude != null) {
            stopWordsExclude.forEach(stopWordSet::remove);
        }
        return new StandardAnalyzer(new CharArraySet(stopWordSet, true));
    }

    public static Constructor<QueryParserBase> getQueryParserWithStringAndAnalyzerTypeConstructor(String queryParserClassName) throws ReflectiveOperationException {
        Class<?> queryParserClass = Class.forName(queryParserClassName);
        if (!QueryParserBase.class.isAssignableFrom(queryParserClass)) {
            throw new ReflectiveOperationException("The specified lucene query parser class " + queryParserClassName + " is not assignable from " + QueryParserBase.class.getName());
        }
        try {
            queryParserClass.getConstructor(String.class, Analyzer.class);
        }
        catch (NoSuchMethodException ex) {
            throw new NoSuchMethodException("The specified lucene query parser class " + queryParserClassName + " is not assignable from does not have the required constructor method with parameter type [String.class, Analyzer.class]");
        }
        return queryParserClass.getConstructor(String.class, Analyzer.class);
    }

    public static void writeConfigToPropertiesFile(File indexDir, TextIndexConfig config) {
        PropertiesConfiguration properties = new PropertiesConfiguration();
        List escapedLuceneAnalyzerClassArgs = config.getLuceneAnalyzerClassArgs().stream().map(CommonsConfigurationUtils::replaceSpecialCharacterInPropertyValue).collect(Collectors.toList());
        List escapedLuceneAnalyzerClassArgTypes = config.getLuceneAnalyzerClassArgTypes().stream().map(CommonsConfigurationUtils::replaceSpecialCharacterInPropertyValue).collect(Collectors.toList());
        properties.setProperty("luceneAnalyzerClass", (Object)config.getLuceneAnalyzerClass());
        properties.setProperty("luceneAnalyzerClassArgs", escapedLuceneAnalyzerClassArgs);
        properties.setProperty("luceneAnalyzerClassArgTypes", escapedLuceneAnalyzerClassArgTypes);
        properties.setProperty("luceneQueryParserClass", (Object)config.getLuceneQueryParserClass());
        File propertiesFile = new File(indexDir, "lucene.properties");
        CommonsConfigurationUtils.saveToFile((PropertiesConfiguration)properties, (File)propertiesFile);
    }

    public static TextIndexConfig getUpdatedConfigFromPropertiesFile(File file, TextIndexConfig config) throws ConfigurationException {
        PropertiesConfiguration properties = CommonsConfigurationUtils.fromFile((File)file);
        List luceneAnalyzerClassArgs = properties.getList(String.class, "luceneAnalyzerClassArgs");
        List luceneAnalyzerClassArgTypes = properties.getList(String.class, "luceneAnalyzerClassArgTypes");
        ArrayList recoveredLuceneAnalyzerClassArgs = luceneAnalyzerClassArgs == null ? new ArrayList() : luceneAnalyzerClassArgs.stream().map(CommonsConfigurationUtils::recoverSpecialCharacterInPropertyValue).collect(Collectors.toList());
        ArrayList recoveredLuceneAnalyzerClassArgTypes = luceneAnalyzerClassArgTypes == null ? new ArrayList() : luceneAnalyzerClassArgTypes.stream().map(CommonsConfigurationUtils::recoverSpecialCharacterInPropertyValue).collect(Collectors.toList());
        return new TextIndexConfigBuilder(config).withLuceneAnalyzerClass(properties.getString("luceneAnalyzerClass")).withLuceneAnalyzerClassArgs(recoveredLuceneAnalyzerClassArgs).withLuceneAnalyzerClassArgTypes(recoveredLuceneAnalyzerClassArgTypes).withLuceneQueryParserClass(properties.getString("luceneQueryParserClass")).build();
    }
}

