/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.startree;

import java.util.Iterator;
import org.apache.pinot.segment.spi.index.startree.StarTreeNode;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;

public class OffHeapStarTreeNode
implements StarTreeNode {
    public static final int NUM_SERIALIZABLE_FIELDS = 7;
    public static final long SERIALIZABLE_SIZE_IN_BYTES = 28L;
    private static final int DIMENSION_ID_OFFSET = 0;
    private static final int DIMENSION_VALUE_OFFSET = 4;
    private static final int START_DOC_ID_OFFSET = 8;
    private static final int END_DOC_ID_OFFSET = 12;
    private static final int AGGREGATE_DOC_ID_OFFSET = 16;
    private static final int FIRST_CHILD_ID_OFFSET = 20;
    private static final int LAST_CHILD_ID_OFFSET = 24;
    private final PinotDataBuffer _dataBuffer;
    private final int _nodeId;
    private final int _firstChildId;

    public OffHeapStarTreeNode(PinotDataBuffer dataBuffer, int nodeId) {
        this._dataBuffer = dataBuffer;
        this._nodeId = nodeId;
        this._firstChildId = this.getInt(20);
    }

    private int getInt(int fieldOffset) {
        return this._dataBuffer.getInt((long)this._nodeId * 28L + (long)fieldOffset);
    }

    public int getDimensionId() {
        return this.getInt(0);
    }

    public int getDimensionValue() {
        return this.getInt(4);
    }

    public int getChildDimensionId() {
        if (this._firstChildId == -1) {
            return -1;
        }
        return this._dataBuffer.getInt((long)this._firstChildId * 28L);
    }

    public int getStartDocId() {
        return this.getInt(8);
    }

    public int getEndDocId() {
        return this.getInt(12);
    }

    public int getAggregatedDocId() {
        return this.getInt(16);
    }

    public int getNumChildren() {
        if (this._firstChildId == -1) {
            return 0;
        }
        return this.getInt(24) - this._firstChildId + 1;
    }

    public boolean isLeaf() {
        return this._firstChildId == -1;
    }

    public StarTreeNode getChildForDimensionValue(int dimensionValue) {
        if (this.isLeaf()) {
            return null;
        }
        if (dimensionValue == -1) {
            OffHeapStarTreeNode firstNode = new OffHeapStarTreeNode(this._dataBuffer, this._firstChildId);
            if (firstNode.getDimensionValue() == -1) {
                return firstNode;
            }
            return null;
        }
        int low = this._firstChildId;
        int high = this.getInt(24);
        while (low <= high) {
            int mid = (low + high) / 2;
            OffHeapStarTreeNode midNode = new OffHeapStarTreeNode(this._dataBuffer, mid);
            int midValue = midNode.getDimensionValue();
            if (midValue == dimensionValue) {
                return midNode;
            }
            if (midValue < dimensionValue) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return null;
    }

    public Iterator<OffHeapStarTreeNode> getChildrenIterator() {
        return new Iterator<OffHeapStarTreeNode>(){
            private int _currentChildId;
            private final int _lastChildId;
            {
                this._currentChildId = OffHeapStarTreeNode.this._firstChildId;
                this._lastChildId = OffHeapStarTreeNode.this.getInt(24);
            }

            @Override
            public boolean hasNext() {
                return this._currentChildId <= this._lastChildId;
            }

            @Override
            public OffHeapStarTreeNode next() {
                return new OffHeapStarTreeNode(OffHeapStarTreeNode.this._dataBuffer, this._currentChildId++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

