/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.auth.AuthProviderUtils;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.RequestContextUtils;
import org.apache.pinot.segment.local.segment.creator.TransformPipeline;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentIndexCreationDriverImpl;
import org.apache.pinot.segment.local.utils.SegmentPushUtils;
import org.apache.pinot.segment.spi.creator.SegmentGeneratorConfig;
import org.apache.pinot.segment.spi.creator.name.FixedSegmentNameGenerator;
import org.apache.pinot.segment.spi.creator.name.NormalizedDateSegmentNameGenerator;
import org.apache.pinot.segment.spi.creator.name.SegmentNameGenerator;
import org.apache.pinot.segment.spi.creator.name.SimpleSegmentNameGenerator;
import org.apache.pinot.segment.spi.creator.name.UploadedRealtimeSegmentNameGenerator;
import org.apache.pinot.spi.auth.AuthProvider;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.ingestion.AggregationConfig;
import org.apache.pinot.spi.config.table.ingestion.BatchIngestionConfig;
import org.apache.pinot.spi.config.table.ingestion.ComplexTypeConfig;
import org.apache.pinot.spi.config.table.ingestion.IngestionConfig;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.FileFormat;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordReaderFactory;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.filesystem.LocalPinotFS;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.filesystem.PinotFSFactory;
import org.apache.pinot.spi.ingestion.batch.BatchConfig;
import org.apache.pinot.spi.ingestion.batch.BatchConfigProperties;
import org.apache.pinot.spi.ingestion.batch.spec.PinotClusterSpec;
import org.apache.pinot.spi.ingestion.batch.spec.PushJobSpec;
import org.apache.pinot.spi.ingestion.batch.spec.SegmentGenerationJobSpec;
import org.apache.pinot.spi.ingestion.batch.spec.TableSpec;
import org.apache.pinot.spi.utils.IngestionConfigUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.apache.pinot.spi.utils.retry.AttemptsExceededException;
import org.apache.pinot.spi.utils.retry.RetriableOperationException;

public final class IngestionUtils {
    private static final PinotFS LOCAL_PINOT_FS = new LocalPinotFS();

    private IngestionUtils() {
    }

    public static SegmentGeneratorConfig generateSegmentGeneratorConfig(TableConfig tableConfig, Schema schema) throws IOException, ClassNotFoundException {
        Preconditions.checkNotNull((Object)tableConfig.getIngestionConfig(), (String)"Must provide ingestionConfig in tableConfig for table: %s, for generating SegmentGeneratorConfig", (Object)tableConfig.getTableName());
        Preconditions.checkNotNull((Object)tableConfig.getIngestionConfig().getBatchIngestionConfig(), (String)"Must provide batchIngestionConfig in tableConfig for table: %s, for generating SegmentGeneratorConfig", (Object)tableConfig.getTableName());
        return IngestionUtils.generateSegmentGeneratorConfig(tableConfig, schema, tableConfig.getIngestionConfig().getBatchIngestionConfig());
    }

    public static SegmentGeneratorConfig generateSegmentGeneratorConfig(TableConfig tableConfig, Schema schema, BatchIngestionConfig batchIngestionConfig) throws ClassNotFoundException, IOException {
        Preconditions.checkState((batchIngestionConfig != null && batchIngestionConfig.getBatchConfigMaps() != null && batchIngestionConfig.getBatchConfigMaps().size() == 1 ? 1 : 0) != 0, (String)"Must provide batchIngestionConfig and contains exactly 1 batchConfigMap for table: %s, for generating SegmentGeneratorConfig", (Object)tableConfig.getTableName());
        BatchConfig batchConfig = new BatchConfig(tableConfig.getTableName(), (Map)batchIngestionConfig.getBatchConfigMaps().get(0));
        SegmentGeneratorConfig segmentGeneratorConfig = new SegmentGeneratorConfig(tableConfig, schema);
        segmentGeneratorConfig.setInputFilePath(batchConfig.getInputDirURI());
        segmentGeneratorConfig.setOutDir(batchConfig.getOutputDirURI());
        segmentGeneratorConfig.setRecordReaderPath(RecordReaderFactory.getRecordReaderClassName((String)batchConfig.getInputFormat().toString()));
        Map recordReaderProps = batchConfig.getRecordReaderProps();
        segmentGeneratorConfig.setReaderConfig(RecordReaderFactory.getRecordReaderConfig((FileFormat)batchConfig.getInputFormat(), (Map)IngestionConfigUtils.getRecordReaderProps((Map)recordReaderProps)));
        SegmentNameGenerator segmentNameGenerator = IngestionUtils.getSegmentNameGenerator(batchConfig, batchIngestionConfig.getSegmentIngestionType(), batchIngestionConfig.getSegmentIngestionFrequency(), tableConfig, schema);
        segmentGeneratorConfig.setSegmentNameGenerator(segmentNameGenerator);
        String sequenceId = batchConfig.getSequenceId();
        if (StringUtils.isNumeric((CharSequence)sequenceId)) {
            segmentGeneratorConfig.setSequenceId(Integer.parseInt(sequenceId));
        }
        return segmentGeneratorConfig;
    }

    private static SegmentNameGenerator getSegmentNameGenerator(BatchConfig batchConfig, String pushType, String pushFrequency, TableConfig tableConfig, Schema schema) {
        String segmentNameGeneratorType;
        String rawTableName = TableNameBuilder.extractRawTableName((String)batchConfig.getTableNameWithType());
        switch (segmentNameGeneratorType = batchConfig.getSegmentNameGeneratorType()) {
            case "fixed": {
                return new FixedSegmentNameGenerator(batchConfig.getSegmentName());
            }
            case "normalizedDate": {
                DateTimeFieldSpec dateTimeFieldSpec;
                DateTimeFormatSpec dateTimeFormatSpec = null;
                String timeColumnName = tableConfig.getValidationConfig().getTimeColumnName();
                if (timeColumnName != null && (dateTimeFieldSpec = schema.getSpecForTimeColumn(timeColumnName)) != null) {
                    dateTimeFormatSpec = dateTimeFieldSpec.getFormatSpec();
                }
                return new NormalizedDateSegmentNameGenerator(rawTableName, batchConfig.getSegmentNamePrefix(), batchConfig.isExcludeSequenceId(), pushType, pushFrequency, dateTimeFormatSpec, batchConfig.getSegmentNamePostfix(), batchConfig.isAppendUUIDToSegmentName());
            }
            case "simple": {
                return new SimpleSegmentNameGenerator(rawTableName, batchConfig.getSegmentNamePostfix(), batchConfig.isAppendUUIDToSegmentName(), batchConfig.isExcludeTimeInSegmentName());
            }
            case "uploadedRealtime": {
                int uploadedRealtimePartitionId;
                try {
                    uploadedRealtimePartitionId = Integer.parseInt(batchConfig.getSegmentPartitionId());
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(String.format("Invalid segment partition id: %s", batchConfig.getSegmentPartitionId()));
                }
                return new UploadedRealtimeSegmentNameGenerator(rawTableName, uploadedRealtimePartitionId, batchConfig.getSegmentUploadTimeMs(), batchConfig.getSegmentNamePrefix(), batchConfig.getSequenceId());
            }
        }
        throw new IllegalStateException(String.format("Unsupported segmentNameGeneratorType: %s for table: %s", segmentNameGeneratorType, tableConfig.getTableName()));
    }

    public static String buildSegment(SegmentGeneratorConfig segmentGeneratorConfig) throws Exception {
        SegmentIndexCreationDriverImpl driver = new SegmentIndexCreationDriverImpl();
        driver.init(segmentGeneratorConfig);
        driver.build();
        return driver.getSegmentName();
    }

    public static void uploadSegment(String tableNameWithType, BatchConfig batchConfig, List<URI> segmentTarURIs, @Nullable AuthProvider authProvider) throws Exception {
        SegmentGenerationJobSpec segmentUploadSpec = IngestionUtils.generateSegmentUploadSpec(tableNameWithType, batchConfig, authProvider);
        List<String> segmentTarURIStrs = segmentTarURIs.stream().map(URI::toString).collect(Collectors.toList());
        String pushMode = batchConfig.getPushMode();
        switch (BatchConfigProperties.SegmentPushType.valueOf((String)pushMode.toUpperCase())) {
            case TAR: {
                try {
                    SegmentPushUtils.pushSegments(segmentUploadSpec, LOCAL_PINOT_FS, segmentTarURIStrs);
                    break;
                }
                catch (AttemptsExceededException | RetriableOperationException e) {
                    throw new RuntimeException(String.format("Caught exception while uploading segments. Push mode: TAR, segment tars: [%s]", segmentTarURIStrs), e);
                }
            }
            case URI: {
                ArrayList<String> segmentUris = new ArrayList<String>();
                try {
                    URI outputSegmentDirURI = null;
                    if (StringUtils.isNotBlank((CharSequence)batchConfig.getOutputSegmentDirURI())) {
                        outputSegmentDirURI = URI.create(batchConfig.getOutputSegmentDirURI());
                    }
                    for (URI segmentTarURI : segmentTarURIs) {
                        URI updatedURI = SegmentPushUtils.generateSegmentTarURI(outputSegmentDirURI, segmentTarURI, segmentUploadSpec.getPushJobSpec().getSegmentUriPrefix(), segmentUploadSpec.getPushJobSpec().getSegmentUriSuffix());
                        segmentUris.add(updatedURI.toString());
                    }
                    SegmentPushUtils.sendSegmentUris(segmentUploadSpec, segmentUris);
                    break;
                }
                catch (AttemptsExceededException | RetriableOperationException e) {
                    throw new RuntimeException(String.format("Caught exception while uploading segments. Push mode: URI, segment URIs: [%s]", segmentUris), e);
                }
            }
            case METADATA: {
                try {
                    URI outputSegmentDirURI = null;
                    if (StringUtils.isNotBlank((CharSequence)batchConfig.getOutputSegmentDirURI())) {
                        outputSegmentDirURI = URI.create(batchConfig.getOutputSegmentDirURI());
                    }
                    PinotFS outputFileFS = IngestionUtils.getOutputPinotFS(batchConfig, outputSegmentDirURI);
                    Map<String, String> segmentUriToTarPathMap = SegmentPushUtils.getSegmentUriToTarPathMap(outputSegmentDirURI, segmentUploadSpec.getPushJobSpec(), segmentTarURIStrs.toArray(new String[0]));
                    SegmentPushUtils.sendSegmentUriAndMetadata(segmentUploadSpec, outputFileFS, segmentUriToTarPathMap);
                    break;
                }
                catch (AttemptsExceededException | RetriableOperationException e) {
                    throw new RuntimeException(String.format("Caught exception while uploading segments. Push mode: METADATA, segment URIs: [%s]", segmentTarURIStrs), e);
                }
            }
            default: {
                throw new UnsupportedOperationException("Unrecognized push mode - " + pushMode);
            }
        }
    }

    private static SegmentGenerationJobSpec generateSegmentUploadSpec(String tableName, BatchConfig batchConfig, @Nullable AuthProvider authProvider) {
        TableSpec tableSpec = new TableSpec();
        tableSpec.setTableName(tableName);
        PinotClusterSpec pinotClusterSpec = new PinotClusterSpec();
        pinotClusterSpec.setControllerURI(batchConfig.getPushControllerURI());
        PinotClusterSpec[] pinotClusterSpecs = new PinotClusterSpec[]{pinotClusterSpec};
        PushJobSpec pushJobSpec = new PushJobSpec();
        pushJobSpec.setPushAttempts(batchConfig.getPushAttempts());
        pushJobSpec.setPushParallelism(batchConfig.getPushParallelism());
        pushJobSpec.setPushRetryIntervalMillis(batchConfig.getPushIntervalRetryMillis());
        pushJobSpec.setSegmentUriPrefix(batchConfig.getPushSegmentURIPrefix());
        pushJobSpec.setSegmentUriSuffix(batchConfig.getPushSegmentURISuffix());
        SegmentGenerationJobSpec spec = new SegmentGenerationJobSpec();
        spec.setPushJobSpec(pushJobSpec);
        spec.setTableSpec(tableSpec);
        spec.setPinotClusterSpecs(pinotClusterSpecs);
        spec.setAuthToken(AuthProviderUtils.toStaticToken((AuthProvider)authProvider));
        return spec;
    }

    public static PinotFS getOutputPinotFS(BatchConfig batchConfig, URI fileURI) {
        String fileURIScheme;
        String string = fileURIScheme = fileURI == null ? null : fileURI.getScheme();
        if (fileURIScheme == null) {
            fileURIScheme = "file";
        }
        if (!PinotFSFactory.isSchemeSupported((String)fileURIScheme)) {
            IngestionUtils.registerPinotFS(fileURIScheme, batchConfig.getOutputFsClassName(), IngestionConfigUtils.getOutputFsProps((Map)batchConfig.getBatchConfigMap()));
        }
        return PinotFSFactory.create((String)fileURIScheme);
    }

    private static void registerPinotFS(String fileURIScheme, String fsClass, PinotConfiguration fsProps) {
        PinotFSFactory.register((String)fileURIScheme, (String)fsClass, (PinotConfiguration)fsProps);
    }

    public static Set<String> getFieldsForRecordExtractor(TableConfig tableConfig, Schema schema) {
        List aggregationConfigs;
        IngestionConfig ingestionConfig = tableConfig.getIngestionConfig();
        if (ingestionConfig != null && ingestionConfig.getSchemaConformingTransformerConfig() != null) {
            return Set.of();
        }
        HashSet<String> fields = new HashSet<String>();
        if (ingestionConfig != null && (aggregationConfigs = ingestionConfig.getAggregationConfigs()) != null) {
            for (AggregationConfig aggregationConfig : aggregationConfigs) {
                ExpressionContext expressionContext = RequestContextUtils.getExpression((String)aggregationConfig.getAggregationFunction());
                expressionContext.getColumns(fields);
            }
        }
        fields.addAll(new TransformPipeline(tableConfig, schema).getInputColumns());
        return IngestionUtils.getFieldsToReadWithComplexType(fields, ingestionConfig);
    }

    private static Set<String> getFieldsToReadWithComplexType(Set<String> fieldsToRead, IngestionConfig ingestionConfig) {
        if (ingestionConfig == null || ingestionConfig.getComplexTypeConfig() == null) {
            return fieldsToRead;
        }
        ComplexTypeConfig complexTypeConfig = ingestionConfig.getComplexTypeConfig();
        HashSet<String> result = new HashSet<String>();
        String delimiter = complexTypeConfig.getDelimiter() == null ? "." : complexTypeConfig.getDelimiter();
        for (String field : fieldsToRead) {
            result.add(StringUtils.splitByWholeSeparator((String)field, (String)delimiter)[0]);
        }
        return result;
    }

    public static boolean shouldIngestRow(GenericRow genericRow) {
        return !Boolean.TRUE.equals(genericRow.getValue("$SKIP_RECORD_KEY$"));
    }

    public static Long extractTimeValue(Comparable time) {
        if (time != null) {
            if (time instanceof Number) {
                return ((Number)((Object)time)).longValue();
            }
            String stringValue = time.toString();
            if (StringUtils.isNumeric((CharSequence)stringValue)) {
                return Long.parseLong(stringValue);
            }
        }
        return null;
    }
}

