/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.partition.PartitionFunction;
import org.apache.pinot.spi.annotations.InterfaceAudience;
import org.apache.pinot.spi.data.FieldSpec;

@InterfaceAudience.Private
public interface ColumnMetadata {
    public FieldSpec getFieldSpec();

    default public String getColumnName() {
        return this.getFieldSpec().getName();
    }

    default public FieldSpec.FieldType getFieldType() {
        return this.getFieldSpec().getFieldType();
    }

    default public FieldSpec.DataType getDataType() {
        return this.getFieldSpec().getDataType();
    }

    default public boolean isSingleValue() {
        return this.getFieldSpec().isSingleValueField();
    }

    public int getTotalDocs();

    public int getCardinality();

    public boolean isSorted();

    public Comparable getMinValue();

    public Comparable getMaxValue();

    @JsonProperty
    public boolean hasDictionary();

    public int getColumnMaxLength();

    public char getPaddingCharacter();

    public int getBitsPerElement();

    public int getMaxNumberOfMultiValues();

    public int getTotalNumberOfEntries();

    @Nullable
    public PartitionFunction getPartitionFunction();

    @Nullable
    public Set<Integer> getPartitions();

    public boolean isAutoGenerated();
}

