/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.creator.name;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.creator.name.SegmentNameGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputFileSegmentNameGenerator
implements SegmentNameGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputFileSegmentNameGenerator.class);
    private static final String PARAMETER_TEMPLATE = "${filePathPattern:\\%d}";
    private Pattern _filePathPattern;
    private String _segmentNameTemplate;
    private URI _inputFileUri;
    private String _segmentName;

    public InputFileSegmentNameGenerator(String filePathPattern, String segmentNameTemplate, String inputFileUri) throws URISyntaxException {
        this._filePathPattern = Pattern.compile(filePathPattern);
        this._segmentNameTemplate = segmentNameTemplate;
        this._inputFileUri = new URI(inputFileUri);
        this._segmentName = this.makeSegmentName();
    }

    private String makeSegmentName() {
        String inputFilePath = this._inputFileUri.getPath();
        Matcher m = this._filePathPattern.matcher(inputFilePath);
        if (!m.matches()) {
            LOGGER.warn(String.format("No match for pattern '%s' in '%s'", this._filePathPattern, inputFilePath));
            return this.safeConvertPathToFilename(inputFilePath);
        }
        String segmentName = this._segmentNameTemplate;
        for (int i = 1; i <= m.groupCount(); ++i) {
            segmentName = segmentName.replace(String.format(PARAMETER_TEMPLATE, i), m.group(i));
        }
        return segmentName;
    }

    @Override
    public String generateSegmentName(int sequenceId, @Nullable Object minTimeValue, @Nullable Object maxTimeValue) {
        return this._segmentName;
    }

    private String safeConvertPathToFilename(String inputFilePath) {
        inputFilePath = inputFilePath.replaceFirst("^[/]+", "");
        return inputFilePath.replaceAll("[/\\.]", "_");
    }

    public String toString() {
        return String.format("InputFileSegmentNameGenerator: filePathPattern=%s, segmentNameTemplate=%s, inputFileUri=%s, segmentName=%s", this._filePathPattern, this._segmentNameTemplate, this._inputFileUri, this._segmentName);
    }
}

