/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.creator.name;

import com.google.common.base.Preconditions;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.creator.name.SegmentNameGenerator;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DateTimeFormatSpec;

public class NormalizedDateSegmentNameGenerator
implements SegmentNameGenerator {
    private static final String PUSH_FREQUENCY_HOURLY = "hourly";
    private final String _segmentNamePrefix;
    private final boolean _excludeSequenceId;
    private final boolean _appendPushType;
    private final String _segmentNamePostfix;
    private final SimpleDateFormat _outputSDF;
    private final TimeUnit _inputTimeUnit;
    private final SimpleDateFormat _inputSDF;

    public NormalizedDateSegmentNameGenerator(String tableName, @Nullable String segmentNamePrefix, boolean excludeSequenceId, @Nullable String pushType, @Nullable String pushFrequency, @Nullable DateTimeFormatSpec dateTimeFormatSpec, @Nullable String segmentNamePostfix) {
        this._segmentNamePrefix = segmentNamePrefix != null ? segmentNamePrefix.trim() : tableName;
        Preconditions.checkArgument((this._segmentNamePrefix != null && this.isValidSegmentName(this._segmentNamePrefix) ? 1 : 0) != 0);
        this._excludeSequenceId = excludeSequenceId;
        this._appendPushType = "APPEND".equalsIgnoreCase(pushType);
        this._segmentNamePostfix = segmentNamePostfix != null ? segmentNamePostfix.trim() : null;
        Preconditions.checkArgument((this._segmentNamePostfix == null || this.isValidSegmentName(this._segmentNamePostfix) ? 1 : 0) != 0);
        if (this._appendPushType) {
            this._outputSDF = PUSH_FREQUENCY_HOURLY.equalsIgnoreCase(pushFrequency) ? new SimpleDateFormat("yyyy-MM-dd-HH") : new SimpleDateFormat("yyyy-MM-dd");
            this._outputSDF.setTimeZone(TimeZone.getTimeZone("UTC"));
            Preconditions.checkNotNull((Object)dateTimeFormatSpec);
            DateTimeFieldSpec.TimeFormat timeFormat = dateTimeFormatSpec.getTimeFormat();
            if (timeFormat == DateTimeFieldSpec.TimeFormat.EPOCH) {
                this._inputTimeUnit = dateTimeFormatSpec.getColumnUnit();
                this._inputSDF = null;
            } else {
                Preconditions.checkNotNull((Object)dateTimeFormatSpec.getSDFPattern(), (Object)"Must provide pattern for SIMPLE_DATE_FORMAT");
                this._inputTimeUnit = null;
                this._inputSDF = new SimpleDateFormat(dateTimeFormatSpec.getSDFPattern());
                this._inputSDF.setTimeZone(TimeZone.getTimeZone("UTC"));
            }
        } else {
            this._outputSDF = null;
            this._inputTimeUnit = null;
            this._inputSDF = null;
        }
    }

    @Override
    public String generateSegmentName(int sequenceId, @Nullable Object minTimeValue, @Nullable Object maxTimeValue) {
        Integer sequenceIdInSegmentName;
        Integer n = sequenceIdInSegmentName = !this._excludeSequenceId && sequenceId >= 0 ? Integer.valueOf(sequenceId) : null;
        if (this._appendPushType) {
            return JOINER.join((Object)this._segmentNamePrefix, (Object)this.getNormalizedDate(Preconditions.checkNotNull((Object)minTimeValue)), new Object[]{this.getNormalizedDate(Preconditions.checkNotNull((Object)maxTimeValue)), this._segmentNamePostfix, sequenceIdInSegmentName});
        }
        return JOINER.join((Object)this._segmentNamePrefix, (Object)this._segmentNamePostfix, new Object[]{sequenceIdInSegmentName});
    }

    public String getNormalizedDate(Object timeValue) {
        if (this._inputTimeUnit != null) {
            return this._outputSDF.format(new Date(this._inputTimeUnit.toMillis(Long.parseLong(timeValue.toString()))));
        }
        try {
            return this._outputSDF.format(this._inputSDF.parse(timeValue.toString()));
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Caught exception while parsing simple date format: %s with value: %s", this._inputSDF.toPattern(), timeValue), e);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("NormalizedDateSegmentNameGenerator: segmentNamePrefix=").append(this._segmentNamePrefix);
        if (this._segmentNamePostfix != null) {
            stringBuilder.append(", segmentNamePostfix=").append(this._segmentNamePostfix);
        }
        stringBuilder.append(", appendPushType=").append(this._appendPushType);
        if (this._excludeSequenceId) {
            stringBuilder.append(", excludeSequenceId=true");
        }
        if (this._outputSDF != null) {
            stringBuilder.append(", outputSDF=").append(this._outputSDF.toPattern());
        }
        if (this._inputTimeUnit != null) {
            stringBuilder.append(", inputTimeUnit=").append((Object)this._inputTimeUnit);
        }
        if (this._inputSDF != null) {
            stringBuilder.append(", inputSDF=").append(this._inputSDF.toPattern());
        }
        return stringBuilder.toString();
    }
}

