/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.loader;

import com.google.common.base.Predicate;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pinot.segment.spi.loader.SegmentDirectoryLoader;
import org.apache.pinot.segment.spi.loader.SegmentLoader;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentDirectoryLoaderRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentDirectoryLoaderRegistry.class);
    public static final String DEFAULT_SEGMENT_DIRECTORY_LOADER_NAME = "default";
    private static final Map<String, SegmentDirectoryLoader> SEGMENT_DIRECTORY_LOADER_MAP = new ConcurrentHashMap<String, SegmentDirectoryLoader>();

    private SegmentDirectoryLoaderRegistry() {
    }

    public static SegmentDirectoryLoader getSegmentDirectoryLoader(String segmentDirectoryLoader) {
        return SEGMENT_DIRECTORY_LOADER_MAP.get(segmentDirectoryLoader);
    }

    public static void setSegmentDirectoryLoader(String segmentDirectoryLoaderName, SegmentDirectoryLoader loader) {
        SEGMENT_DIRECTORY_LOADER_MAP.put(segmentDirectoryLoaderName, loader);
    }

    public static SegmentDirectoryLoader getDefaultSegmentDirectoryLoader() {
        return SEGMENT_DIRECTORY_LOADER_MAP.get(DEFAULT_SEGMENT_DIRECTORY_LOADER_NAME);
    }

    static {
        long startTime = System.currentTimeMillis();
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)"org.apache.pinot.segment", (ClassLoader[])new ClassLoader[0])).filterInputsBy((Predicate)new FilterBuilder.Include(".*\\.loader\\..*")).setScanners(new Scanner[]{new ResourcesScanner(), new TypeAnnotationsScanner(), new SubTypesScanner()}));
        Set classes = reflections.getTypesAnnotatedWith(SegmentLoader.class);
        classes.forEach(loaderClass -> {
            SegmentLoader segmentLoaderAnnotation = loaderClass.getAnnotation(SegmentLoader.class);
            if (segmentLoaderAnnotation.enabled()) {
                if (segmentLoaderAnnotation.name().isEmpty()) {
                    LOGGER.error("Cannot register an unnamed SegmentDirectoryLoader for annotation {} ", (Object)segmentLoaderAnnotation);
                } else {
                    String segmentLoaderName = segmentLoaderAnnotation.name();
                    try {
                        SegmentDirectoryLoader segmentDirectoryLoader = (SegmentDirectoryLoader)loaderClass.newInstance();
                        SEGMENT_DIRECTORY_LOADER_MAP.putIfAbsent(segmentLoaderName, segmentDirectoryLoader);
                    }
                    catch (Exception e) {
                        LOGGER.error(String.format("Unable to register SegmentDirectoryLoader %s . Cannot instantiate.", segmentLoaderName), (Throwable)e);
                    }
                }
            }
        });
        LOGGER.info("Initialized SegmentDirectoryLoaderRegistry with {} segmentDirectoryLoaders: {} in {} ms", new Object[]{SEGMENT_DIRECTORY_LOADER_MAP.size(), SEGMENT_DIRECTORY_LOADER_MAP.keySet(), System.currentTimeMillis() - startTime});
    }
}

