/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.partition;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import org.apache.pinot.segment.spi.partition.PartitionFunction;

public class MurmurPartitionFunction
implements PartitionFunction {
    private static final String NAME = "Murmur";
    private final int _numPartitions;

    public MurmurPartitionFunction(int numPartitions) {
        Preconditions.checkArgument((numPartitions > 0 ? 1 : 0) != 0, (Object)"Number of partitions must be > 0");
        this._numPartitions = numPartitions;
    }

    @Override
    public int getPartition(Object value) {
        return (this.murmur2(value.toString().getBytes(StandardCharsets.UTF_8)) & Integer.MAX_VALUE) % this._numPartitions;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getNumPartitions() {
        return this._numPartitions;
    }

    public String toString() {
        return NAME;
    }

    @VisibleForTesting
    int murmur2(byte[] data) {
        int length = data.length;
        int seed = -1756908916;
        int m = 1540483477;
        int r = 24;
        int h = seed ^ length;
        int length4 = length / 4;
        for (int i = 0; i < length4; ++i) {
            int i4 = i * 4;
            int k = (data[i4 + 0] & 0xFF) + ((data[i4 + 1] & 0xFF) << 8) + ((data[i4 + 2] & 0xFF) << 16) + ((data[i4 + 3] & 0xFF) << 24);
            k *= 1540483477;
            k ^= k >>> 24;
            h *= 1540483477;
            h ^= (k *= 1540483477);
        }
        switch (length % 4) {
            case 3: {
                h ^= (data[(length & 0xFFFFFFFC) + 2] & 0xFF) << 16;
            }
            case 2: {
                h ^= (data[(length & 0xFFFFFFFC) + 1] & 0xFF) << 8;
            }
            case 1: {
                h ^= data[length & 0xFFFFFFFC] & 0xFF;
                h *= 1540483477;
            }
        }
        h ^= h >>> 13;
        h *= 1540483477;
        h ^= h >>> 15;
        return h;
    }
}

