/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.partition;

import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.segment.spi.partition.BoundedColumnValuePartitionFunction;
import org.apache.pinot.segment.spi.partition.ByteArrayPartitionFunction;
import org.apache.pinot.segment.spi.partition.HashCodePartitionFunction;
import org.apache.pinot.segment.spi.partition.ModuloPartitionFunction;
import org.apache.pinot.segment.spi.partition.MurmurPartitionFunction;
import org.apache.pinot.segment.spi.partition.PartitionFunction;

public class PartitionFunctionFactory {
    private PartitionFunctionFactory() {
    }

    public static PartitionFunction getPartitionFunction(String functionName, int numPartitions, Map<String, String> functionConfig) {
        PartitionFunctionType function = PartitionFunctionType.fromString(functionName);
        switch (function) {
            case Modulo: {
                return new ModuloPartitionFunction(numPartitions);
            }
            case Murmur: {
                return new MurmurPartitionFunction(numPartitions);
            }
            case ByteArray: {
                return new ByteArrayPartitionFunction(numPartitions);
            }
            case HashCode: {
                return new HashCodePartitionFunction(numPartitions);
            }
            case BoundedColumnValue: {
                return new BoundedColumnValuePartitionFunction(numPartitions, functionConfig);
            }
        }
        throw new IllegalArgumentException("Illegal partition function name: " + functionName);
    }

    public static enum PartitionFunctionType {
        Modulo,
        Murmur,
        ByteArray,
        HashCode,
        BoundedColumnValue;

        private static final Map<String, PartitionFunctionType> VALUE_MAP;

        public static PartitionFunctionType fromString(String name) {
            PartitionFunctionType functionType = VALUE_MAP.get(name.toLowerCase());
            if (functionType == null) {
                throw new IllegalArgumentException("No enum constant for: " + name);
            }
            return functionType;
        }

        static {
            VALUE_MAP = new HashMap<String, PartitionFunctionType>();
            for (PartitionFunctionType functionType : PartitionFunctionType.values()) {
                VALUE_MAP.put(functionType.name().toLowerCase(), functionType);
            }
        }
    }
}

