/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.loader;

import java.util.Map;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.env.PinotConfiguration;

public class SegmentDirectoryLoaderContext {
    private final TableConfig _tableConfig;
    private final Schema _schema;
    private final String _instanceId;
    private final String _tableDataDir;
    private final String _segmentName;
    private final String _segmentCrc;
    private final String _segmentTier;
    private final Map<String, Map<String, String>> _instanceTierConfigs;
    private final PinotConfiguration _segmentDirectoryConfigs;

    private SegmentDirectoryLoaderContext(TableConfig tableConfig, Schema schema, String instanceId, String tableDataDir, String segmentName, String segmentCrc, String segmentTier, Map<String, Map<String, String>> instanceTierConfigs, PinotConfiguration segmentDirectoryConfigs) {
        this._tableConfig = tableConfig;
        this._schema = schema;
        this._instanceId = instanceId;
        this._tableDataDir = tableDataDir;
        this._segmentName = segmentName;
        this._segmentCrc = segmentCrc;
        this._segmentTier = segmentTier;
        this._instanceTierConfigs = instanceTierConfigs;
        this._segmentDirectoryConfigs = segmentDirectoryConfigs;
    }

    public TableConfig getTableConfig() {
        return this._tableConfig;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public String getInstanceId() {
        return this._instanceId;
    }

    public String getTableDataDir() {
        return this._tableDataDir;
    }

    public String getSegmentName() {
        return this._segmentName;
    }

    public String getSegmentCrc() {
        return this._segmentCrc;
    }

    public String getSegmentTier() {
        return this._segmentTier;
    }

    public PinotConfiguration getSegmentDirectoryConfigs() {
        return this._segmentDirectoryConfigs;
    }

    public Map<String, Map<String, String>> getInstanceTierConfigs() {
        return this._instanceTierConfigs;
    }

    public static class Builder {
        private TableConfig _tableConfig;
        private Schema _schema;
        private String _instanceId;
        private String _tableDataDir;
        private String _segmentName;
        private String _segmentCrc;
        private String _segmentTier;
        private Map<String, Map<String, String>> _instanceTierConfigs;
        private PinotConfiguration _segmentDirectoryConfigs;

        public Builder setTableConfig(TableConfig tableConfig) {
            this._tableConfig = tableConfig;
            return this;
        }

        public Builder setSchema(Schema schema) {
            this._schema = schema;
            return this;
        }

        public Builder setInstanceId(String instanceId) {
            this._instanceId = instanceId;
            return this;
        }

        public Builder setTableDataDir(String tableDataDir) {
            this._tableDataDir = tableDataDir;
            return this;
        }

        public Builder setSegmentName(String segmentName) {
            this._segmentName = segmentName;
            return this;
        }

        public Builder setSegmentCrc(String segmentCrc) {
            this._segmentCrc = segmentCrc;
            return this;
        }

        public Builder setSegmentTier(String segmentTier) {
            this._segmentTier = segmentTier;
            return this;
        }

        public Builder setInstanceTierConfigs(Map<String, Map<String, String>> instanceTierConfigs) {
            this._instanceTierConfigs = instanceTierConfigs;
            return this;
        }

        public Builder setSegmentDirectoryConfigs(PinotConfiguration segmentDirectoryConfigs) {
            this._segmentDirectoryConfigs = segmentDirectoryConfigs;
            return this;
        }

        public SegmentDirectoryLoaderContext build() {
            return new SegmentDirectoryLoaderContext(this._tableConfig, this._schema, this._instanceId, this._tableDataDir, this._segmentName, this._segmentCrc, this._segmentTier, this._instanceTierConfigs, this._segmentDirectoryConfigs);
        }
    }
}

